/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftfr.roleplaychat.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import net.minecraftfr.roleplaychat.ChatManager;
import net.minecraftfr.roleplaychat.chatTypeMessage.ActionMessage;
import net.minecraftfr.roleplaychat.chatTypeMessage.GlobalOOCMessage;
import net.minecraftfr.roleplaychat.chatTypeMessage.MessageType;
import net.minecraftfr.roleplaychat.chatTypeMessage.OOCMessage;
import net.minecraftfr.roleplaychat.chatTypeMessage.ShoutMessage;
import net.minecraftfr.roleplaychat.chatTypeMessage.SpeakMessage;
import net.minecraftfr.roleplaychat.chatTypeMessage.SupportMessage;
import net.minecraftfr.roleplaychat.chatTypeMessage.WhisperMessage;

public class RoleplayChatCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"speak").then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String message = StringArgumentType.getString((CommandContext)context, (String)"message");
            SpeakMessage speakMessage = new SpeakMessage(message);
            RoleplayChatCommands.sendMessageFromCommand(speakMessage, (CommandContext<class_2168>)context);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"shout").then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String message = StringArgumentType.getString((CommandContext)context, (String)"message");
            ShoutMessage shoutMessage = new ShoutMessage("!" + message);
            RoleplayChatCommands.sendMessageFromCommand(shoutMessage, (CommandContext<class_2168>)context);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"whisper").then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String message = StringArgumentType.getString((CommandContext)context, (String)"message");
            WhisperMessage whisperMessage = new WhisperMessage(WhisperMessage.CHARACTERS[0] + message);
            RoleplayChatCommands.sendMessageFromCommand(whisperMessage, (CommandContext<class_2168>)context);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"action").then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String message = StringArgumentType.getString((CommandContext)context, (String)"message");
            ActionMessage actionMessage = new ActionMessage("*" + message);
            RoleplayChatCommands.sendMessageFromCommand(actionMessage, (CommandContext<class_2168>)context);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"globalOoc").then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String message = StringArgumentType.getString((CommandContext)context, (String)"message");
            GlobalOOCMessage globalOOCMessage = new GlobalOOCMessage("[" + message);
            RoleplayChatCommands.sendMessageFromCommand(globalOOCMessage, (CommandContext<class_2168>)context);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"ooc").then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String message = StringArgumentType.getString((CommandContext)context, (String)"message");
            OOCMessage oOCMessage = new OOCMessage("(" + message);
            RoleplayChatCommands.sendMessageFromCommand(oOCMessage, (CommandContext<class_2168>)context);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"support").then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String message = StringArgumentType.getString((CommandContext)context, (String)"message");
            SupportMessage supportMessage = new SupportMessage("?" + message);
            RoleplayChatCommands.sendMessageFromCommand(supportMessage, (CommandContext<class_2168>)context);
            return 1;
        })));
    }

    private static void sendMessageFromCommand(MessageType messageType, CommandContext<class_2168> context) {
        List players = ((class_2168)context.getSource()).method_9211().method_3760().method_14571();
        class_3222 sender = (class_3222)players.get(0);
        if (!players.isEmpty()) {
            ChatManager.sendMessageToPlayerListFromPosition(sender, players, messageType);
        }
    }
}

