/*
 * Decompiled with CFR 0.152.
 */
package games.twinhead.moreslabsstairsandwalls.block.honey;

import games.twinhead.moreslabsstairsandwalls.block.ModBlocks;
import games.twinhead.moreslabsstairsandwalls.block.slime.SlimeSlab;
import games.twinhead.moreslabsstairsandwalls.block.translucent.TranslucentSlab;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_174;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3726;
import net.minecraft.class_4970;

public class HoneySlab
extends TranslucentSlab {
    protected static final class_265 FULL_SHAPE = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    public static final class_265 BOTTOM_SHAPE = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);
    public static final class_265 TOP_SHAPE = class_2248.method_9541((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public HoneySlab(ModBlocks modBlocks, class_4970.class_2251 settings) {
        super(modBlocks, settings);
    }

    public static boolean hasHoneyBlockEffects(class_1297 entity) {
        return entity instanceof class_1309 || entity instanceof class_1688 || entity instanceof class_1541 || entity instanceof class_1690;
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2771 slabType = (class_2771)state.method_11654((class_2769)field_11501);
        return switch (slabType) {
            case class_2771.field_12682 -> FULL_SHAPE;
            case class_2771.field_12679 -> TOP_SHAPE;
            default -> BOTTOM_SHAPE;
        };
    }

    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        entity.method_5783(class_3417.field_21074, 1.0f, 1.0f);
        if (!world.field_9236) {
            world.method_8421(entity, (byte)54);
        }
        if (entity.method_5747(fallDistance, 0.2f, world.method_48963().method_48827())) {
            entity.method_5783(this.field_23162.method_10593(), this.field_23162.method_10597() * 0.5f, this.field_23162.method_10599() * 0.75f);
        }
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (this.isSliding(pos, entity)) {
            HoneySlab.triggerAdvancement(entity, pos);
            HoneySlab.updateSlidingVelocity(entity);
            HoneySlab.addCollisionEffects(world, entity);
        }
        super.method_9548(state, world, pos, entity);
    }

    private boolean isSliding(class_2338 pos, class_1297 entity) {
        double maxY;
        if (entity.method_24828()) {
            return false;
        }
        class_2771 slabType = (class_2771)entity.method_37908().method_8320(pos).method_11654((class_2769)field_11501);
        switch (slabType) {
            case field_12682: 
            case field_12679: {
                double d = 0.9375;
                break;
            }
            default: {
                double d = maxY = 0.4375;
            }
        }
        if (entity.method_23318() > (double)pos.method_10264() + maxY - 1.0E-7) {
            return false;
        }
        if (entity.method_18798().field_1351 >= -0.08) {
            return false;
        }
        double d = Math.abs((double)pos.method_10263() + 0.5 - entity.method_23317());
        double e = Math.abs((double)pos.method_10260() + 0.5 - entity.method_23321());
        double f = 0.4375 + (double)(entity.method_17681() / 2.0f);
        return d + 1.0E-7 > f || e + 1.0E-7 > f;
    }

    public static void triggerAdvancement(class_1297 entity, class_2338 ignoredPos) {
        if (entity instanceof class_3222 && entity.method_37908().method_8510() % 20L == 0L) {
            class_174.field_21628.method_23909((class_3222)entity, class_2246.field_21211.method_9564());
        }
    }

    public static void updateSlidingVelocity(class_1297 entity) {
        class_243 vec3d = entity.method_18798();
        if (vec3d.field_1351 < -0.13) {
            double d = -0.05 / vec3d.field_1351;
            entity.method_18799(new class_243(vec3d.field_1352 * d, -0.05, vec3d.field_1350 * d));
        } else {
            entity.method_18799(new class_243(vec3d.field_1352, -0.05, vec3d.field_1350));
        }
        entity.method_38785();
    }

    public static void addCollisionEffects(class_1937 world, class_1297 entity) {
        if (HoneySlab.hasHoneyBlockEffects(entity)) {
            if (world.field_9229.method_43048(5) == 0) {
                entity.method_5783(class_3417.field_21074, 1.0f, 1.0f);
            }
            if (!world.field_9236 && world.field_9229.method_43048(5) == 0) {
                world.method_8421(entity, (byte)53);
            }
        }
    }

    public boolean isStickyBlock(class_2680 state) {
        return SlimeSlab.isStateHoney(state) || SlimeSlab.isStateSlime(state);
    }

    public boolean canStickTo(class_2680 state, class_2680 other) {
        if (SlimeSlab.isStateSlime(state) && SlimeSlab.isStateHoney(other)) {
            return false;
        }
        if (SlimeSlab.isStateSlime(other) && SlimeSlab.isStateHoney(state)) {
            return false;
        }
        return this.isStickyBlock(state) || this.isStickyBlock(other);
    }
}

