/*
 * Decompiled with CFR 0.152.
 */
package games.twinhead.moreslabsstairsandwalls.datagen;

import games.twinhead.moreslabsstairsandwalls.block.ModBlocks;
import java.util.Optional;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2778;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4917;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;
import net.minecraft.class_7923;

public class ModelGenerator
extends FabricModelProvider {
    public ModelGenerator(FabricDataOutput dataGenerator) {
        super(dataGenerator);
    }

    public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
        for (ModBlocks modBlock : ModBlocks.values()) {
            if (modBlock.hasBlock(ModBlocks.BlockType.SLAB).booleanValue()) {
                this.createSlabBlockState(modBlock, blockStateModelGenerator);
            }
            if (modBlock.hasBlock(ModBlocks.BlockType.STAIRS).booleanValue()) {
                this.createStairsBlockState(modBlock, blockStateModelGenerator);
            }
            if (!modBlock.hasBlock(ModBlocks.BlockType.WALL).booleanValue()) continue;
            this.createWallBlockState(modBlock, blockStateModelGenerator);
        }
    }

    public void generateItemModels(class_4915 itemModelGenerator) {
    }

    private void createSlabBlockState(ModBlocks block, class_4910 blockStateModelGenerator) {
        class_4944 textureMap = this.getTextureMap(block);
        class_2960 slab = null;
        class_2960 slabTop = null;
        class_2960 slabDouble = this.getResourceId(class_7923.field_41175.method_10221((Object)block.parentBlock));
        switch (block.modelType) {
            case LOG: {
                textureMap.method_25868(class_4945.field_23018, class_2960.method_60655((String)"minecraft", (String)("block/" + class_7923.field_41175.method_10221((Object)block.parentBlock).toString().split(":")[1])));
                break;
            }
            case GRASS: {
                textureMap.method_25868(class_4945.field_23006, this.getIdWithSuffix(this.getResourceId(class_7923.field_41175.method_10221((Object)block.parentBlock)), block.equals((Object)ModBlocks.GRASS_BLOCK) ? "_side_overlay" : "_side"));
                textureMap.method_25868(class_4945.field_23014, this.getResourceId(class_7923.field_41175.method_10221((Object)(block.equals((Object)ModBlocks.CRIMSON_NYLIUM) || block.equals((Object)ModBlocks.WARPED_NYLIUM) ? class_2246.field_10515 : class_2246.field_10566))));
                if (block.equals((Object)ModBlocks.CRIMSON_NYLIUM) || block.equals((Object)ModBlocks.WARPED_NYLIUM)) {
                    textureMap.method_25868(class_4945.field_23015, this.getResourceId(class_7923.field_41175.method_10221((Object)block.parentBlock)));
                }
                slab = this.getTemplateModel("template_grass_slab", class_4945.field_23018, class_4945.field_23015, class_4945.field_23014, class_4945.field_23006).method_25852(this.getResourceId(block.getId(ModBlocks.BlockType.SLAB)), textureMap, blockStateModelGenerator.field_22831);
                slabTop = this.getTemplateModel("template_grass_slab_top", class_4945.field_23018, class_4945.field_23015, class_4945.field_23014, class_4945.field_23006).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.SLAB)), "_top"), textureMap, blockStateModelGenerator.field_22831);
                break;
            }
            case LEAVES: {
                slab = this.getTemplateModel("template_leaves_slab", class_4945.field_23010).method_25852(this.getResourceId(block.getId(ModBlocks.BlockType.SLAB)), textureMap, blockStateModelGenerator.field_22831);
                slabTop = this.getTemplateModel("template_leaves_slab_top", class_4945.field_23010).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.SLAB)), "_top"), textureMap, blockStateModelGenerator.field_22831);
                slabDouble = this.getTemplateModel("template_leaves_slab_double", class_4945.field_23010).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.SLAB)), "_double"), textureMap, blockStateModelGenerator.field_22831);
                break;
            }
            case GLASS: {
                textureMap.method_25868(class_4945.field_23018, this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.SLAB)), "_side"));
                textureMap.method_25868(class_4945.field_23013, this.getResourceId(class_7923.field_41175.method_10221((Object)block.parentBlock)));
                slab = this.getTemplateModel("template_glass_slab", class_4945.field_23013, class_4945.field_23018).method_25852(this.getResourceId(block.getId(ModBlocks.BlockType.SLAB)), textureMap, blockStateModelGenerator.field_22831);
                slabTop = this.getTemplateModel("template_glass_slab_top", class_4945.field_23013, class_4945.field_23018).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.SLAB)), "_top"), textureMap, blockStateModelGenerator.field_22831);
                slabDouble = this.getTemplateModel("template_glass_slab_double", class_4945.field_23010).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.SLAB)), "_double"), textureMap, blockStateModelGenerator.field_22831);
                break;
            }
            case PATH: 
            case SLIME: 
            case HONEY: 
            case ROOTS: {
                return;
            }
            case GLAZED_TERRACOTTA: {
                textureMap.method_25868(class_4945.field_23010, this.getResourceId(class_7923.field_41175.method_10221((Object)block.parentBlock)));
                slab = this.getTemplateModel("glazed_terracotta_slab", class_4945.field_23010).method_25852(this.getResourceId(block.getId(ModBlocks.BlockType.SLAB)), textureMap, blockStateModelGenerator.field_22831);
                slabTop = this.getTemplateModel("glazed_terracotta_slab_top", class_4945.field_23010).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.SLAB)), "_top"), textureMap, blockStateModelGenerator.field_22831);
                blockStateModelGenerator.field_22830.accept(ModelGenerator.createRotatableSlabBlockState(block.getBlock(ModBlocks.BlockType.SLAB), slab, slabTop, this.getResourceId(class_7923.field_41175.method_10221((Object)block.parentBlock)), false));
                return;
            }
            case CUSTOM: {
                if (!block.toString().contains("waxed")) break;
                slabDouble = class_2960.method_60655((String)"minecraft", (String)("block/" + block.textureId));
                break;
            }
            case TRANSLUCENT: {
                textureMap.method_25868(class_4945.field_23010, this.getResourceId(class_7923.field_41175.method_10221((Object)block.parentBlock)));
                slab = this.getTemplateModel("translucent_slab", class_4945.field_23010).method_25852(this.getResourceId(block.getId(ModBlocks.BlockType.SLAB)), textureMap, blockStateModelGenerator.field_22831);
                slabTop = this.getTemplateModel("translucent_slab_top", class_4945.field_23010).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.SLAB)), "_top"), textureMap, blockStateModelGenerator.field_22831);
            }
        }
        if (slab == null) {
            slab = class_4943.field_22909.method_25846(block.getBlock(ModBlocks.BlockType.SLAB), textureMap, blockStateModelGenerator.field_22831);
        }
        if (slabTop == null) {
            slabTop = class_4943.field_22910.method_25846(block.getBlock(ModBlocks.BlockType.SLAB), textureMap, blockStateModelGenerator.field_22831);
        }
        blockStateModelGenerator.field_22830.accept(ModelGenerator.createSlabBlockState(block.getBlock(ModBlocks.BlockType.SLAB), slab, slabTop, slabDouble));
    }

    private void createStairsBlockState(ModBlocks block, class_4910 blockStateModelGenerator) {
        class_4944 textureMap = this.getTextureMap(block);
        class_2960 stair = null;
        class_2960 inner = null;
        class_2960 outer = null;
        switch (block.modelType) {
            case LOG: {
                textureMap.method_25868(class_4945.field_23018, class_2960.method_60655((String)"minecraft", (String)("block/" + class_7923.field_41175.method_10221((Object)block.parentBlock).toString().split(":")[1])));
                break;
            }
            case GRASS: {
                class_4945[] textureKeys = new class_4945[]{class_4945.field_23018, class_4945.field_23015, class_4945.field_23014, class_4945.field_23006};
                textureMap.method_25868(class_4945.field_23006, this.getIdWithSuffix(this.getResourceId(class_7923.field_41175.method_10221((Object)block.parentBlock)), block.equals((Object)ModBlocks.GRASS_BLOCK) ? "_side_overlay" : "_side"));
                textureMap.method_25868(class_4945.field_23014, this.getResourceId(class_7923.field_41175.method_10221((Object)(block.equals((Object)ModBlocks.CRIMSON_NYLIUM) || block.equals((Object)ModBlocks.WARPED_NYLIUM) ? class_2246.field_10515 : class_2246.field_10566))));
                if (block.equals((Object)ModBlocks.CRIMSON_NYLIUM) || block.equals((Object)ModBlocks.WARPED_NYLIUM)) {
                    textureMap.method_25868(class_4945.field_23015, this.getResourceId(class_7923.field_41175.method_10221((Object)block.parentBlock)));
                }
                stair = this.getTemplateModel("template_grass_stairs", textureKeys).method_25852(this.getResourceId(block.getId(ModBlocks.BlockType.STAIRS)), textureMap, blockStateModelGenerator.field_22831);
                inner = this.getTemplateModel("template_grass_stairs_inner", textureKeys).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.STAIRS)), "_inner"), textureMap, blockStateModelGenerator.field_22831);
                outer = this.getTemplateModel("template_grass_stairs_outer", textureKeys).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.STAIRS)), "_outer"), textureMap, blockStateModelGenerator.field_22831);
                class_2960 stairUp = this.getTemplateModel("template_grass_stairs_up", textureKeys).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.STAIRS)), "_up"), textureMap, blockStateModelGenerator.field_22831);
                class_2960 innerUp = this.getTemplateModel("template_grass_stairs_inner_up", textureKeys).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.STAIRS)), "_inner_up"), textureMap, blockStateModelGenerator.field_22831);
                class_2960 outerUp = this.getTemplateModel("template_grass_stairs_outer_up", textureKeys).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.STAIRS)), "_outer_up"), textureMap, blockStateModelGenerator.field_22831);
                blockStateModelGenerator.field_22830.accept(ModelGenerator.createGrassStairsBlockState(block.getBlock(ModBlocks.BlockType.STAIRS), stair, inner, outer, stairUp, innerUp, outerUp, block.modelType == ModBlocks.ModelType.GRASS));
                return;
            }
            case LEAVES: {
                stair = this.getTemplateModel("template_leaves_stairs", class_4945.field_23010).method_25852(this.getResourceId(block.getId(ModBlocks.BlockType.STAIRS)), textureMap, blockStateModelGenerator.field_22831);
                inner = this.getTemplateModel("template_leaves_stairs_inner", class_4945.field_23010).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.STAIRS)), "_inner"), textureMap, blockStateModelGenerator.field_22831);
                outer = this.getTemplateModel("template_leaves_stairs_outer", class_4945.field_23010).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.STAIRS)), "_outer"), textureMap, blockStateModelGenerator.field_22831);
                break;
            }
            case GLAZED_TERRACOTTA: {
                stair = this.getTemplateModel("glazed_terracotta_stairs", class_4945.field_23010).method_25852(this.getResourceId(block.getId(ModBlocks.BlockType.STAIRS)), textureMap, blockStateModelGenerator.field_22831);
                inner = this.getTemplateModel("glazed_terracotta_stairs_inner", class_4945.field_23010).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.STAIRS)), "_inner"), textureMap, blockStateModelGenerator.field_22831);
                outer = this.getTemplateModel("glazed_terracotta_stairs_outer", class_4945.field_23010).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.STAIRS)), "_outer"), textureMap, blockStateModelGenerator.field_22831);
                break;
            }
            case GLASS: {
                textureMap.method_25868(class_4945.field_23014, this.getResourceId(class_7923.field_41175.method_10221((Object)block.parentBlock)));
                textureMap.method_25868(class_4945.field_23016, this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.SLAB)), "_side"));
                textureMap.method_25868(class_4945.field_23015, this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.STAIRS)), "_small"));
                textureMap.method_25868(class_4945.field_23018, this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.STAIRS)), "_side"));
                stair = this.getTemplateModel("template_glass_stairs", class_4945.field_23014, class_4945.field_23016, class_4945.field_23015, class_4945.field_23018).method_25852(this.getResourceId(block.getId(ModBlocks.BlockType.STAIRS)), textureMap, blockStateModelGenerator.field_22831);
                inner = this.getTemplateModel("template_glass_stairs_inner", class_4945.field_23014, class_4945.field_23016, class_4945.field_23015, class_4945.field_23018).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.STAIRS)), "_inner"), textureMap, blockStateModelGenerator.field_22831);
                outer = this.getTemplateModel("template_glass_stairs_outer", class_4945.field_23014, class_4945.field_23016, class_4945.field_23015, class_4945.field_23018).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.STAIRS)), "_outer"), textureMap, blockStateModelGenerator.field_22831);
                break;
            }
            case TRANSLUCENT: {
                textureMap.method_25868(class_4945.field_23010, this.getResourceId(class_7923.field_41175.method_10221((Object)block.parentBlock)));
                stair = this.getTemplateModel("translucent_stairs", class_4945.field_23010).method_25852(this.getResourceId(block.getId(ModBlocks.BlockType.STAIRS)), textureMap, blockStateModelGenerator.field_22831);
                inner = this.getTemplateModel("translucent_stairs_inner", class_4945.field_23010).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.STAIRS)), "_inner"), textureMap, blockStateModelGenerator.field_22831);
                outer = this.getTemplateModel("translucent_stairs_outer", class_4945.field_23010).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.STAIRS)), "_outer"), textureMap, blockStateModelGenerator.field_22831);
                break;
            }
            case PATH: 
            case SLIME: 
            case HONEY: 
            case ROOTS: {
                return;
            }
        }
        if (stair == null) {
            stair = class_4943.field_22912.method_25846(block.getBlock(ModBlocks.BlockType.STAIRS), textureMap, blockStateModelGenerator.field_22831);
        }
        if (inner == null) {
            inner = class_4943.field_22913.method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.STAIRS)), "_inner"), textureMap, blockStateModelGenerator.field_22831);
        }
        if (outer == null) {
            outer = class_4943.field_22914.method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.STAIRS)), "_outer"), textureMap, blockStateModelGenerator.field_22831);
        }
        blockStateModelGenerator.field_22830.accept(ModelGenerator.createStairsBlockState(block.getBlock(ModBlocks.BlockType.STAIRS), stair, inner, outer, block.modelType != ModBlocks.ModelType.GLASS && block.modelType != ModBlocks.ModelType.GLAZED_TERRACOTTA));
    }

    private void createWallBlockState(ModBlocks block, class_4910 blockStateModelGenerator) {
        class_2960 tall;
        class_2960 low;
        class_2960 post;
        if (block.modelType == ModBlocks.ModelType.PATH || block.modelType == ModBlocks.ModelType.GLASS || block.equals((Object)ModBlocks.ICE) || block.equals((Object)ModBlocks.SLIME_BLOCK) || block.equals((Object)ModBlocks.HONEY_BLOCK)) {
            return;
        }
        class_4944 textureMap = this.getTextureMap(block);
        blockStateModelGenerator.method_25538(block.getBlock(ModBlocks.BlockType.WALL).method_8389(), switch (block.modelType) {
            case ModBlocks.ModelType.GRASS -> {
                textureMap.method_25868(class_4945.field_23006, this.getIdWithSuffix(this.getResourceId(class_7923.field_41175.method_10221((Object)block.parentBlock)), block.equals((Object)ModBlocks.GRASS_BLOCK) ? "_side_overlay" : "_side"));
                textureMap.method_25868(class_4945.field_23014, this.getResourceId(class_7923.field_41175.method_10221((Object)(block.equals((Object)ModBlocks.CRIMSON_NYLIUM) || block.equals((Object)ModBlocks.WARPED_NYLIUM) ? class_2246.field_10515 : class_2246.field_10566))));
                if (block.equals((Object)ModBlocks.CRIMSON_NYLIUM) || block.equals((Object)ModBlocks.WARPED_NYLIUM)) {
                    textureMap.method_25868(class_4945.field_23015, this.getResourceId(class_7923.field_41175.method_10221((Object)block.parentBlock)));
                }
                textureMap.method_25868(class_4945.field_23018, this.getIdWithSuffix(this.getResourceId(class_7923.field_41175.method_10221((Object)block.parentBlock)), "_side"));
                post = this.getTemplateModel("template_grass_wall_post", class_4945.field_23014, class_4945.field_23015, class_4945.field_23018, class_4945.field_23006).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.WALL)), "_post"), textureMap, blockStateModelGenerator.field_22831);
                low = this.getTemplateModel("template_grass_wall_side", class_4945.field_23014, class_4945.field_23015, class_4945.field_23018, class_4945.field_23006).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.WALL)), "_side"), textureMap, blockStateModelGenerator.field_22831);
                tall = this.getTemplateModel("template_grass_wall_side_tall", class_4945.field_23014, class_4945.field_23015, class_4945.field_23018, class_4945.field_23006).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.WALL)), "_side_tall"), textureMap, blockStateModelGenerator.field_22831);
                yield this.getTemplateModel("template_grass_wall_inventory", class_4945.field_23014, class_4945.field_23015, class_4945.field_23018, class_4945.field_23006).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.WALL)), "_inventory"), textureMap, blockStateModelGenerator.field_22831);
            }
            case ModBlocks.ModelType.LOG -> {
                textureMap.method_25868(class_4945.field_23018, class_2960.method_60655((String)"minecraft", (String)("block/" + class_7923.field_41175.method_10221((Object)block.parentBlock).toString().split(":")[1])));
                textureMap.method_25868(class_4945.field_23014, class_2960.method_60655((String)"minecraft", (String)("block/" + class_7923.field_41175.method_10221((Object)block.parentBlock).toString().split(":")[1] + "_top")));
                post = this.getTemplateModel("template_column_wall_post", class_4945.field_23014, class_4945.field_23015, class_4945.field_23018).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.WALL)), "_post"), textureMap, blockStateModelGenerator.field_22831);
                low = this.getTemplateModel("template_column_wall_side", class_4945.field_23014, class_4945.field_23015, class_4945.field_23018).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.WALL)), "_side"), textureMap, blockStateModelGenerator.field_22831);
                tall = this.getTemplateModel("template_column_wall_side_tall", class_4945.field_23014, class_4945.field_23015, class_4945.field_23018).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.WALL)), "_side_tall"), textureMap, blockStateModelGenerator.field_22831);
                yield this.getTemplateModel("template_column_wall_inventory", class_4945.field_23014, class_4945.field_23015, class_4945.field_23018).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.WALL)), "_inventory"), textureMap, blockStateModelGenerator.field_22831);
            }
            case ModBlocks.ModelType.LEAVES -> {
                post = this.getTemplateModel("template_leaves_wall_post", class_4945.field_23027).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.WALL)), "_post"), textureMap, blockStateModelGenerator.field_22831);
                low = this.getTemplateModel("template_leaves_wall_side", class_4945.field_23027).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.WALL)), "_side"), textureMap, blockStateModelGenerator.field_22831);
                tall = this.getTemplateModel("template_leaves_wall_side_tall", class_4945.field_23027).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.WALL)), "_side_tall"), textureMap, blockStateModelGenerator.field_22831);
                yield this.getTemplateModel("template_leaves_wall_inventory", class_4945.field_23027).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.WALL)), "_inventory"), textureMap, blockStateModelGenerator.field_22831);
            }
            case ModBlocks.ModelType.ROOTS, ModBlocks.ModelType.CUBE_BOTTOM_TOP -> {
                textureMap.method_25868(class_4945.field_23014, class_2960.method_60655((String)"minecraft", (String)("block/" + class_7923.field_41175.method_10221((Object)block.parentBlock).toString().split(":")[1] + "_top")));
                post = this.getTemplateModel("template_column_wall_post", class_4945.field_23014, class_4945.field_23015, class_4945.field_23018).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.WALL)), "_post"), textureMap, blockStateModelGenerator.field_22831);
                low = this.getTemplateModel("template_column_wall_side", class_4945.field_23014, class_4945.field_23015, class_4945.field_23018).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.WALL)), "_side"), textureMap, blockStateModelGenerator.field_22831);
                tall = this.getTemplateModel("template_column_wall_side_tall", class_4945.field_23014, class_4945.field_23015, class_4945.field_23018).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.WALL)), "_side_tall"), textureMap, blockStateModelGenerator.field_22831);
                yield this.getTemplateModel("template_column_wall_inventory", class_4945.field_23014, class_4945.field_23015, class_4945.field_23018).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.WALL)), "_inventory"), textureMap, blockStateModelGenerator.field_22831);
            }
            case ModBlocks.ModelType.CUSTOM_SIDE_BOTTOM_TOP -> {
                post = this.getTemplateModel("template_column_wall_post", class_4945.field_23014, class_4945.field_23015, class_4945.field_23018).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.WALL)), "_post"), textureMap, blockStateModelGenerator.field_22831);
                low = this.getTemplateModel("template_column_wall_side", class_4945.field_23014, class_4945.field_23015, class_4945.field_23018).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.WALL)), "_side"), textureMap, blockStateModelGenerator.field_22831);
                tall = this.getTemplateModel("template_column_wall_side_tall", class_4945.field_23014, class_4945.field_23015, class_4945.field_23018).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.WALL)), "_side_tall"), textureMap, blockStateModelGenerator.field_22831);
                yield this.getTemplateModel("template_column_wall_inventory", class_4945.field_23014, class_4945.field_23015, class_4945.field_23018).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.WALL)), "_inventory"), textureMap, blockStateModelGenerator.field_22831);
            }
            case ModBlocks.ModelType.TRANSLUCENT -> {
                post = this.getTemplateModel("translucent_wall_post", class_4945.field_23027).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.WALL)), "_post"), textureMap, blockStateModelGenerator.field_22831);
                low = this.getTemplateModel("translucent_wall_side", class_4945.field_23027).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.WALL)), "_side"), textureMap, blockStateModelGenerator.field_22831);
                tall = this.getTemplateModel("translucent_wall_side_tall", class_4945.field_23027).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.WALL)), "_side_tall"), textureMap, blockStateModelGenerator.field_22831);
                yield this.getTemplateModel("translucent_wall_inventory", class_4945.field_23027).method_25852(this.getIdWithSuffix(this.getResourceId(block.getId(ModBlocks.BlockType.WALL)), "_inventory"), textureMap, blockStateModelGenerator.field_22831);
            }
            default -> {
                post = class_4943.field_22991.method_25846(block.getBlock(ModBlocks.BlockType.WALL), textureMap, blockStateModelGenerator.field_22831);
                low = class_4943.field_22992.method_25846(block.getBlock(ModBlocks.BlockType.WALL), textureMap, blockStateModelGenerator.field_22831);
                tall = class_4943.field_22993.method_25846(block.getBlock(ModBlocks.BlockType.WALL), textureMap, blockStateModelGenerator.field_22831);
                yield class_4943.field_22994.method_25846(block.getBlock(ModBlocks.BlockType.WALL), textureMap, blockStateModelGenerator.field_22831);
            }
        });
        blockStateModelGenerator.field_22830.accept(class_4910.method_25636((class_2248)block.getBlock(ModBlocks.BlockType.WALL), (class_2960)post, (class_2960)low, (class_2960)tall));
    }

    private class_4944 getTextureMap(ModBlocks block) {
        return switch (block.modelType) {
            case ModBlocks.ModelType.LOG, ModBlocks.ModelType.GRASS, ModBlocks.ModelType.CUBE_BOTTOM_TOP -> class_4946.field_23038.get(block.parentBlock).method_25921();
            case ModBlocks.ModelType.LEAVES -> class_4946.field_23049.get(block.parentBlock).method_25921();
            case ModBlocks.ModelType.CUSTOM -> new class_4944().method_25868(class_4945.field_23010, class_2960.method_60655((String)"minecraft", (String)("block/" + block.textureId)));
            case ModBlocks.ModelType.CUSTOM_SIDE_BOTTOM_TOP -> new class_4944().method_25868(class_4945.field_23018, class_2960.method_60655((String)"minecraft", (String)("block/" + block.textureId))).method_25868(class_4945.field_23014, class_2960.method_60655((String)"minecraft", (String)("block/" + block.bottomId))).method_25868(class_4945.field_23015, class_2960.method_60655((String)"minecraft", (String)("block/" + block.topId)));
            case ModBlocks.ModelType.SLIME -> new class_4944().method_25868(class_4945.field_23010, class_2960.method_60655((String)"minecraft", (String)"block/slime_block"));
            case ModBlocks.ModelType.ROOTS -> new class_4944().method_25868(class_4945.field_23018, class_2960.method_60655((String)"minecraft", (String)"block/mangrove_roots_side")).method_25868(class_4945.field_23015, class_2960.method_60655((String)"minecraft", (String)"block/mangrove_roots_top"));
            case ModBlocks.ModelType.HONEY -> new class_4944().method_25868(class_4945.field_23010, class_2960.method_60655((String)"minecraft", (String)"block/honey_block_bottom"));
            default -> class_4946.field_23036.get(block.parentBlock).method_25921();
        };
    }

    private class_4942 getTemplateModel(String templateName, class_4945 ... requiredTextureKeys) {
        return new class_4942(Optional.of(class_2960.method_60655((String)"more_slabs_stairs_and_walls", (String)("block/" + templateName))), Optional.empty(), requiredTextureKeys);
    }

    private class_2960 getResourceId(class_2960 id) {
        return class_2960.method_60655((String)id.method_12836(), (String)("block/" + id.method_12832()));
    }

    private class_2960 getIdWithSuffix(class_2960 id, String suffix) {
        return class_2960.method_60655((String)id.method_12836(), (String)(id.method_12832() + suffix));
    }

    public static class_4917 createSlabBlockState(class_2248 slabBlock, class_2960 bottomModelId, class_2960 topModelId, class_2960 fullModelId) {
        return class_4925.method_25769((class_2248)slabBlock).method_25775((class_4926)class_4926.method_25783((class_2769)class_2741.field_12485).method_25793((Comparable)class_2771.field_12681, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)bottomModelId)).method_25793((Comparable)class_2771.field_12679, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)topModelId)).method_25793((Comparable)class_2771.field_12682, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)fullModelId)));
    }

    public static class_4917 createStairsBlockState(class_2248 stairsBlock, class_2960 regularModelId, class_2960 innerModelId, class_2960 outerModelId, boolean uvLock) {
        return class_4925.method_25769((class_2248)stairsBlock).method_25775((class_4926)class_4926.method_25785((class_2769)class_2741.field_12481, (class_2769)class_2741.field_12518, (class_2769)class_2741.field_12503).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12710, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)regularModelId)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12710, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)regularModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12710, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)regularModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12710, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)regularModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12709, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outerModelId)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12709, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outerModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12709, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outerModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12709, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outerModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12708, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outerModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12708, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outerModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12708, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outerModelId)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12708, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outerModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12713, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)innerModelId)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12713, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)innerModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12713, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)innerModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12713, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)innerModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12712, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)innerModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12712, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)innerModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12712, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)innerModelId)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12712, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)innerModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12710, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)regularModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12710, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)regularModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12710, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)regularModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12710, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)regularModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12709, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outerModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12709, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outerModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12709, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outerModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12709, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outerModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12708, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outerModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12708, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outerModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12708, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outerModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12708, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outerModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12713, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)innerModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12713, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)innerModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12713, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)innerModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12713, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)innerModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12712, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)innerModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12712, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)innerModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12712, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)innerModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12712, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)innerModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)uvLock)));
    }

    public static class_4917 createGrassStairsBlockState(class_2248 stairsBlock, class_2960 regular, class_2960 inner, class_2960 outer, class_2960 regularUp, class_2960 innerUp, class_2960 outerUp, boolean uvLock) {
        return class_4925.method_25769((class_2248)stairsBlock).method_25775((class_4926)class_4926.method_25785((class_2769)class_2741.field_12481, (class_2769)class_2741.field_12518, (class_2769)class_2741.field_12503).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12710, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)regular)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12710, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)regular).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12710, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)regular).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12710, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)regular).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12709, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outer)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12709, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outer).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12709, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outer).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12709, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outer).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12708, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outer).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12708, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outer).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12708, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outer)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12708, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outer).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12713, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)inner)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12713, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)inner).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12713, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)inner).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12713, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)inner).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12712, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)inner).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12712, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)inner).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12712, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)inner)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12712, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)inner).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12710, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)regularUp).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12710, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)regularUp).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12710, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)regularUp).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12710, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)regularUp).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12709, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outerUp).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12709, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outerUp).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12709, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outerUp).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12709, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outerUp).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12708, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outerUp).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12708, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outerUp).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12708, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outerUp).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12708, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)outerUp).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12713, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)innerUp).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12713, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)innerUp).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12713, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)innerUp).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12713, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)innerUp).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12712, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)innerUp).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12712, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)innerUp).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12712, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)innerUp).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)uvLock)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12712, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)innerUp).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)uvLock)));
    }

    public static class_4917 createRotatableSlabBlockState(class_2248 slabBlock, class_2960 bottomId, class_2960 topId, class_2960 doubleId, boolean uvlock) {
        return class_4925.method_25769((class_2248)slabBlock).method_25775((class_4926)class_4926.method_25784((class_2769)class_2741.field_12485, (class_2769)class_2741.field_12481).method_25797((Comparable)class_2771.field_12681, (Comparable)class_2350.field_11034, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)bottomId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22890).method_25828(class_4936.field_22888, (Object)uvlock)).method_25797((Comparable)class_2771.field_12681, (Comparable)class_2350.field_11039, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)bottomId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvlock)).method_25797((Comparable)class_2771.field_12681, (Comparable)class_2350.field_11035, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)bottomId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)uvlock)).method_25797((Comparable)class_2771.field_12681, (Comparable)class_2350.field_11043, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)bottomId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)uvlock)).method_25797((Comparable)class_2771.field_12682, (Comparable)class_2350.field_11034, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)doubleId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22890).method_25828(class_4936.field_22888, (Object)uvlock)).method_25797((Comparable)class_2771.field_12682, (Comparable)class_2350.field_11039, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)doubleId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvlock)).method_25797((Comparable)class_2771.field_12682, (Comparable)class_2350.field_11035, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)doubleId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)uvlock)).method_25797((Comparable)class_2771.field_12682, (Comparable)class_2350.field_11043, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)doubleId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)uvlock)).method_25797((Comparable)class_2771.field_12679, (Comparable)class_2350.field_11034, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)topId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22890).method_25828(class_4936.field_22888, (Object)uvlock)).method_25797((Comparable)class_2771.field_12679, (Comparable)class_2350.field_11039, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)topId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)uvlock)).method_25797((Comparable)class_2771.field_12679, (Comparable)class_2350.field_11035, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)topId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)uvlock)).method_25797((Comparable)class_2771.field_12679, (Comparable)class_2350.field_11043, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)topId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)uvlock)));
    }
}

