/*
 * Decompiled with CFR 0.152.
 */
package games.twinhead.moreslabsstairsandwalls.datagen;

import games.twinhead.moreslabsstairsandwalls.block.ModBlocks;
import games.twinhead.moreslabsstairsandwalls.registry.ModTags;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2454;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_8790;
import org.jetbrains.annotations.Nullable;

public class RecipeGenerator
extends FabricRecipeProvider {
    public static final List<ModBlocks> planks = List.of(ModBlocks.ACACIA_PLANKS, ModBlocks.BIRCH_PLANKS, ModBlocks.CRIMSON_PLANKS, ModBlocks.DARK_OAK_PLANKS, ModBlocks.JUNGLE_PLANKS, ModBlocks.OAK_PLANKS, ModBlocks.SPRUCE_PLANKS, ModBlocks.WARPED_PLANKS, ModBlocks.MANGROVE_PLANKS, ModBlocks.CHERRY_PLANKS, ModBlocks.BAMBOO_PLANKS);
    private final List<ModBlocks> copper = List.of(ModBlocks.COPPER_BLOCK, ModBlocks.OXIDIZED_COPPER, ModBlocks.WEATHERED_COPPER, ModBlocks.EXPOSED_COPPER, ModBlocks.WAXED_COPPER_BLOCK, ModBlocks.WAXED_OXIDIZED_COPPER, ModBlocks.WAXED_WEATHERED_COPPER, ModBlocks.WAXED_EXPOSED_COPPER);
    private final List<ModBlocks> waxedCopper = List.of(ModBlocks.WAXED_COPPER_BLOCK, ModBlocks.WAXED_OXIDIZED_COPPER, ModBlocks.WAXED_WEATHERED_COPPER, ModBlocks.WAXED_EXPOSED_COPPER, ModBlocks.WAXED_CUT_COPPER, ModBlocks.WAXED_OXIDIZED_CUT_COPPER, ModBlocks.WAXED_WEATHERED_CUT_COPPER, ModBlocks.WAXED_EXPOSED_CUT_COPPER);
    private final List<ModBlocks> glass = List.of(ModBlocks.GLASS, ModBlocks.WHITE_STAINED_GLASS, ModBlocks.YELLOW_STAINED_GLASS, ModBlocks.BLACK_STAINED_GLASS, ModBlocks.RED_STAINED_GLASS, ModBlocks.PURPLE_STAINED_GLASS, ModBlocks.PINK_STAINED_GLASS, ModBlocks.ORANGE_STAINED_GLASS, ModBlocks.MAGENTA_STAINED_GLASS, ModBlocks.LIME_STAINED_GLASS, ModBlocks.LIGHT_GRAY_STAINED_GLASS, ModBlocks.LIGHT_BLUE_STAINED_GLASS, ModBlocks.GREEN_STAINED_GLASS, ModBlocks.GRAY_STAINED_GLASS, ModBlocks.CYAN_STAINED_GLASS, ModBlocks.BROWN_STAINED_GLASS, ModBlocks.BLUE_STAINED_GLASS);
    public static final List<ModBlocks> logBlocks = List.of(ModBlocks.ACACIA_LOG, ModBlocks.BIRCH_LOG, ModBlocks.CRIMSON_STEM, ModBlocks.DARK_OAK_LOG, ModBlocks.JUNGLE_LOG, ModBlocks.OAK_LOG, ModBlocks.SPRUCE_LOG, ModBlocks.WARPED_STEM, ModBlocks.MANGROVE_LOG, ModBlocks.CHERRY_LOG, ModBlocks.BAMBOO_BLOCK, ModBlocks.STRIPPED_ACACIA_LOG, ModBlocks.STRIPPED_BIRCH_LOG, ModBlocks.STRIPPED_CRIMSON_STEM, ModBlocks.STRIPPED_DARK_OAK_LOG, ModBlocks.STRIPPED_JUNGLE_LOG, ModBlocks.STRIPPED_OAK_LOG, ModBlocks.STRIPPED_SPRUCE_LOG, ModBlocks.STRIPPED_WARPED_STEM, ModBlocks.STRIPPED_MANGROVE_LOG, ModBlocks.STRIPPED_CHERRY_LOG, ModBlocks.STRIPPED_BAMBOO_BLOCK, ModBlocks.ACACIA_WOOD, ModBlocks.BIRCH_WOOD, ModBlocks.CRIMSON_HYPHAE, ModBlocks.DARK_OAK_WOOD, ModBlocks.JUNGLE_WOOD, ModBlocks.OAK_WOOD, ModBlocks.SPRUCE_WOOD, ModBlocks.WARPED_HYPHAE, ModBlocks.MANGROVE_WOOD, ModBlocks.CHERRY_WOOD, ModBlocks.STRIPPED_ACACIA_WOOD, ModBlocks.STRIPPED_BIRCH_WOOD, ModBlocks.STRIPPED_CRIMSON_HYPHAE, ModBlocks.STRIPPED_DARK_OAK_WOOD, ModBlocks.STRIPPED_JUNGLE_WOOD, ModBlocks.STRIPPED_OAK_WOOD, ModBlocks.STRIPPED_SPRUCE_WOOD, ModBlocks.STRIPPED_WARPED_HYPHAE, ModBlocks.STRIPPED_MANGROVE_WOOD, ModBlocks.STRIPPED_CHERRY_WOOD);
    List<class_1792> dyes = List.of(class_1802.field_8226, class_1802.field_8345, class_1802.field_8099, class_1802.field_8632, class_1802.field_8298, class_1802.field_8408, class_1802.field_8273, class_1802.field_8851, class_1802.field_8131, class_1802.field_8669, class_1802.field_8492, class_1802.field_8330, class_1802.field_8296, class_1802.field_8264, class_1802.field_8192, class_1802.field_8446);
    private final List<ModBlocks> wool = List.of(ModBlocks.BLACK_WOOL, ModBlocks.BLUE_WOOL, ModBlocks.BROWN_WOOL, ModBlocks.CYAN_WOOL, ModBlocks.GRAY_WOOL, ModBlocks.GREEN_WOOL, ModBlocks.LIGHT_BLUE_WOOL, ModBlocks.LIGHT_GRAY_WOOL, ModBlocks.LIME_WOOL, ModBlocks.MAGENTA_WOOL, ModBlocks.ORANGE_WOOL, ModBlocks.PINK_WOOL, ModBlocks.PURPLE_WOOL, ModBlocks.RED_WOOL, ModBlocks.YELLOW_WOOL, ModBlocks.WHITE_WOOL);
    private final List<ModBlocks> terracotta = List.of(ModBlocks.BLACK_TERRACOTTA, ModBlocks.BLUE_TERRACOTTA, ModBlocks.BROWN_TERRACOTTA, ModBlocks.CYAN_TERRACOTTA, ModBlocks.GRAY_TERRACOTTA, ModBlocks.GREEN_TERRACOTTA, ModBlocks.LIGHT_BLUE_TERRACOTTA, ModBlocks.LIGHT_GRAY_TERRACOTTA, ModBlocks.LIME_TERRACOTTA, ModBlocks.MAGENTA_TERRACOTTA, ModBlocks.ORANGE_TERRACOTTA, ModBlocks.PINK_TERRACOTTA, ModBlocks.PURPLE_TERRACOTTA, ModBlocks.RED_TERRACOTTA, ModBlocks.YELLOW_TERRACOTTA, ModBlocks.WHITE_TERRACOTTA);
    private final List<ModBlocks> glazedTerracotta = List.of(ModBlocks.BLACK_GLAZED_TERRACOTTA, ModBlocks.BLUE_GLAZED_TERRACOTTA, ModBlocks.BROWN_GLAZED_TERRACOTTA, ModBlocks.CYAN_GLAZED_TERRACOTTA, ModBlocks.GRAY_GLAZED_TERRACOTTA, ModBlocks.GREEN_GLAZED_TERRACOTTA, ModBlocks.LIGHT_BLUE_GLAZED_TERRACOTTA, ModBlocks.LIGHT_GRAY_GLAZED_TERRACOTTA, ModBlocks.LIME_GLAZED_TERRACOTTA, ModBlocks.MAGENTA_GLAZED_TERRACOTTA, ModBlocks.ORANGE_GLAZED_TERRACOTTA, ModBlocks.PINK_GLAZED_TERRACOTTA, ModBlocks.PURPLE_GLAZED_TERRACOTTA, ModBlocks.RED_GLAZED_TERRACOTTA, ModBlocks.YELLOW_GLAZED_TERRACOTTA, ModBlocks.WHITE_GLAZED_TERRACOTTA);
    public static final List<ModBlocks> logTypes = List.of(ModBlocks.ACACIA_LOG, ModBlocks.BIRCH_LOG, ModBlocks.CRIMSON_STEM, ModBlocks.DARK_OAK_LOG, ModBlocks.JUNGLE_LOG, ModBlocks.OAK_LOG, ModBlocks.SPRUCE_LOG, ModBlocks.WARPED_STEM, ModBlocks.MANGROVE_LOG, ModBlocks.CHERRY_LOG, ModBlocks.BAMBOO_BLOCK);

    public RecipeGenerator(FabricDataOutput dataGenerator, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(dataGenerator, registryLookup);
    }

    public void method_10419(class_8790 exporter) {
        this.addWaxedCopperRecipes(exporter);
        this.addLogToPlankRecipes(exporter);
        this.addSmeltingRecipes(exporter);
        this.addUncraftingRecipes(exporter);
        this.addMiscRecipes(exporter);
        for (ModBlocks block : ModBlocks.values()) {
            if (block.hasBlock(ModBlocks.BlockType.SLAB).booleanValue()) {
                if (block.equals((Object)ModBlocks.SNOW_BLOCK)) {
                    class_2450.method_10448((class_7800)class_7800.field_40634, (class_1935)block.getBlock(ModBlocks.BlockType.SLAB), (int)1).method_10442(RecipeGenerator.method_32807((class_1935)class_2246.field_10477), RecipeGenerator.method_10426((class_1935)class_2246.field_10477)).method_10442(RecipeGenerator.method_32807((class_1935)block.getBlock(ModBlocks.BlockType.SLAB)), RecipeGenerator.method_10426((class_1935)block.getBlock(ModBlocks.BlockType.SLAB))).method_10454((class_1935)class_2246.field_10477).method_10454((class_1935)class_2246.field_10477).method_10452(this.getRecipeGroup(block, ModBlocks.BlockType.SLAB)).method_10431(exporter);
                } else {
                    class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)block.getBlock(ModBlocks.BlockType.SLAB), (int)6).method_10429(RecipeGenerator.method_32807((class_1935)block.parentBlock), RecipeGenerator.method_10426((class_1935)block.parentBlock)).method_10429(RecipeGenerator.method_32807((class_1935)block.getBlock(ModBlocks.BlockType.SLAB)), RecipeGenerator.method_10426((class_1935)block.getBlock(ModBlocks.BlockType.SLAB))).method_10434(Character.valueOf('#'), (class_1935)block.parentBlock).method_10439("###").method_10435(this.getRecipeGroup(block, ModBlocks.BlockType.SLAB)).method_10431(exporter);
                }
                class_2446.method_33715((class_8790)exporter, (class_7800)class_7800.field_40634, (class_1935)block.getBlock(ModBlocks.BlockType.SLAB), (class_1935)block.parentBlock, (int)2);
            }
            if (block.hasBlock(ModBlocks.BlockType.STAIRS).booleanValue()) {
                class_2446.method_33715((class_8790)exporter, (class_7800)class_7800.field_40634, (class_1935)block.getBlock(ModBlocks.BlockType.STAIRS), (class_1935)block.parentBlock, (int)1);
                class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)block.getBlock(ModBlocks.BlockType.STAIRS), (int)4).method_10429(RecipeGenerator.method_32807((class_1935)block.parentBlock), RecipeGenerator.method_10426((class_1935)block.parentBlock)).method_10429(RecipeGenerator.method_32807((class_1935)block.getBlock(ModBlocks.BlockType.STAIRS)), RecipeGenerator.method_10426((class_1935)block.getBlock(ModBlocks.BlockType.STAIRS))).method_10434(Character.valueOf('#'), (class_1935)block.parentBlock).method_10439("#  ").method_10439("## ").method_10439("###").method_10435(this.getRecipeGroup(block, ModBlocks.BlockType.STAIRS)).method_10431(exporter);
            }
            if (!block.hasBlock(ModBlocks.BlockType.WALL).booleanValue()) continue;
            if (planks.contains((Object)block)) {
                class_2248 fence = switch (block) {
                    case ModBlocks.ACACIA_PLANKS -> class_2246.field_10144;
                    case ModBlocks.BIRCH_PLANKS -> class_2246.field_10299;
                    case ModBlocks.CRIMSON_PLANKS -> class_2246.field_22132;
                    case ModBlocks.DARK_OAK_PLANKS -> class_2246.field_10132;
                    case ModBlocks.JUNGLE_PLANKS -> class_2246.field_10319;
                    case ModBlocks.OAK_PLANKS -> class_2246.field_10620;
                    case ModBlocks.SPRUCE_PLANKS -> class_2246.field_10020;
                    case ModBlocks.WARPED_PLANKS -> class_2246.field_22133;
                    case ModBlocks.MANGROVE_PLANKS -> class_2246.field_37565;
                    case ModBlocks.CHERRY_PLANKS -> class_2246.field_42747;
                    case ModBlocks.BAMBOO_PLANKS -> class_2246.field_40290;
                    default -> class_2246.field_10620;
                };
                class_2450.method_10448((class_7800)class_7800.field_40634, (class_1935)block.getBlock(ModBlocks.BlockType.WALL), (int)1).method_10442(RecipeGenerator.method_32807((class_1935)fence), RecipeGenerator.method_10426((class_1935)fence)).method_10442(RecipeGenerator.method_32807((class_1935)block.getBlock(ModBlocks.BlockType.WALL)), RecipeGenerator.method_10426((class_1935)block.getBlock(ModBlocks.BlockType.WALL))).method_10454((class_1935)fence).method_10452(this.getRecipeGroup(block, ModBlocks.BlockType.WALL)).method_10431(exporter);
            } else if (this.copper.contains((Object)block)) {
                class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)block.getBlock(ModBlocks.BlockType.WALL), (int)2).method_10429(RecipeGenerator.method_32807((class_1935)block.parentBlock), RecipeGenerator.method_10426((class_1935)block.parentBlock)).method_10429(RecipeGenerator.method_32807((class_1935)block.getBlock(ModBlocks.BlockType.WALL)), RecipeGenerator.method_10426((class_1935)block.getBlock(ModBlocks.BlockType.WALL))).method_10434(Character.valueOf('#'), (class_1935)block.parentBlock).method_10439("#").method_10439("#").method_10435(this.getRecipeGroup(block, ModBlocks.BlockType.WALL)).method_10431(exporter);
            } else if (!this.glass.contains((Object)block)) {
                class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)block.getBlock(ModBlocks.BlockType.WALL), (int)6).method_10429(RecipeGenerator.method_32807((class_1935)block.parentBlock), RecipeGenerator.method_10426((class_1935)block.parentBlock)).method_10429(RecipeGenerator.method_32807((class_1935)block.getBlock(ModBlocks.BlockType.WALL)), RecipeGenerator.method_10426((class_1935)block.getBlock(ModBlocks.BlockType.WALL))).method_10434(Character.valueOf('#'), (class_1935)block.parentBlock).method_10439("###").method_10439("###").method_10435(this.getRecipeGroup(block, ModBlocks.BlockType.WALL)).method_10431(exporter);
            }
            class_2446.method_33717((class_8790)exporter, (class_7800)class_7800.field_40634, (class_1935)block.getBlock(ModBlocks.BlockType.WALL), (class_1935)block.parentBlock);
        }
    }

    private void addMiscRecipes(class_8790 exporter) {
        this.addCoarseDirtRecipe(exporter, ModBlocks.BlockType.SLAB);
        this.addCoarseDirtRecipe(exporter, ModBlocks.BlockType.STAIRS);
        this.addCoarseDirtRecipe(exporter, ModBlocks.BlockType.WALL);
        RecipeGenerator.method_51890((class_8790)exporter, this.dyes, List.copyOf(this.wool).stream().map(block -> block.getBlock(ModBlocks.BlockType.SLAB).method_8389()).toList(), (String)"wool_slabs_dying");
        RecipeGenerator.method_51890((class_8790)exporter, this.dyes, List.copyOf(this.wool).stream().map(block -> block.getBlock(ModBlocks.BlockType.STAIRS).method_8389()).toList(), (String)"wool_stairs_dying");
        RecipeGenerator.method_51890((class_8790)exporter, this.dyes, List.copyOf(this.wool).stream().map(block -> block.getBlock(ModBlocks.BlockType.WALL).method_8389()).toList(), (String)"wool_walls_dying");
        this.offerTerracottaSlabStairAndWalls(exporter);
    }

    private void offerTerracottaSlabStairAndWalls(class_8790 exporter) {
        for (int i = 0; i < this.dyes.size(); ++i) {
            for (ModBlocks.BlockType type : ModBlocks.BlockType.values()) {
                this.offerTerracottaDyeingRecipe(exporter, type, this.terracotta.get(i), (class_1935)this.dyes.get(i));
            }
        }
    }

    private void offerTerracottaDyeingRecipe(class_8790 exporter, ModBlocks.BlockType type, ModBlocks output, class_1935 input) {
        class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)output.getBlock(type), (int)8).method_10434(Character.valueOf('#'), (class_1935)ModBlocks.TERRACOTTA.getBlock(type)).method_10434(Character.valueOf('X'), input).method_10439("###").method_10439("#X#").method_10439("###").method_10435("stained_terracotta_" + type.toString().toLowerCase()).method_10429("has_terracotta_" + type.toString().toLowerCase(), class_2446.method_10426((class_1935)ModBlocks.TERRACOTTA.getBlock(type))).method_36443(exporter, output.toString().toLowerCase() + "_" + type.toString().toLowerCase() + "_from_terracotta_and_dye");
    }

    private void addCoarseDirtRecipe(class_8790 exporter, ModBlocks.BlockType type) {
        class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)ModBlocks.COARSE_DIRT.getBlock(type), (int)4).method_10429(RecipeGenerator.method_32807((class_1935)ModBlocks.GRAVEL.getBlock(type)), RecipeGenerator.method_10426((class_1935)ModBlocks.GRAVEL.getBlock(type))).method_10429(RecipeGenerator.method_32807((class_1935)ModBlocks.DIRT.getBlock(type)), RecipeGenerator.method_10426((class_1935)ModBlocks.DIRT.getBlock(type))).method_10434(Character.valueOf('#'), (class_1935)ModBlocks.GRAVEL.getBlock(type)).method_10434(Character.valueOf('&'), (class_1935)ModBlocks.DIRT.getBlock(type)).method_10439("&#").method_10439("#&").method_36443(exporter, ModBlocks.COARSE_DIRT.toString().toLowerCase() + "_" + type.toString().toLowerCase() + "_from_gravel_and_dirt");
    }

    private void addSmeltingRecipes(class_8790 exporter) {
        this.addSmeltingRecipe(exporter, null, ModBlocks.CRACKED_STONE_BRICKS, class_2246.field_10131, class_2246.field_10392, class_2246.field_10252);
        this.addSmeltingRecipe(exporter, null, ModBlocks.CRACKED_DEEPSLATE_BRICKS, class_2246.field_28902, class_2246.field_28901, class_2246.field_28903);
        this.addSmeltingRecipe(exporter, null, ModBlocks.CRACKED_DEEPSLATE_TILES, class_2246.field_28898, class_2246.field_28897, class_2246.field_28899);
        this.addSmeltingRecipe(exporter, null, ModBlocks.CRACKED_NETHER_BRICKS, class_2246.field_10390, class_2246.field_10159, class_2246.field_10127);
        this.addSmeltingRecipe(exporter, null, ModBlocks.SMOOTH_BASALT, ModBlocks.BASALT);
        this.addSmeltingRecipe(exporter, null, ModBlocks.TERRACOTTA, ModBlocks.CLAY);
        this.addSmeltingRecipe(exporter, "_sand", ModBlocks.GLASS, ModBlocks.SAND);
        this.addSmeltingRecipe(exporter, "_red_sand", ModBlocks.GLASS, ModBlocks.RED_SAND);
        this.addSmeltingRecipe(exporter, "_sandstone", ModBlocks.SMOOTH_SANDSTONE, class_2246.field_10007, class_2246.field_10142, class_2246.field_10630);
        this.addSmeltingRecipe(exporter, "_red_sandstone", ModBlocks.SMOOTH_RED_SANDSTONE, class_2246.field_10624, class_2246.field_10420, class_2246.field_10413);
        for (int i = 0; i < this.terracotta.size(); ++i) {
            this.addSmeltingRecipe(exporter, "_" + this.glazedTerracotta.get(i).toString().toLowerCase(), this.glazedTerracotta.get(i), this.terracotta.get(i));
        }
    }

    private void addSmeltingRecipe(class_8790 exporter, @Nullable String suffix, ModBlocks output, ModBlocks input) {
        this.addSmeltingRecipe(exporter, suffix, output, input.getBlock(ModBlocks.BlockType.SLAB), input.getBlock(ModBlocks.BlockType.STAIRS), input.getBlock(ModBlocks.BlockType.WALL));
    }

    private void addSmeltingRecipe(class_8790 exporter, @Nullable String suffix, ModBlocks block, class_2248 inputSlab, class_2248 inputStairs, class_2248 inputWall) {
        if (block.hasBlock(ModBlocks.BlockType.SLAB).booleanValue()) {
            class_2454.method_17802((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{inputSlab}), (class_7800)class_7800.field_40634, (class_1935)block.getBlock(ModBlocks.BlockType.SLAB), (float)0.1f, (int)200).method_10469(RecipeGenerator.method_32807((class_1935)inputSlab), RecipeGenerator.method_10426((class_1935)inputSlab)).method_36443(exporter, block.getId(ModBlocks.BlockType.SLAB).toString() + "_from_smelting" + suffix);
        }
        if (block.hasBlock(ModBlocks.BlockType.STAIRS).booleanValue()) {
            class_2454.method_17802((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{inputStairs}), (class_7800)class_7800.field_40634, (class_1935)block.getBlock(ModBlocks.BlockType.STAIRS), (float)0.1f, (int)200).method_10469(RecipeGenerator.method_32807((class_1935)inputStairs), RecipeGenerator.method_10426((class_1935)inputStairs)).method_36443(exporter, block.getId(ModBlocks.BlockType.STAIRS).toString() + "_from_smelting" + suffix);
        }
        if (block.hasBlock(ModBlocks.BlockType.WALL).booleanValue()) {
            class_2454.method_17802((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{inputWall}), (class_7800)class_7800.field_40634, (class_1935)block.getBlock(ModBlocks.BlockType.WALL), (float)0.1f, (int)200).method_10469(RecipeGenerator.method_32807((class_1935)inputWall), RecipeGenerator.method_10426((class_1935)inputWall)).method_36443(exporter, block.getId(ModBlocks.BlockType.WALL).toString() + "_from_smelting" + suffix);
        }
    }

    private void addUncraftingRecipes(class_8790 exporter) {
        this.addRawBlock(ModBlocks.RAW_COPPER_BLOCK, class_1802.field_33401, exporter);
        this.addRawBlock(ModBlocks.RAW_IRON_BLOCK, class_1802.field_33400, exporter);
        this.addRawBlock(ModBlocks.RAW_GOLD_BLOCK, class_1802.field_33402, exporter);
        this.addRawBlock(ModBlocks.COPPER_BLOCK, class_1802.field_27022, exporter);
        this.addRawBlock(ModBlocks.IRON_BLOCK, class_1802.field_8620, exporter);
        this.addRawBlock(ModBlocks.GOLD_BLOCK, class_1802.field_8695, exporter);
        this.addRawBlock(ModBlocks.DIAMOND_BLOCK, class_1802.field_8477, exporter);
        this.addRawBlock(ModBlocks.EMERALD_BLOCK, class_1802.field_8687, exporter);
        this.addRawBlock(ModBlocks.LAPIS_BLOCK, class_1802.field_8759, exporter);
        this.addRawBlock(ModBlocks.COAL_BLOCK, class_1802.field_8713, exporter);
        this.addRawBlock(ModBlocks.REDSTONE_BLOCK, class_1802.field_8725, exporter);
        this.addRawBlock(ModBlocks.NETHERITE_BLOCK, class_1802.field_22020, exporter);
        this.addRawBlock(ModBlocks.HAY_BLOCK, class_1802.field_8861, exporter);
        this.addRawBlock(ModBlocks.DRIED_KELP_BLOCK, class_1802.field_8551, exporter);
        this.addRawBlock(ModBlocks.BONE_BLOCK, class_1802.field_8324, exporter);
        this.addRawBlock(ModBlocks.SLIME_BLOCK, class_1802.field_8777, exporter);
    }

    private void addRawBlock(ModBlocks block, class_1792 ouput, class_8790 exporter) {
        class_2450.method_10448((class_7800)class_7800.field_40634, (class_1935)ouput, (int)9).method_10454((class_1935)block.getBlock(ModBlocks.BlockType.SLAB)).method_10452(this.getRecipeGroup(block, ModBlocks.BlockType.SLAB)).method_10454((class_1935)block.getBlock(ModBlocks.BlockType.SLAB)).method_10452(this.getRecipeGroup(block, ModBlocks.BlockType.SLAB)).method_10442(RecipeGenerator.method_32807((class_1935)block.getBlock(ModBlocks.BlockType.SLAB)), RecipeGenerator.method_10426((class_1935)block.getBlock(ModBlocks.BlockType.SLAB))).method_10442(RecipeGenerator.method_32807((class_1935)block.getBlock(ModBlocks.BlockType.SLAB)), RecipeGenerator.method_10426((class_1935)block.getBlock(ModBlocks.BlockType.SLAB))).method_36443(exporter, block.getId(ModBlocks.BlockType.SLAB).toString() + "_uncrafting");
        class_2450.method_10448((class_7800)class_7800.field_40634, (class_1935)ouput, (int)9).method_10454((class_1935)block.getBlock(ModBlocks.BlockType.STAIRS)).method_10452(this.getRecipeGroup(block, ModBlocks.BlockType.STAIRS)).method_10442(RecipeGenerator.method_32807((class_1935)block.getBlock(ModBlocks.BlockType.STAIRS)), RecipeGenerator.method_10426((class_1935)block.getBlock(ModBlocks.BlockType.STAIRS))).method_10442(RecipeGenerator.method_32807((class_1935)block.getBlock(ModBlocks.BlockType.STAIRS)), RecipeGenerator.method_10426((class_1935)block.getBlock(ModBlocks.BlockType.STAIRS))).method_36443(exporter, block.getId(ModBlocks.BlockType.STAIRS).toString() + "_uncrafting");
        class_2450.method_10448((class_7800)class_7800.field_40634, (class_1935)ouput, (int)9).method_10454((class_1935)block.getBlock(ModBlocks.BlockType.WALL)).method_10452(this.getRecipeGroup(block, ModBlocks.BlockType.WALL)).method_10442(RecipeGenerator.method_32807((class_1935)block.getBlock(ModBlocks.BlockType.WALL)), RecipeGenerator.method_10426((class_1935)block.getBlock(ModBlocks.BlockType.WALL))).method_10442(RecipeGenerator.method_32807((class_1935)block.getBlock(ModBlocks.BlockType.WALL)), RecipeGenerator.method_10426((class_1935)block.getBlock(ModBlocks.BlockType.WALL))).method_36443(exporter, block.getId(ModBlocks.BlockType.WALL).toString() + "_uncrafting");
    }

    public void addWaxedCopperRecipes(class_8790 exporter) {
        for (ModBlocks block : this.waxedCopper) {
            for (ModBlocks.BlockType type : ModBlocks.BlockType.values()) {
                if (!block.hasBlock(type).booleanValue()) continue;
                class_2450.method_10448((class_7800)class_7800.field_40634, (class_1935)block.getBlock(type), (int)1).method_10442(RecipeGenerator.method_32807((class_1935)block.associatedBlock.parentBlock), RecipeGenerator.method_10426((class_1935)block.associatedBlock.parentBlock)).method_10442(RecipeGenerator.method_32807((class_1935)block.associatedBlock.getBlock(type)), RecipeGenerator.method_10426((class_1935)block.associatedBlock.getBlock(type))).method_10454((class_1935)block.associatedBlock.getBlock(type)).method_10454((class_1935)class_1802.field_20414).method_10452("more_waxed_copper").method_36443(exporter, block.toString() + "_" + type.toString().toLowerCase() + "_honeycomb");
            }
        }
    }

    public void addLogToPlankRecipes(class_8790 exporter) {
        for (ModBlocks block : logTypes) {
            for (ModBlocks.BlockType type : ModBlocks.BlockType.values()) {
                if (!block.hasBlock(type).booleanValue()) continue;
                this.addPlankRecipe(block, type, type == ModBlocks.BlockType.SLAB ? 2 : 4, exporter);
            }
        }
    }

    private void addPlankRecipe(ModBlocks block, ModBlocks.BlockType type, int outputCount, class_8790 exporter) {
        class_2450.method_10448((class_7800)class_7800.field_40634, (class_1935)this.getPlank(block), (int)outputCount).method_10442(RecipeGenerator.method_32807((class_1935)block.getBlock(type)), RecipeGenerator.method_10426((class_1935)block.getBlock(type))).method_10446(ModTags.getLogTagKey(block, type)).method_10452("more_planks").method_36443(exporter, block.toString() + "_" + type.toString().toLowerCase() + "_to_planks");
    }

    private class_2248 getPlank(ModBlocks blocks) {
        return switch (blocks) {
            case ModBlocks.ACACIA_LOG, ModBlocks.STRIPPED_ACACIA_LOG, ModBlocks.ACACIA_WOOD, ModBlocks.STRIPPED_ACACIA_WOOD -> class_2246.field_10218;
            case ModBlocks.BIRCH_LOG, ModBlocks.STRIPPED_BIRCH_LOG, ModBlocks.BIRCH_WOOD, ModBlocks.STRIPPED_BIRCH_WOOD -> class_2246.field_10148;
            case ModBlocks.CRIMSON_STEM, ModBlocks.STRIPPED_CRIMSON_STEM, ModBlocks.CRIMSON_HYPHAE, ModBlocks.STRIPPED_CRIMSON_HYPHAE -> class_2246.field_22126;
            case ModBlocks.DARK_OAK_LOG, ModBlocks.STRIPPED_DARK_OAK_LOG, ModBlocks.DARK_OAK_WOOD, ModBlocks.STRIPPED_DARK_OAK_WOOD -> class_2246.field_10075;
            case ModBlocks.JUNGLE_LOG, ModBlocks.STRIPPED_JUNGLE_LOG, ModBlocks.JUNGLE_WOOD, ModBlocks.STRIPPED_JUNGLE_WOOD -> class_2246.field_10334;
            case ModBlocks.OAK_LOG, ModBlocks.STRIPPED_OAK_LOG, ModBlocks.OAK_WOOD, ModBlocks.STRIPPED_OAK_WOOD -> class_2246.field_10161;
            case ModBlocks.SPRUCE_LOG, ModBlocks.STRIPPED_SPRUCE_LOG, ModBlocks.SPRUCE_WOOD, ModBlocks.STRIPPED_SPRUCE_WOOD -> class_2246.field_9975;
            case ModBlocks.WARPED_STEM, ModBlocks.STRIPPED_WARPED_STEM, ModBlocks.WARPED_HYPHAE, ModBlocks.STRIPPED_WARPED_HYPHAE -> class_2246.field_22127;
            case ModBlocks.MANGROVE_LOG, ModBlocks.STRIPPED_MANGROVE_LOG, ModBlocks.MANGROVE_WOOD, ModBlocks.STRIPPED_MANGROVE_WOOD -> class_2246.field_37577;
            case ModBlocks.CHERRY_LOG, ModBlocks.STRIPPED_CHERRY_LOG, ModBlocks.CHERRY_WOOD, ModBlocks.STRIPPED_CHERRY_WOOD -> class_2246.field_42751;
            case ModBlocks.BAMBOO_BLOCK, ModBlocks.STRIPPED_BAMBOO_BLOCK -> class_2246.field_40294;
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)blocks));
        };
    }

    private String getRecipeGroup(ModBlocks block, ModBlocks.BlockType blockType) {
        String type = blockType.toString().toLowerCase();
        return switch (block) {
            case ModBlocks.ACACIA_LOG, ModBlocks.STRIPPED_ACACIA_LOG, ModBlocks.BIRCH_LOG, ModBlocks.STRIPPED_BIRCH_LOG, ModBlocks.CRIMSON_STEM, ModBlocks.STRIPPED_CRIMSON_STEM, ModBlocks.DARK_OAK_LOG, ModBlocks.STRIPPED_DARK_OAK_LOG, ModBlocks.JUNGLE_LOG, ModBlocks.STRIPPED_JUNGLE_LOG, ModBlocks.OAK_LOG, ModBlocks.STRIPPED_OAK_LOG, ModBlocks.SPRUCE_LOG, ModBlocks.STRIPPED_SPRUCE_LOG, ModBlocks.WARPED_STEM, ModBlocks.STRIPPED_WARPED_STEM, ModBlocks.MANGROVE_LOG, ModBlocks.STRIPPED_MANGROVE_LOG, ModBlocks.CHERRY_LOG, ModBlocks.STRIPPED_CHERRY_LOG, ModBlocks.BAMBOO_BLOCK, ModBlocks.STRIPPED_BAMBOO_BLOCK -> "log_" + type;
            case ModBlocks.ACACIA_WOOD, ModBlocks.STRIPPED_ACACIA_WOOD, ModBlocks.BIRCH_WOOD, ModBlocks.STRIPPED_BIRCH_WOOD, ModBlocks.CRIMSON_HYPHAE, ModBlocks.STRIPPED_CRIMSON_HYPHAE, ModBlocks.DARK_OAK_WOOD, ModBlocks.STRIPPED_DARK_OAK_WOOD, ModBlocks.JUNGLE_WOOD, ModBlocks.STRIPPED_JUNGLE_WOOD, ModBlocks.OAK_WOOD, ModBlocks.STRIPPED_OAK_WOOD, ModBlocks.SPRUCE_WOOD, ModBlocks.STRIPPED_SPRUCE_WOOD, ModBlocks.WARPED_HYPHAE, ModBlocks.STRIPPED_WARPED_HYPHAE, ModBlocks.MANGROVE_WOOD, ModBlocks.STRIPPED_MANGROVE_WOOD, ModBlocks.CHERRY_WOOD, ModBlocks.STRIPPED_CHERRY_WOOD -> "bark_" + type;
            case ModBlocks.ACACIA_LEAVES, ModBlocks.BIRCH_LEAVES, ModBlocks.DARK_OAK_LEAVES, ModBlocks.JUNGLE_LEAVES, ModBlocks.OAK_LEAVES, ModBlocks.SPRUCE_LEAVES, ModBlocks.MANGROVE_LEAVES, ModBlocks.CHERRY_LEAVES, ModBlocks.AZALEA_LEAVES, ModBlocks.FLOWERING_AZALEA_LEAVES -> "leaves_" + type;
            case ModBlocks.BLACK_STAINED_GLASS, ModBlocks.BLUE_STAINED_GLASS, ModBlocks.BROWN_STAINED_GLASS, ModBlocks.CYAN_STAINED_GLASS, ModBlocks.GRAY_STAINED_GLASS, ModBlocks.GREEN_STAINED_GLASS, ModBlocks.LIGHT_BLUE_STAINED_GLASS, ModBlocks.LIGHT_GRAY_STAINED_GLASS, ModBlocks.LIME_STAINED_GLASS, ModBlocks.MAGENTA_STAINED_GLASS, ModBlocks.ORANGE_STAINED_GLASS, ModBlocks.PINK_STAINED_GLASS, ModBlocks.PURPLE_STAINED_GLASS, ModBlocks.RED_STAINED_GLASS, ModBlocks.WHITE_STAINED_GLASS, ModBlocks.YELLOW_STAINED_GLASS -> "stained_glass_" + type;
            case ModBlocks.BLACK_WOOL, ModBlocks.BLUE_WOOL, ModBlocks.BROWN_WOOL, ModBlocks.CYAN_WOOL, ModBlocks.GRAY_WOOL, ModBlocks.GREEN_WOOL, ModBlocks.LIGHT_BLUE_WOOL, ModBlocks.LIGHT_GRAY_WOOL, ModBlocks.LIME_WOOL, ModBlocks.MAGENTA_WOOL, ModBlocks.ORANGE_WOOL, ModBlocks.PINK_WOOL, ModBlocks.PURPLE_WOOL, ModBlocks.RED_WOOL, ModBlocks.WHITE_WOOL, ModBlocks.YELLOW_WOOL -> "wool_" + type;
            case ModBlocks.BLACK_CONCRETE, ModBlocks.BLUE_CONCRETE, ModBlocks.BROWN_CONCRETE, ModBlocks.CYAN_CONCRETE, ModBlocks.GRAY_CONCRETE, ModBlocks.GREEN_CONCRETE, ModBlocks.LIGHT_BLUE_CONCRETE, ModBlocks.LIGHT_GRAY_CONCRETE, ModBlocks.LIME_CONCRETE, ModBlocks.MAGENTA_CONCRETE, ModBlocks.ORANGE_CONCRETE, ModBlocks.PINK_CONCRETE, ModBlocks.PURPLE_CONCRETE, ModBlocks.RED_CONCRETE, ModBlocks.WHITE_CONCRETE, ModBlocks.YELLOW_CONCRETE -> "concrete_" + type;
            case ModBlocks.BLACK_TERRACOTTA, ModBlocks.BLUE_TERRACOTTA, ModBlocks.BROWN_TERRACOTTA, ModBlocks.CYAN_TERRACOTTA, ModBlocks.GRAY_TERRACOTTA, ModBlocks.GREEN_TERRACOTTA, ModBlocks.LIGHT_BLUE_TERRACOTTA, ModBlocks.LIGHT_GRAY_TERRACOTTA, ModBlocks.LIME_TERRACOTTA, ModBlocks.MAGENTA_TERRACOTTA, ModBlocks.ORANGE_TERRACOTTA, ModBlocks.PINK_TERRACOTTA, ModBlocks.PURPLE_TERRACOTTA, ModBlocks.RED_TERRACOTTA, ModBlocks.WHITE_TERRACOTTA, ModBlocks.YELLOW_TERRACOTTA -> "terracotta_" + type;
            case ModBlocks.BLACK_GLAZED_TERRACOTTA, ModBlocks.BLUE_GLAZED_TERRACOTTA, ModBlocks.BROWN_GLAZED_TERRACOTTA, ModBlocks.CYAN_GLAZED_TERRACOTTA, ModBlocks.GRAY_GLAZED_TERRACOTTA, ModBlocks.GREEN_GLAZED_TERRACOTTA, ModBlocks.LIGHT_BLUE_GLAZED_TERRACOTTA, ModBlocks.LIGHT_GRAY_GLAZED_TERRACOTTA, ModBlocks.LIME_GLAZED_TERRACOTTA, ModBlocks.MAGENTA_GLAZED_TERRACOTTA, ModBlocks.ORANGE_GLAZED_TERRACOTTA, ModBlocks.PINK_GLAZED_TERRACOTTA, ModBlocks.PURPLE_GLAZED_TERRACOTTA, ModBlocks.RED_GLAZED_TERRACOTTA, ModBlocks.WHITE_GLAZED_TERRACOTTA, ModBlocks.YELLOW_GLAZED_TERRACOTTA -> "glazed_terracotta_" + type;
            case ModBlocks.BLACK_CONCRETE_POWDER, ModBlocks.BLUE_CONCRETE_POWDER, ModBlocks.BROWN_CONCRETE_POWDER, ModBlocks.CYAN_CONCRETE_POWDER, ModBlocks.GRAY_CONCRETE_POWDER, ModBlocks.GREEN_CONCRETE_POWDER, ModBlocks.LIGHT_BLUE_CONCRETE_POWDER, ModBlocks.LIGHT_GRAY_CONCRETE_POWDER, ModBlocks.LIME_CONCRETE_POWDER, ModBlocks.MAGENTA_CONCRETE_POWDER, ModBlocks.ORANGE_CONCRETE_POWDER, ModBlocks.PINK_CONCRETE_POWDER, ModBlocks.PURPLE_CONCRETE_POWDER, ModBlocks.RED_CONCRETE_POWDER, ModBlocks.WHITE_CONCRETE_POWDER, ModBlocks.YELLOW_CONCRETE_POWDER -> "concrete_powder_" + type;
            case ModBlocks.WARPED_WART, ModBlocks.CRIMSON_WART -> "wart_" + type;
            case ModBlocks.RAW_COPPER_BLOCK, ModBlocks.RAW_GOLD_BLOCK, ModBlocks.RAW_IRON_BLOCK -> "raw_metal_" + type;
            case ModBlocks.BRAIN_CORAL_BLOCK, ModBlocks.BUBBLE_CORAL_BLOCK, ModBlocks.FIRE_CORAL_BLOCK, ModBlocks.HORN_CORAL_BLOCK, ModBlocks.TUBE_CORAL_BLOCK -> "coral_block_" + type;
            case ModBlocks.DEAD_BRAIN_CORAL_BLOCK, ModBlocks.DEAD_BUBBLE_CORAL_BLOCK, ModBlocks.DEAD_FIRE_CORAL_BLOCK, ModBlocks.DEAD_HORN_CORAL_BLOCK, ModBlocks.DEAD_TUBE_CORAL_BLOCK -> "dead_coral_block_" + type;
            case ModBlocks.OCHRE_FROGLIGHT, ModBlocks.PEARLESCENT_FROGLIGHT, ModBlocks.VERDANT_FROGLIGHT -> "froglight_" + type;
            case ModBlocks.ICE, ModBlocks.PACKED_ICE, ModBlocks.BLUE_ICE -> "ice_" + type;
            case ModBlocks.ACACIA_PLANKS, ModBlocks.BIRCH_PLANKS, ModBlocks.CRIMSON_PLANKS, ModBlocks.DARK_OAK_PLANKS, ModBlocks.JUNGLE_PLANKS, ModBlocks.OAK_PLANKS, ModBlocks.SPRUCE_PLANKS, ModBlocks.WARPED_PLANKS, ModBlocks.MANGROVE_PLANKS, ModBlocks.CHERRY_PLANKS, ModBlocks.BAMBOO_PLANKS -> "planks_" + type;
            default -> String.valueOf((Object)block) + "_" + type;
        };
    }
}

