/*
 * Decompiled with CFR 0.152.
 */
package dev.mattidragon.polydexbridge;

import com.google.common.collect.Iterables;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.mattidragon.polydexbridge.PolydexBridge;
import dev.mattidragon.polydexbridge.data.BridgeRecipe;
import dev.mattidragon.polydexbridge.data.BridgeStack;
import dev.mattidragon.polydexbridge.data.Slot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5632;
import net.minecraft.class_5684;

@Environment(value=EnvType.CLIENT)
public class BridgedEmiRecipe
implements EmiRecipe {
    private static final class_2583 TEXTURE_STYLE = class_2583.field_24360.method_27704(class_2960.method_60654((String)"polydex:gui")).method_10977(class_124.field_1068);
    private final EmiRecipeCategory category;
    private final BridgeRecipe recipe;

    public BridgedEmiRecipe(EmiRecipeCategory category, BridgeRecipe recipe) {
        this.category = category;
        this.recipe = recipe;
    }

    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    public class_2960 getId() {
        return this.recipe.id();
    }

    public List<EmiIngredient> getInputs() {
        return this.recipe.inputs().stream().map(Slot::stacks).map(BridgedEmiRecipe::convertIngredient).toList();
    }

    public List<EmiStack> getOutputs() {
        return this.recipe.outputs().stream().map(Slot::stacks).map(BridgedEmiRecipe::convertIngredient).map(EmiIngredient::getEmiStacks).flatMap(Collection::stream).toList();
    }

    public int getDisplayWidth() {
        return 162;
    }

    public int getDisplayHeight() {
        return 90;
    }

    public void addWidgets(WidgetHolder widgets) {
        for (Slot slot : Iterables.concat(this.recipe.inputs(), this.recipe.outputs(), this.recipe.icons())) {
            widgets.addTexture(EmiTexture.SLOT, slot.x() * 18, slot.y() * 18);
        }
        if (this.recipe.texture() != null) {
            widgets.addText((class_2561)this.createTextureText(), 0, -11, -1, false);
        }
        for (Slot input : this.recipe.inputs()) {
            widgets.add((Widget)BridgedEmiRecipe.createSlotWidget(input));
        }
        for (Slot output : this.recipe.outputs()) {
            ((SlotWidget)widgets.add((Widget)BridgedEmiRecipe.createSlotWidget(output))).recipeContext((EmiRecipe)this);
        }
        for (Slot icon : this.recipe.icons()) {
            widgets.add(BridgedEmiRecipe.createIconWidget(icon));
        }
    }

    private class_5250 createTextureText() {
        return class_2561.method_43470((String)"").method_10862(TEXTURE_STYLE).method_10852(this.recipe.texture());
    }

    private static SlotWidget createSlotWidget(Slot input) {
        return new SlotWidget(BridgedEmiRecipe.convertIngredient(input.stacks()), input.x() * 18, input.y() * 18){

            public void method_25394(class_332 draw, int mouseX, int mouseY, float delta) {
                class_4587 matrices = draw.method_51448();
                matrices.method_22903();
                matrices.method_46416(0.0f, 0.0f, 300.0f);
                matrices.method_23760().method_23761().scale(1.0f, 1.0f, 0.1f);
                super.method_25394(draw, mouseX, mouseY, delta);
                matrices.method_22909();
            }
        }.drawBack(false);
    }

    private static Widget createIconWidget(final Slot slot) {
        final Bounds bounds = new Bounds(slot.x() * 18, slot.y() * 18, 18, 18);
        return new Widget(){

            public Bounds getBounds() {
                return bounds;
            }

            public void method_25394(class_332 draw, int mouseX, int mouseY, float delta) {
                List<BridgeStack> stacks = slot.stacks();
                int item = (int)(System.currentTimeMillis() / 1000L % (long)stacks.size());
                BridgeStack current = stacks.get(item);
                class_4587 matrices = draw.method_51448();
                matrices.method_22903();
                matrices.method_46416(0.0f, 0.0f, 300.0f);
                matrices.method_23760().method_23761().scale(1.0f, 1.0f, 0.1f);
                EmiStack.of((class_1799)current.stack()).render(draw, bounds.x() + 1, bounds.y() + 1, delta);
                matrices.method_22909();
            }

            public List<class_5684> getTooltip(int mouseX, int mouseY) {
                List<BridgeStack> stacks = slot.stacks();
                int item = (int)(System.currentTimeMillis() / 1000L % (long)stacks.size());
                BridgeStack current = stacks.get(item);
                return this.getTooltipComponentListFromItem(current.stack());
            }

            public List<class_5684> getTooltipComponentListFromItem(class_1799 stack) {
                ArrayList list = class_437.method_25408((class_310)class_310.method_1551(), (class_1799)stack).stream().map(EmiPort::ordered).map(class_5684::method_32662).collect(Collectors.toCollection(ArrayList::new));
                Optional data = stack.method_32347();
                if (data.isPresent()) {
                    try {
                        list.add(class_5684.method_32663((class_5632)((class_5632)data.get())));
                    }
                    catch (Throwable e) {
                        PolydexBridge.LOGGER.error("Error while getting tooltip data", e);
                    }
                }
                return list;
            }
        };
    }

    private static EmiIngredient convertIngredient(List<BridgeStack> stacks) {
        return EmiIngredient.of(stacks.stream().map(stack -> EmiStack.of((class_1799)stack.stack()).setChance(stack.chance())).toList());
    }
}

