/*
 * Decompiled with CFR 0.152.
 */
package dev.mattidragon.polydexbridge;

import dev.mattidragon.polydexbridge.data.BridgeStack;
import dev.mattidragon.polydexbridge.data.Slot;
import eu.pb4.polydex.api.v1.recipe.PageBuilder;
import eu.pb4.polydex.api.v1.recipe.PolydexIngredient;
import eu.pb4.polydex.api.v1.recipe.PolydexStack;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_3222;

public class PageConverter
implements PageBuilder {
    private final class_3222 player;
    public final List<Slot> icons = new ArrayList<Slot>();
    public final List<Slot> inputs = new ArrayList<Slot>();
    public final List<Slot> outputs = new ArrayList<Slot>();

    public PageConverter(class_3222 player) {
        this.player = player;
    }

    public void set(int x, int y, class_1799 stack) {
        this.icons.add(new Slot(x, y, new BridgeStack(stack)));
    }

    public void set(int x, int y, class_1799 ... stacks) {
        this.icons.add(new Slot(x, y, Arrays.stream(stacks).map(BridgeStack::new).toList()));
    }

    public void setOutput(int x, int y, class_1799 ... stacks) {
        this.outputs.add(new Slot(x, y, Arrays.stream(stacks).map(BridgeStack::new).toList()));
    }

    public void setOutput(int x, int y, PolydexStack<?> ... stacks) {
        this.outputs.add(new Slot(x, y, Arrays.stream(stacks).map(stack -> new BridgeStack(stack.toItemStack(this.player), stack.chance())).toList()));
    }

    public void setIngredient(int x, int y, class_1799 ... stacks) {
        this.inputs.add(new Slot(x, y, Arrays.stream(stacks).map(BridgeStack::new).toList()));
    }

    public void setIngredient(int x, int y, class_1856 ingredient) {
        this.inputs.add(new Slot(x, y, Arrays.stream(ingredient.method_8105()).map(BridgeStack::new).toList()));
    }

    public void setIngredient(int x, int y, PolydexIngredient<?> ingredient) {
        this.inputs.add(new Slot(x, y, PageConverter.convertIngredient(ingredient, this.player)));
    }

    public void setIngredient(int x, int y, PolydexIngredient<?> ingredient, Consumer<GuiElementBuilder> consumer) {
        this.inputs.add(new Slot(x, y, ingredient.asStacks().stream().map(stack -> {
            GuiElementBuilder builder = GuiElementBuilder.from((class_1799)stack.toItemStack(this.player));
            consumer.accept(builder);
            return new BridgeStack(builder.asStack(), ingredient.chance());
        }).toList()));
    }

    public void setEmpty(int x, int y) {
        this.inputs.add(new Slot(x, y, List.of()));
    }

    public boolean hasTextures() {
        return true;
    }

    public static List<BridgeStack> convertIngredient(PolydexIngredient<?> ingredient, class_3222 player) {
        return ingredient.asStacks().stream().map(stack -> new BridgeStack(stack.toItemStack(player), ingredient.chance())).toList();
    }
}

