/*
 * Decompiled with CFR 0.152.
 */
package dev.mattidragon.polydexbridge;

import dev.mattidragon.polydexbridge.BridgeEnablePacket;
import dev.mattidragon.polydexbridge.PageConverter;
import dev.mattidragon.polydexbridge.PolydexRecipesPacket;
import dev.mattidragon.polydexbridge.data.BridgeCategory;
import dev.mattidragon.polydexbridge.data.BridgeRecipe;
import eu.pb4.polydex.api.v1.recipe.PageBuilder;
import eu.pb4.polydex.api.v1.recipe.PolydexPage;
import eu.pb4.polydex.api.v1.recipe.PolydexPageUtils;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;
import net.minecraft.class_8610;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolydexBridge
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"PolydexBridge");
    public static final String MOD_ID = "polydex-bridge";

    public void onInitialize() {
        PolydexRecipesPacket.register();
        BridgeEnablePacket.register();
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> ServerConfigurationNetworking.send((class_8610)handler, (class_8710)BridgeEnablePacket.INSTANCE));
        PolydexPageUtils.AFTER_PAGE_LOADING.register(PolydexBridge::sendRecipes);
    }

    private static void sendRecipes(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            if (!ServerPlayNetworking.canSend((class_3222)player, PolydexRecipesPacket.ID)) continue;
            ServerPlayNetworking.send((class_3222)player, (class_8710)PolydexBridge.createPacket(player));
        }
    }

    public static PolydexRecipesPacket createPacket(class_3222 player) {
        ArrayList<BridgeRecipe> recipes = new ArrayList<BridgeRecipe>();
        for (PolydexPage page : PolydexPageUtils.getAllPages()) {
            List<BridgeCategory> categories = page.categories().stream().filter(category -> !category.identifier().method_12836().equals("minecraft")).map(category -> new BridgeCategory(category.identifier(), category.name())).toList();
            if (categories.isEmpty()) continue;
            PageConverter converter = new PageConverter(player);
            page.createPage(null, player, (PageBuilder)converter);
            recipes.add(new BridgeRecipe(page.identifier(), page.getGroup(), categories, page.typeIcon(player), page.entryIcon(null, player), page.texture(player), page.ingredients().stream().map(ingredient -> PageConverter.convertIngredient(ingredient, player)).toList(), converter.icons, converter.inputs, converter.outputs));
        }
        return new PolydexRecipesPacket(recipes);
    }
}

