/*
 * Decompiled with CFR 0.152.
 */
package dev.mattidragon.polydexbridge;

import dev.mattidragon.polydexbridge.BridgeEnablePacket;
import dev.mattidragon.polydexbridge.PolydexRecipesPacket;
import dev.mattidragon.polydexbridge.data.BridgeRecipe;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;

@Environment(value=EnvType.CLIENT)
public class PolydexBridgeClient
implements ClientModInitializer {
    public static final List<BridgeRecipe> RECIPES = new ArrayList<BridgeRecipe>();
    public static Runnable onPolyRecipes = () -> {};
    public static boolean waitForPoly = false;

    public void onInitializeClient() {
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> this.disconnect());
        ClientConfigurationConnectionEvents.INIT.register((handler, client) -> this.disconnect());
        ClientConfigurationNetworking.registerGlobalReceiver(BridgeEnablePacket.ID, (packet, context) -> {
            waitForPoly = true;
        });
        ClientPlayNetworking.registerGlobalReceiver(PolydexRecipesPacket.ID, (packet, context) -> {
            RECIPES.clear();
            RECIPES.addAll(packet.recipes());
            onPolyRecipes.run();
        });
    }

    private void disconnect() {
        RECIPES.clear();
        waitForPoly = false;
    }
}

