/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.mimic;

import artifacts.Artifacts;
import artifacts.client.mimic.model.MimicChestLayerModel;
import artifacts.client.mimic.model.MimicModel;
import artifacts.entity.MimicEntity;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5599;
import net.minecraft.class_7833;
import net.minecraft.class_922;

public class MimicChestLayer
extends class_3887<MimicEntity, MimicModel> {
    public static final List<String> QUARK_CHEST_MATERIALS = Arrays.asList("oak", "spruce", "birch", "cherry", "jungle", "acacia", "dark_oak", "warped", "crimson", "azalea", "blossom", "mangrove", "bamboo");
    private final MimicChestLayerModel chestModel;
    public final class_4730 vanillaChestMaterial;
    public final List<class_4730> chestMaterials;

    public MimicChestLayer(class_3883<MimicEntity, MimicModel> entityRenderer, class_5599 modelSet) {
        super(entityRenderer);
        this.chestModel = new MimicChestLayerModel(modelSet.method_32072(MimicChestLayerModel.LAYER_LOCATION));
        this.chestMaterials = new ArrayList<class_4730>();
        boolean isChristmas = MimicChestLayer.isChristmas();
        class_4730 class_47302 = this.vanillaChestMaterial = isChristmas ? class_4722.field_21717 : class_4722.field_21720;
        if (isChristmas) {
            this.chestMaterials.add(this.vanillaChestMaterial);
            return;
        }
        class_4730 defaultMaterial = this.vanillaChestMaterial;
        if (Platform.isModLoaded((String)"lootr")) {
            defaultMaterial = MimicChestLayer.createMaterial("lootr", "chest");
        } else if (Platform.isModLoaded((String)"myloot")) {
            defaultMaterial = MimicChestLayer.createMaterial("myloot", "entity/chest/loot");
        }
        this.chestMaterials.add(defaultMaterial);
        MimicChestLayer.addQuarkMaterials(this.chestMaterials);
    }

    private static boolean isChristmas() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 11 && calendar.get(5) >= 24 && calendar.get(5) <= 26 || calendar.get(2) == 3 && calendar.get(5) == 1;
    }

    private static void addQuarkMaterials(List<class_4730> chestMaterials) {
        if (Platform.isModLoaded((String)"quark")) {
            String chestVariant = Platform.isModLoaded((String)"lootr") ? "lootr_normal" : "normal";
            for (String chestMaterial : QUARK_CHEST_MATERIALS) {
                chestMaterials.add(MimicChestLayer.createMaterial("quark", String.format("quark_variant_chests/%s/%s", chestMaterial, chestVariant)));
            }
        }
    }

    private static class_4730 createMaterial(String modId, String location) {
        class_2960 chestAtlas = class_2960.method_60654((String)"textures/atlas/chest.png");
        return new class_4730(chestAtlas, class_2960.method_60655((String)modId, (String)location));
    }

    public void render(class_4587 matrixStack, class_4597 buffer, int packedLight, MimicEntity mimic, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!mimic.method_5767()) {
            matrixStack.method_22903();
            matrixStack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
            matrixStack.method_22904(-0.5, -1.5, -0.5);
            ((MimicModel)this.method_17165()).method_17081(this.chestModel);
            this.chestModel.prepareMobModel(mimic, limbSwing, limbSwingAmount, partialTicks);
            this.chestModel.setupAnim(mimic, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            class_4588 builder = this.getChestMaterial(mimic).method_24145(buffer, class_1921::method_23576);
            this.chestModel.method_2828(matrixStack, builder, packedLight, class_922.method_23622((class_1309)mimic, (float)0.0f), -1);
            matrixStack.method_22909();
        }
    }

    private class_4730 getChestMaterial(MimicEntity mimic) {
        if (!Artifacts.CONFIG.client.useModdedMimicTextures.get().booleanValue()) {
            return this.vanillaChestMaterial;
        }
        if (this.chestMaterials.size() == 1) {
            return this.chestMaterials.getFirst();
        }
        return this.chestMaterials.get((int)(Math.abs(mimic.method_5667().getMostSignificantBits()) % (long)this.chestMaterials.size()));
    }
}

