/*
 * Decompiled with CFR 0.152.
 */
package artifacts.fabric.integration;

import artifacts.client.item.renderer.ArtifactRenderer;
import artifacts.event.ArtifactEvents;
import artifacts.fabric.client.CosmeticsHelper;
import artifacts.fabric.trinket.WearableArtifactTrinket;
import artifacts.item.WearableArtifactItem;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketItem;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.client.TrinketRenderer;
import dev.emi.trinkets.api.client.TrinketRendererRegistry;
import dev.emi.trinkets.api.event.TrinketEquipCallback;
import dev.emi.trinkets.api.event.TrinketUnequipCallback;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_583;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class TrinketsIntegration {
    public static void setup() {
        class_7923.field_41178.method_10220().filter(item -> item instanceof WearableArtifactItem).forEach(item -> TrinketsApi.registerTrinket((class_1792)item, (Trinket)new WearableArtifactTrinket((WearableArtifactItem)((Object)item))));
        TrinketEquipCallback.EVENT.register((stack, slot, entity) -> ArtifactEvents.onItemChanged(entity, class_1799.field_8037, stack));
        TrinketUnequipCallback.EVENT.register((stack, slot, entity) -> ArtifactEvents.onItemChanged(entity, stack, class_1799.field_8037));
    }

    public static boolean equipTrinket(class_1309 entity, class_1799 stack) {
        return TrinketItem.equipItem((class_1309)entity, (class_1799)stack);
    }

    public static Stream<class_1799> findAllEquippedBy(class_1309 entity) {
        return TrinketsApi.getTrinketComponent((class_1309)entity).map(TrinketComponent::getAllEquipped).orElse(List.of()).stream().map(class_3545::method_15441);
    }

    public static void iterateEquippedTrinkets(class_1309 entity, Consumer<class_1799> consumer) {
        TrinketsApi.getTrinketComponent((class_1309)entity).ifPresent(component -> {
            for (Map map : component.getInventory().values()) {
                for (TrinketInventory inventory : map.values()) {
                    for (int i = 0; i < inventory.method_5439(); ++i) {
                        class_1799 item = inventory.method_5438(i);
                        if (item.method_7960()) continue;
                        consumer.accept(item);
                    }
                }
            }
        });
    }

    public static <T> T reduceTrinkets(class_1309 entity, T init, BiFunction<class_1799, T, T> f) {
        Optional component = TrinketsApi.getTrinketComponent((class_1309)entity);
        if (component.isPresent()) {
            for (Map map : ((TrinketComponent)component.get()).getInventory().values()) {
                for (TrinketInventory inventory : map.values()) {
                    for (int i = 0; i < inventory.method_5439(); ++i) {
                        class_1799 item = inventory.method_5438(i);
                        if (item.method_7960()) continue;
                        init = f.apply(item, (class_1799)init);
                    }
                }
            }
        }
        return init;
    }

    public static boolean isVisibleOnHand(class_1309 entity, class_1268 hand, class_1792 item) {
        return TrinketsApi.getTrinketComponent((class_1309)entity).stream().flatMap(component -> component.getAllEquipped().stream()).filter(tuple -> ((SlotReference)tuple.method_15442()).inventory().getSlotType().getGroup().equals(hand == class_1268.field_5808 ? "hand" : "offhand")).map(class_3545::method_15441).filter(stack -> stack.method_31574(item)).filter(stack -> !CosmeticsHelper.areCosmeticsToggledOffByPlayer(stack)).anyMatch(tuple -> true);
    }

    public static void registerArtifactRenderer(class_1792 item, Supplier<ArtifactRenderer> rendererSupplier) {
        TrinketRendererRegistry.registerRenderer((class_1792)item, (TrinketRenderer)new ArtifactTrinketRenderer(rendererSupplier.get()));
    }

    @Nullable
    public static ArtifactRenderer getArtifactRenderer(class_1792 item) {
        Object t;
        Optional renderer = TrinketRendererRegistry.getRenderer((class_1792)item);
        if (renderer.isPresent() && (t = renderer.get()) instanceof ArtifactTrinketRenderer) {
            ArtifactTrinketRenderer artifactTrinketRenderer = (ArtifactTrinketRenderer)t;
            return artifactTrinketRenderer.renderer();
        }
        return null;
    }

    private record ArtifactTrinketRenderer(ArtifactRenderer renderer) implements TrinketRenderer
    {
        public void render(class_1799 stack, SlotReference slotReference, class_583<? extends class_1309> entityModel, class_4587 poseStack, class_4597 multiBufferSource, int light, class_1309 entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (CosmeticsHelper.areCosmeticsToggledOffByPlayer(stack)) {
                return;
            }
            int index = slotReference.index() + (slotReference.inventory().getSlotType().getGroup().equals("hand") ? 0 : 1);
            this.renderer.render(stack, entity, index, poseStack, multiBufferSource, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

