/*
 * Decompiled with CFR 0.152.
 */
package artifacts.mixin.item;

import artifacts.Artifacts;
import artifacts.ability.ArtifactAbility;
import artifacts.ability.AttributeModifierAbility;
import artifacts.item.WearableArtifactItem;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModAbilities;
import artifacts.registry.ModDataComponents;
import artifacts.util.AbilityHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_5134;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6862;
import net.minecraft.class_8110;
import net.minecraft.class_9285;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1799.class})
public class ItemStackMixin {
    @Inject(method={"getTooltipLines"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/Item;appendHoverText(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/Item$TooltipContext;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V")})
    private void getTooltipLines(class_1792.class_9635 tooltipContext, @Nullable class_1657 player, class_1836 tooltipFlag, CallbackInfoReturnable<List<class_2561>> cir, List<class_2561> tooltipList) {
        ArrayList<class_5250> tooltip;
        if (!Artifacts.CONFIG.client.showTooltips.get().booleanValue()) {
            return;
        }
        class_1799 stack = (class_1799)this;
        if (stack.method_7909() instanceof WearableArtifactItem) {
            tooltip = new ArrayList<class_5250>();
            if (AbilityHelper.isCosmetic(stack)) {
                tooltip.add(class_2561.method_43471((String)"%s.tooltip.cosmetic".formatted("artifacts")).method_27692(class_124.field_1056));
            } else {
                PlatformServices.platformHelper.addCosmeticToggleTooltip(tooltip, stack);
            }
            tooltip.forEach(line -> tooltipList.add((class_2561)line.method_27692(class_124.field_1080)));
        }
        if (stack.method_57826((class_9331)ModDataComponents.ABILITIES.comp_349())) {
            tooltip = new ArrayList();
            if (!AbilityHelper.isCosmetic(stack)) {
                for (ArtifactAbility ability : AbilityHelper.getAbilities(stack)) {
                    ability.addTooltipIfNonCosmetic(tooltip);
                }
            }
            tooltip.forEach(line -> tooltipList.add((class_2561)line.method_27692(class_124.field_1080)));
        }
    }

    @Inject(method={"addAttributeTooltips"}, at={@At(value="TAIL")})
    private void addAttributeTooltips(Consumer<class_2561> consumer, @Nullable class_1657 player, CallbackInfo info) {
        class_1799 self = (class_1799)this;
        class_9285 itemAttributeModifiers = (class_9285)self.method_57825(class_9334.field_49636, (Object)class_9285.field_49326);
        boolean hasSlotTooltip = false;
        if (itemAttributeModifiers.comp_2394()) {
            for (class_1304 slot : class_1304.values()) {
                MutableBoolean b = new MutableBoolean(false);
                self.method_57354(slot, (holder, attributeModifier) -> b.setTrue());
                if (!b.booleanValue()) continue;
                hasSlotTooltip = true;
                ItemStackMixin.artifacts$addAbilityAttributeTooltips(self, consumer);
            }
        }
        if (!hasSlotTooltip) {
            if (AbilityHelper.hasAbility((ArtifactAbility.Type)ModAbilities.ATTRIBUTE_MODIFIER.comp_349(), self) || AbilityHelper.hasAbility((ArtifactAbility.Type)ModAbilities.MOB_EFFECT.comp_349(), self) || AbilityHelper.hasAbility((ArtifactAbility.Type)ModAbilities.LIMITED_WATER_BREATHING.comp_349(), self)) {
                consumer.accept(class_5244.field_39003);
                consumer.accept((class_2561)class_2561.method_43471((String)"item.modifiers.body").method_27692(class_124.field_1080));
            }
            ItemStackMixin.artifacts$addAbilityAttributeTooltips(self, consumer);
        }
        ItemStackMixin.artifacts$addWhenHurtTooltips(consumer, self);
        ItemStackMixin.artifacts$addPerFoodPointEatenTooltip(consumer, self);
        ItemStackMixin.artifacts$addAttacksInflictTooltip(consumer, self, false);
        ItemStackMixin.artifacts$addAttacksInflictTooltip(consumer, self, true);
    }

    @Unique
    private static void artifacts$addAbilityAttributeTooltips(class_1799 stack, Consumer<class_2561> tooltip) {
        AbilityHelper.getAbilities((ArtifactAbility.Type)ModAbilities.ATTRIBUTE_MODIFIER.comp_349(), stack).forEach(ability -> ItemStackMixin.artifacts$addAbilityAttributeTooltip(tooltip, ability));
        AbilityHelper.getAbilities((ArtifactAbility.Type)ModAbilities.MOB_EFFECT.comp_349(), stack).forEach(ability -> ItemStackMixin.artifacts$addMobEffectTooltip(tooltip, (class_1291)ability.mobEffect().comp_349(), (Integer)ability.duration().get(), (Integer)ability.level().get(), ability.isInfinite()));
        AbilityHelper.getAbilities((ArtifactAbility.Type)ModAbilities.LIMITED_WATER_BREATHING.comp_349(), stack).forEach(ability -> ItemStackMixin.artifacts$addMobEffectTooltip(tooltip, (class_1291)ability.mobEffect().comp_349(), (Integer)ability.duration().get(), (Integer)ability.level().get(), ability.isInfinite()));
    }

    @Unique
    private static void artifacts$addAbilityAttributeTooltip(Consumer<class_2561> tooltip, AttributeModifierAbility ability) {
        double amount = (Double)ability.amount().get();
        if (ability.operation() != class_1322.class_1323.field_6328) {
            amount *= 100.0;
        } else if (ability.attribute().equals((Object)class_5134.field_23718)) {
            amount *= 10.0;
        }
        if (amount > 0.0) {
            tooltip.accept((class_2561)class_2561.method_43469((String)("attribute.modifier.plus." + ability.operation().method_56082()), (Object[])new Object[]{class_9285.field_49329.format(amount), class_2561.method_43471((String)((class_1320)ability.attribute().comp_349()).method_26830())}).method_27692(((class_1320)ability.attribute().comp_349()).method_60494(true)));
        } else if (amount < 0.0) {
            tooltip.accept((class_2561)class_2561.method_43469((String)("attribute.modifier.take." + ability.operation().method_56082()), (Object[])new Object[]{class_9285.field_49329.format(amount *= -1.0), class_2561.method_43471((String)((class_1320)ability.attribute().comp_349()).method_26830())}).method_27692(((class_1320)ability.attribute().comp_349()).method_60494(false)));
        }
    }

    @Unique
    private static void artifacts$addWhenHurtTooltips(Consumer<class_2561> tooltip, class_1799 stack) {
        MutableBoolean flag = new MutableBoolean(false);
        ArrayList list = new ArrayList();
        AbilityHelper.getAbilities((ArtifactAbility.Type)ModAbilities.APPLY_MOB_EFFECT_AFTER_DAMAGE.comp_349(), stack).forEach(ability -> {
            if (ability.tag().isEmpty()) {
                flag.setTrue();
            } else if (!list.contains(ability.tag().get())) {
                list.add(ability.tag().get());
            }
        });
        AbilityHelper.getAbilities((ArtifactAbility.Type)ModAbilities.APPLY_COOLDOWN_AFTER_DAMAGE.comp_349(), stack).forEach(ability -> {
            if (ability.tag().isEmpty()) {
                flag.setTrue();
            } else if (!list.contains(ability.tag().get())) {
                list.add(ability.tag().get());
            }
        });
        if (flag.booleanValue()) {
            tooltip.accept(class_5244.field_39003);
            tooltip.accept((class_2561)class_2561.method_43471((String)"artifacts.tooltip.when_hurt").method_27692(class_124.field_1080));
            ItemStackMixin.artifacts$addWhenHurtTooltip(tooltip, stack, null);
        }
        for (class_6862 tag : list) {
            tooltip.accept(class_5244.field_39003);
            tooltip.accept((class_2561)class_2561.method_43471((String)"artifacts.tooltip.when_hurt.%s".formatted(tag.comp_327().toString().replace("minecraft:", "").replace(':', '.'))).method_27692(class_124.field_1080));
            ItemStackMixin.artifacts$addWhenHurtTooltip(tooltip, stack, (class_6862<class_8110>)tag);
        }
    }

    @Unique
    private static void artifacts$addWhenHurtTooltip(Consumer<class_2561> tooltip, class_1799 stack, @Nullable class_6862<class_8110> tag) {
        AbilityHelper.getAbilities((ArtifactAbility.Type)ModAbilities.APPLY_MOB_EFFECT_AFTER_DAMAGE.comp_349(), stack).forEach(ability -> {
            if (ability.tag().isEmpty() && tag == null || ability.tag().isPresent() && ability.tag().get().equals((Object)tag)) {
                ItemStackMixin.artifacts$addMobEffectTooltip(tooltip, (class_1291)ability.mobEffect().comp_349(), (Integer)ability.duration().get(), (Integer)ability.level().get(), false);
            }
        });
        AbilityHelper.getAbilities((ArtifactAbility.Type)ModAbilities.APPLY_COOLDOWN_AFTER_DAMAGE.comp_349(), stack).forEach(ability -> {
            if (ability.tag().isEmpty() && tag == null || ability.tag().isPresent() && ability.tag().get().equals((Object)tag)) {
                tooltip.accept((class_2561)class_2561.method_43469((String)"artifacts.tooltip.cooldown", (Object[])new Object[]{ItemStackMixin.artifacts$formatDurationSeconds((Integer)ability.cooldown().get())}).method_27692(class_124.field_1065));
            }
        });
    }

    @Unique
    private static void artifacts$addPerFoodPointEatenTooltip(Consumer<class_2561> tooltip, class_1799 stack) {
        if (AbilityHelper.hasAbility((ArtifactAbility.Type)ModAbilities.APPLY_MOB_EFFECT_AFTER_EATING.comp_349(), stack)) {
            tooltip.accept(class_5244.field_39003);
            tooltip.accept((class_2561)class_2561.method_43471((String)"artifacts.tooltip.per_food_point_restored").method_27692(class_124.field_1080));
            AbilityHelper.getAbilities((ArtifactAbility.Type)ModAbilities.APPLY_MOB_EFFECT_AFTER_EATING.comp_349(), stack).forEach(ability -> ItemStackMixin.artifacts$addMobEffectTooltip(tooltip, (class_1291)ability.mobEffect().comp_349(), (Integer)ability.duration().get(), (Integer)ability.level().get(), false));
        }
    }

    @Unique
    private static void artifacts$addAttacksInflictTooltip(Consumer<class_2561> tooltip, class_1799 stack, boolean chance) {
        if (AbilityHelper.hasAbility((ArtifactAbility.Type)ModAbilities.ATTACKS_INFLICT_MOB_EFFECT.comp_349(), stack, ability -> chance ^ class_3532.method_20390((double)((Double)ability.chance().get()), (double)1.0))) {
            tooltip.accept(class_5244.field_39003);
            tooltip.accept((class_2561)class_2561.method_43471((String)("artifacts.tooltip.attacks_inflict." + (chance ? "chance" : "constant"))).method_27692(class_124.field_1080));
            AbilityHelper.getAbilities((ArtifactAbility.Type)ModAbilities.ATTACKS_INFLICT_MOB_EFFECT.comp_349(), stack).forEach(ability -> {
                ItemStackMixin.artifacts$addMobEffectTooltip(tooltip, (class_1291)ability.mobEffect().comp_349(), (Integer)ability.duration().get(), (Integer)ability.level().get(), false);
                if ((Integer)ability.cooldown().get() > 0) {
                    tooltip.accept((class_2561)class_2561.method_43469((String)"artifacts.tooltip.cooldown", (Object[])new Object[]{ItemStackMixin.artifacts$formatDurationSeconds((Integer)ability.cooldown().get())}).method_27692(class_124.field_1065));
                }
            });
        }
    }

    @Unique
    private static void artifacts$addMobEffectTooltip(Consumer<class_2561> tooltip, class_1291 mobEffect, int duration, int level, boolean isInfinite) {
        class_5250 mutableComponent = class_2561.method_43471((String)mobEffect.method_5567());
        if (level > 1) {
            mutableComponent = class_2561.method_43469((String)"potion.withAmplifier", (Object[])new Object[]{mutableComponent, class_2561.method_43471((String)("potion.potency." + (level - 1)))});
        }
        if (!isInfinite) {
            mutableComponent = class_2561.method_43469((String)"potion.withDuration", (Object[])new Object[]{mutableComponent, ItemStackMixin.artifacts$formatDurationSeconds(duration)});
        }
        tooltip.accept((class_2561)class_2561.method_43469((String)"artifacts.tooltip.plus_mob_effect", (Object[])new Object[]{mutableComponent}).method_27692(mobEffect.method_18792().method_18793()));
    }

    @Unique
    private static class_5250 artifacts$formatDurationSeconds(int seconds) {
        return class_2561.method_43470((String)class_3544.method_15439((int)(seconds * 20), (float)20.0f));
    }
}

