/*
 * Decompiled with CFR 0.152.
 */
package artifacts.util;

import artifacts.ability.ArtifactAbility;
import artifacts.component.AbilityToggles;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModAbilities;
import artifacts.registry.ModDataComponents;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_5321;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public class AbilityHelper {
    public static <A extends ArtifactAbility, T> T reduce(ArtifactAbility.Type<A> type, class_1309 entity, boolean skipItemsOnCooldown, T init, BiFunction<A, T, T> f) {
        return (T)PlatformServices.platformHelper.reduceItems(entity, init, (stack, init_) -> {
            for (ArtifactAbility ability : AbilityHelper.getAbilities(stack)) {
                if (ability.getType() != type || skipItemsOnCooldown && AbilityHelper.isOnCooldown(entity, stack)) continue;
                init_ = f.apply(ability, init_);
            }
            return init_;
        });
    }

    private static boolean isOnCooldown(class_1309 entity, class_1799 stack) {
        class_1657 player;
        return !(entity instanceof class_1657) || (player = (class_1657)entity).method_7357().method_7904(stack.method_7909());
    }

    public static boolean hasAbility(ArtifactAbility.Type<?> type, class_1799 stack) {
        return AbilityHelper.hasAbility(type, stack, ability -> true);
    }

    public static <T extends ArtifactAbility> boolean hasAbility(ArtifactAbility.Type<T> type, class_1799 stack, Predicate<T> predicate) {
        for (ArtifactAbility ability : AbilityHelper.getAbilities(stack)) {
            if (ability.getType() != type || !ability.isEnabled() || !predicate.test(ability)) continue;
            return true;
        }
        return false;
    }

    public static boolean isToggledOn(ArtifactAbility.Type<?> type, class_1309 entity) {
        AbilityToggles abilityToggles = PlatformServices.platformHelper.getAbilityToggles(entity);
        if (abilityToggles != null) {
            return abilityToggles.isToggledOn(type);
        }
        return true;
    }

    public static boolean hasAbilityActive(ArtifactAbility.Type<?> type, @Nullable class_1309 entity) {
        return AbilityHelper.hasAbilityActive(type, entity, false);
    }

    public static boolean hasAbilityActive(ArtifactAbility.Type<?> type, @Nullable class_1309 entity, boolean skipItemsOnCooldown) {
        return AbilityHelper.hasAbilityActive(type, entity, skipItemsOnCooldown, ability -> true);
    }

    public static <A extends ArtifactAbility> boolean hasAbilityActive(ArtifactAbility.Type<A> type, @Nullable class_1309 entity, Predicate<A> predicate) {
        return AbilityHelper.hasAbilityActive(type, entity, false, predicate);
    }

    public static <A extends ArtifactAbility> boolean hasAbilityActive(ArtifactAbility.Type<A> type, @Nullable class_1309 entity, boolean skipItemsOnCooldown, Predicate<A> predicate) {
        if (entity == null || !AbilityHelper.isToggledOn(type, entity)) {
            return false;
        }
        return AbilityHelper.reduce(type, entity, skipItemsOnCooldown, false, (ability, b) -> b != false || ability.isEnabled() && predicate.test(ability));
    }

    public static List<ArtifactAbility> getAbilities(class_1799 stack) {
        if (stack.method_57826((class_9331)ModDataComponents.ABILITIES.comp_349())) {
            return (List)stack.method_57824((class_9331)ModDataComponents.ABILITIES.comp_349());
        }
        return List.of();
    }

    public static <T extends ArtifactAbility> Stream<T> getAbilities(ArtifactAbility.Type<T> type, class_1799 stack) {
        return AbilityHelper.getAbilities(stack).stream().filter(ability -> ability.getType() == type).filter(ArtifactAbility::isEnabled).map(ability -> ability);
    }

    public static boolean isCosmetic(class_1799 stack) {
        for (ArtifactAbility ability : AbilityHelper.getAbilities(stack)) {
            if (!ability.isNonCosmetic()) continue;
            return false;
        }
        return true;
    }

    public static int getEnchantmentSum(class_5321<class_1887> enchantment, class_1309 entity) {
        return AbilityHelper.sumInt((ArtifactAbility.Type)ModAbilities.INCREASE_ENCHANTMENT_LEVEL.comp_349(), entity, ability -> ability.enchantment().equals((Object)enchantment) ? ability.getAmount() : 0, false);
    }

    public static <A extends ArtifactAbility> int sumInt(ArtifactAbility.Type<A> type, class_1309 entity, Function<A, Integer> f, boolean skipItemsOnCooldown) {
        return AbilityHelper.reduce(type, entity, skipItemsOnCooldown, 0, (ability, i) -> i + (Integer)f.apply(ability));
    }

    public static <A extends ArtifactAbility> double maxDouble(ArtifactAbility.Type<A> type, class_1309 entity, Function<A, Double> f, boolean skipItemsOnCooldown) {
        return AbilityHelper.reduce(type, entity, skipItemsOnCooldown, 0.0, (ability, d) -> Math.max(d, (Double)f.apply(ability)));
    }

    public static <A extends ArtifactAbility> int maxInt(ArtifactAbility.Type<A> type, class_1309 entity, Function<A, Integer> f, boolean skipItemsOnCooldown) {
        return AbilityHelper.reduce(type, entity, skipItemsOnCooldown, 0, (ability, d) -> Math.max(d, (Integer)f.apply(ability)));
    }

    public static <A extends ArtifactAbility> int minInt(ArtifactAbility.Type<A> type, class_1309 entity, int init, Function<A, Integer> f, boolean skipItemsOnCooldown) {
        return AbilityHelper.reduce(type, entity, skipItemsOnCooldown, init, (ability, d) -> Math.min(d, (Integer)f.apply(ability)));
    }

    public static void addCooldown(ArtifactAbility.Type<?> type, class_1309 entity, int ticks) {
        if (ticks > 0 && !entity.method_37908().method_8608() && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            PlatformServices.platformHelper.findAllEquippedBy(entity, stack -> AbilityHelper.hasAbility(type, stack)).forEach(stack -> player.method_7357().method_7906(stack.method_7909(), ticks));
        }
    }

    public static <A extends ArtifactAbility> void applyCooldowns(ArtifactAbility.Type<A> type, class_1309 entity, Function<A, Integer> cooldown) {
        class_1657 player;
        if (entity instanceof class_1657 && !(player = (class_1657)entity).method_37908().method_8608()) {
            AbilityHelper.forEach(type, entity, (ability, stack) -> {
                int c = (Integer)cooldown.apply(ability) * 20;
                if (c > 0) {
                    player.method_7357().method_7906(stack.method_7909(), c);
                }
            }, true);
        }
    }

    public static <A extends ArtifactAbility> void forEach(ArtifactAbility.Type<A> type, class_1309 entity, Consumer<A> consumer) {
        AbilityHelper.forEach(type, entity, (ability, stack) -> consumer.accept(ability), false);
    }

    public static <A extends ArtifactAbility> void forEach(ArtifactAbility.Type<A> type, class_1309 entity, BiConsumer<A, class_1799> consumer, boolean skipItemsOnCooldown) {
        PlatformServices.platformHelper.findAllEquippedBy(entity, stack -> AbilityHelper.hasAbility(type, stack)).forEach(stack -> AbilityHelper.getAbilities(type, stack).filter(ArtifactAbility::isEnabled).filter(ability -> {
            class_1657 player;
            return !skipItemsOnCooldown || !(entity instanceof class_1657) || !(player = (class_1657)entity).method_7357().method_7904(stack.method_7909());
        }).forEach(ability -> consumer.accept((Object)ability, (class_1799)stack)));
    }
}

