/*
 * Decompiled with CFR 0.152.
 */
package artifacts.world;

import artifacts.Artifacts;
import artifacts.entity.MimicEntity;
import artifacts.registry.ModEntityTypes;
import artifacts.registry.ModTags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1945;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3708;
import net.minecraft.class_3710;
import net.minecraft.class_3716;
import net.minecraft.class_3865;
import net.minecraft.class_3922;
import net.minecraft.class_4651;
import net.minecraft.class_4656;
import net.minecraft.class_4657;
import net.minecraft.class_52;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5544;
import net.minecraft.class_5545;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6005;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8934;

public class CampsiteFeature
extends class_3031<class_3111> {
    private static final class_4651 UNLIT_CAMPFIRES = class_4656.method_38433((class_2680)((class_2680)class_2246.field_17350.method_9564().method_11657((class_2769)class_3922.field_17352, (Comparable)Boolean.valueOf(false))));
    private static final class_4651 LIT_CAMPFIRES = new class_4657(class_6005.method_34971().method_34975((Object)((class_2680)class_2246.field_17350.method_9564().method_11657((class_2769)class_3922.field_17352, (Comparable)Boolean.valueOf(true))), 9).method_34975((Object)((class_2680)class_2246.field_23860.method_9564().method_11657((class_2769)class_3922.field_17352, (Comparable)Boolean.valueOf(true))), 1));
    private static final class_4651 DECORATIONS = new class_4657(class_6005.method_34971().method_34975((Object)class_2246.field_10487.method_9564(), 2).method_34975((Object)class_2246.field_10586.method_9564(), 2).method_34975((Object)class_2246.field_10598.method_9564(), 2).method_34975((Object)class_2246.field_10333.method_9564(), 1).method_34975((Object)((class_2680)class_2246.field_27142.method_9564().method_11657((class_2769)class_5545.field_27183, (Comparable)Boolean.valueOf(true))), 1));
    private static final class_4651 CRAFTING_STATIONS = new class_4657(class_6005.method_34971().method_34975((Object)class_2246.field_9980.method_9564(), 5).method_34975((Object)class_2246.field_16329.method_9564(), 5).method_34975((Object)class_2246.field_16331.method_9564(), 5).method_34975((Object)class_2246.field_16336.method_9564(), 5).method_34975((Object)class_2246.field_10535.method_9564(), 2).method_34975((Object)class_2246.field_10105.method_9564(), 2).method_34975((Object)class_2246.field_10414.method_9564(), 1));
    private static final class_4651 FURNACES = new class_4657(class_6005.method_34971().method_34975((Object)((class_2680)class_2246.field_10181.method_9564().method_11657((class_2769)class_3865.field_11105, (Comparable)Boolean.valueOf(false))), 2).method_34975((Object)((class_2680)class_2246.field_16333.method_9564().method_11657((class_2769)class_3710.field_11105, (Comparable)Boolean.valueOf(false))), 1).method_34975((Object)((class_2680)class_2246.field_16334.method_9564().method_11657((class_2769)class_3716.field_11105, (Comparable)Boolean.valueOf(false))), 1));
    private static final class_4651 FURNACE_CHIMNEYS = new class_4657(class_6005.method_34971().method_34975((Object)class_2246.field_10625.method_9564(), 2).method_34975((Object)class_2246.field_28891.method_9564(), 2).method_34975((Object)class_2246.field_10252.method_9564(), 1).method_34975((Object)class_2246.field_28903.method_9564(), 1));
    private static final class_4651 BEDS = new class_4657(class_6005.method_34971().method_34975((Object)class_2246.field_10069.method_9564(), 1).method_34975((Object)class_2246.field_10356.method_9564(), 1).method_34975((Object)class_2246.field_10109.method_9564(), 1).method_34975((Object)class_2246.field_10141.method_9564(), 1).method_34975((Object)class_2246.field_10230.method_9564(), 1).method_34975((Object)class_2246.field_10561.method_9564(), 1));
    private static final class_4651 LIGHT_SOURCES = new class_4657(class_6005.method_34971().method_34975((Object)class_2246.field_16541.method_9564(), 4).method_34975((Object)((class_2680)class_2246.field_27099.method_9564().method_11657((class_2769)class_5544.field_27175, (Comparable)Boolean.valueOf(true))), 1).method_34975((Object)((class_2680)((class_2680)class_2246.field_27099.method_9564().method_11657((class_2769)class_5544.field_27175, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_5544.field_27174, (Comparable)Integer.valueOf(2))), 1).method_34975((Object)((class_2680)((class_2680)class_2246.field_27099.method_9564().method_11657((class_2769)class_5544.field_27175, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_5544.field_27174, (Comparable)Integer.valueOf(3))), 1).method_34975((Object)((class_2680)((class_2680)class_2246.field_27099.method_9564().method_11657((class_2769)class_5544.field_27175, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_5544.field_27174, (Comparable)Integer.valueOf(4))), 1).method_34975((Object)class_2246.field_22110.method_9564(), 1));
    private static final class_4651 UNLIT_LIGHT_SOURCES = new class_4657(class_6005.method_34971().method_34975((Object)((class_2680)class_2246.field_27099.method_9564().method_11657((class_2769)class_5544.field_27175, (Comparable)Boolean.valueOf(false))), 1).method_34975((Object)((class_2680)((class_2680)class_2246.field_27099.method_9564().method_11657((class_2769)class_5544.field_27175, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_5544.field_27174, (Comparable)Integer.valueOf(2))), 1).method_34975((Object)((class_2680)((class_2680)class_2246.field_27099.method_9564().method_11657((class_2769)class_5544.field_27175, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_5544.field_27174, (Comparable)Integer.valueOf(3))), 1).method_34975((Object)((class_2680)((class_2680)class_2246.field_27099.method_9564().method_11657((class_2769)class_5544.field_27175, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_5544.field_27174, (Comparable)Integer.valueOf(4))), 1));
    public static final class_5321<class_52> CHEST_LOOT = Artifacts.key(class_7924.field_50079, "chests/campsite_chest");
    public static final class_5321<class_52> BARREL_LOOT = Artifacts.key(class_7924.field_50079, "chests/campsite_barrel");

    public CampsiteFeature() {
        super(class_3111.field_24893);
    }

    public boolean method_13151(class_5821<class_3111> context) {
        class_5281 level = context.method_33652();
        class_2338 origin = context.method_33655();
        class_5819 random = context.method_33654();
        if (!this.isSufficientlyFlat(level, origin)) {
            return false;
        }
        class_2338.method_20437((class_2338)origin.method_10069(-2, 0, -2), (class_2338)origin.method_10069(2, 2, 2)).filter(pos -> Math.abs(pos.method_10263() - origin.method_10263()) < 2 || Math.abs(pos.method_10260() - origin.method_10260()) < 2).filter(pos -> !level.method_8320(pos).method_26215()).forEach(pos -> this.method_13153((class_1945)level, (class_2338)pos, class_2246.field_10543.method_9564()));
        this.placeFloor(level, origin, random);
        this.placeCampfire(level, origin, random);
        class_2350 direction = class_2350.class_2353.field_11062.method_10183(random);
        class_2338 pos2 = origin.method_10079(direction, 2);
        if (random.method_43048(3) == 0) {
            class_2338.method_20437((class_2338)pos2.method_10093(direction.method_10170()), (class_2338)pos2.method_10093(direction.method_10160())).forEach(barrelPos -> {
                this.placeBarrel(level, (class_2338)barrelPos, random);
                if (random.method_43048(3) == 0) {
                    this.placeBarrel(level, barrelPos.method_10084(), random);
                }
            });
        } else {
            class_2350 bedDirection = random.method_43056() ? direction.method_10170() : direction.method_10160();
            class_2680 bedBlock = (class_2680)BEDS.method_23455(random, pos2).method_11657((class_2769)class_2244.field_11177, (Comparable)bedDirection);
            this.method_13153((class_1945)level, pos2, (class_2680)bedBlock.method_11657((class_2769)class_2244.field_9967, (Comparable)class_2742.field_12560));
            this.method_13153((class_1945)level, pos2.method_10093(bedDirection.method_10153()), (class_2680)bedBlock.method_11657((class_2769)class_2244.field_9967, (Comparable)class_2742.field_12557));
            this.placeBarrel(level, pos2.method_10093(bedDirection), random);
            this.placeLightSource(level, pos2.method_10093(bedDirection).method_10084(), random);
        }
        direction = random.method_43056() ? direction.method_10170() : direction.method_10160();
        pos2 = origin.method_10079(direction, 2);
        List positions = class_2338.method_20437((class_2338)pos2.method_10093(direction.method_10170()), (class_2338)pos2.method_10093(direction.method_10160())).map(class_2338::method_10062).collect(Collectors.toCollection(ArrayList::new));
        Collections.shuffle(positions);
        this.placeCraftingStation(level, (class_2338)positions.removeFirst(), random, direction.method_10153());
        this.placeFurnace(level, (class_2338)positions.removeFirst(), random, direction.method_10153());
        this.placeChest(level, (class_2338)positions.removeFirst(), random, direction.method_10153());
        return true;
    }

    private boolean isSufficientlyFlat(class_5281 level, class_2338 origin) {
        return class_2338.method_20437((class_2338)origin.method_10069(-2, 0, -2), (class_2338)origin.method_10069(2, 0, 2)).filter(pos -> level.method_8320(pos.method_10074()).method_26206((class_1922)level, pos.method_10074(), class_2350.field_11036)).filter(pos -> level.method_8320(pos).method_26215()).count() >= 6L;
    }

    private void placeFloor(class_5281 level, class_2338 origin, class_5819 random) {
        class_2338.method_20437((class_2338)origin.method_10069(-2, -1, -2), (class_2338)origin.method_10069(2, -1, 2)).filter(pos -> Math.abs(pos.method_10263() - origin.method_10263()) < 2 || Math.abs(pos.method_10260() - origin.method_10260()) < 2).forEach(pos -> {
            if (!level.method_8320(pos).method_26206((class_1922)level, pos, class_2350.field_11036)) {
                this.method_13153((class_1945)level, (class_2338)pos, class_2246.field_10161.method_9564());
            } else if (random.method_43056()) {
                if (level.method_8320(pos).method_27852(class_2246.field_28888)) {
                    this.method_13153((class_1945)level, (class_2338)pos, class_2246.field_29031.method_9564());
                } else if (level.method_8320(pos).method_27852(class_2246.field_10340)) {
                    this.method_13153((class_1945)level, (class_2338)pos, class_2246.field_10445.method_9564());
                }
            }
        });
    }

    private void placeCampfire(class_5281 level, class_2338 origin, class_5819 random) {
        class_2680 campfire = UNLIT_CAMPFIRES.method_23455(random, origin);
        if (Artifacts.CONFIG.general.campsite.allowLightSources.get().booleanValue() && (double)random.method_43057() < 0.1) {
            campfire = LIT_CAMPFIRES.method_23455(random, origin);
        }
        this.method_13153((class_1945)level, origin, campfire);
    }

    private void placeLightSource(class_5281 level, class_2338 pos, class_5819 random) {
        if ((double)random.method_43057() < 0.5) {
            class_2680 lightSource = UNLIT_LIGHT_SOURCES.method_23455(random, pos);
            if (Artifacts.CONFIG.general.campsite.allowLightSources.get().booleanValue() && (double)random.method_43057() < 0.3) {
                lightSource = LIGHT_SOURCES.method_23455(random, pos);
            }
            this.method_13153((class_1945)level, pos, lightSource);
        }
    }

    private void placeCraftingStation(class_5281 level, class_2338 pos, class_5819 random, class_2350 facing) {
        class_2680 craftingStation = CRAFTING_STATIONS.method_23455(random, pos);
        if (craftingStation.method_28498((class_2769)class_2741.field_12481)) {
            craftingStation = (class_2680)craftingStation.method_11657((class_2769)class_2741.field_12481, (Comparable)facing);
        }
        this.method_13153((class_1945)level, pos, craftingStation);
        if (random.method_43048(3) == 0) {
            this.method_13153((class_1945)level, pos.method_10084(), DECORATIONS.method_23455(random, pos));
        }
    }

    private void placeFurnace(class_5281 level, class_2338 pos, class_5819 random, class_2350 facing) {
        class_2680 furnace = FURNACES.method_23455(random, pos);
        furnace = (class_2680)furnace.method_11657((class_2769)class_3865.field_11104, (Comparable)facing);
        this.method_13153((class_1945)level, pos, furnace);
        if (random.method_43056()) {
            this.method_13153((class_1945)level, pos.method_10084(), FURNACE_CHIMNEYS.method_23455(random, pos));
        }
    }

    private void placeBarrel(class_5281 level, class_2338 pos, class_5819 random) {
        class_2680 barrel = class_2246.field_16328.method_9564();
        barrel = random.method_43056() ? (class_2680)barrel.method_11657((class_2769)class_3708.field_16320, (Comparable)class_2350.field_11036) : (class_2680)barrel.method_11657((class_2769)class_3708.field_16320, (Comparable)class_2350.class_2353.field_11062.method_10183(random));
        this.method_13153((class_1945)level, pos, barrel);
        class_8934.method_54868((class_1922)level, (class_5819)random, (class_2338)pos, BARREL_LOOT);
    }

    public void placeChest(class_5281 level, class_2338 pos, class_5819 random, class_2350 facing) {
        if ((double)random.method_43057() < Artifacts.CONFIG.general.campsite.mimicChance.get()) {
            MimicEntity mimic = (MimicEntity)((class_1299)ModEntityTypes.MIMIC.comp_349()).method_5883((class_1937)level.method_8410());
            if (mimic != null) {
                mimic.setDormant(true);
                mimic.setFacing(facing);
                mimic.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
                level.method_8649((class_1297)mimic);
            }
        } else {
            class_2680 chest;
            if (random.method_43048(8) == 0) {
                this.method_13153((class_1945)level, pos.method_10074(), class_2246.field_10375.method_9564());
                chest = class_2246.field_10380.method_9564();
                this.method_13153((class_1945)level, pos, (class_2680)class_2246.field_10380.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)class_2350.class_2353.field_11062.method_10183(random)));
            } else {
                chest = Artifacts.CONFIG.general.campsite.useModdedChests.get() != false ? ModTags.getTag(ModTags.CAMPSITE_CHESTS).method_40243(random).map(class_6880::comp_349).orElse(class_2246.field_10034).method_9564() : class_2246.field_10034.method_9564();
            }
            if (chest.method_28498((class_2769)class_2741.field_12481)) {
                chest = (class_2680)chest.method_11657((class_2769)class_2741.field_12481, (Comparable)facing);
            }
            this.method_13153((class_1945)level, pos, chest);
            class_8934.method_54868((class_1922)level, (class_5819)random, (class_2338)pos, CHEST_LOOT);
        }
    }
}

