/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasons.resources;

import com.google.gson.JsonParser;
import io.github.lucaargolo.seasons.FabricSeasons;
import io.github.lucaargolo.seasons.utils.Season;
import io.github.lucaargolo.seasons.utils.SeasonColor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3685;

public class FoliageSeasonColors
implements SimpleSynchronousResourceReloadListener {
    private static final class_2960 SPRING_FOLIAGE_COLORMAP = FabricSeasons.identifier("textures/colormap/spring_foliage.png");
    private static final class_2960 SUMMER_FOLIAGE_COLORMAP = FabricSeasons.identifier("textures/colormap/summer_foliage.png");
    private static final class_2960 FALL_FOLIAGE_COLORMAP = FabricSeasons.identifier("textures/colormap/fall_foliage.png");
    private static final class_2960 WINTER_FOLIAGE_COLORMAP = FabricSeasons.identifier("textures/colormap/winter_foliage.png");
    private static int[] springColorMap = new int[65536];
    private static int[] summerColorMap = new int[65536];
    private static int[] fallColorMap = new int[65536];
    private static int[] winterColorMap = new int[65536];
    private static SeasonColor minecraftDefaultFoliage = new SeasonColor(4764952, 5038091, 13815582, 13033398);
    private static SeasonColor minecraftSpruceFoliage = new SeasonColor(0x619961, 0x619961, 0x619961, 0x619961);
    private static SeasonColor minecraftBirchFoliage = new SeasonColor(8431445, 8501316, 14051328, 6705190);
    private static final HashMap<class_2960, SeasonColor> foliageColorMap = new HashMap();

    public static Optional<Integer> getSeasonFoliageColor(class_1959 biome, class_2960 biomeIdentifier, Season season) {
        Optional<SeasonColor> colors = foliageColorMap.containsKey(biomeIdentifier) ? Optional.of(foliageColorMap.get(biomeIdentifier)) : Optional.empty();
        return colors.map(seasonColor -> seasonColor.getColor(season));
    }

    public static int getColor(Season season, double temperature, double humidity) {
        int i = (int)((1.0 - temperature) * 255.0);
        int j = (int)((1.0 - (humidity *= temperature)) * 255.0);
        return switch (season) {
            default -> throw new IncompatibleClassChangeError();
            case Season.SPRING -> springColorMap[j << 8 | i];
            case Season.SUMMER -> summerColorMap[j << 8 | i];
            case Season.FALL -> fallColorMap[j << 8 | i];
            case Season.WINTER -> winterColorMap[j << 8 | i];
        };
    }

    public static int getSpruceColor(Season season) {
        return minecraftSpruceFoliage.getColor(season);
    }

    public static int getBirchColor(Season season) {
        return minecraftBirchFoliage.getColor(season);
    }

    public static int getDefaultColor(Season season) {
        return minecraftDefaultFoliage.getColor(season);
    }

    public class_2960 getFabricId() {
        return FabricSeasons.identifier("foliage_season_colors");
    }

    public void method_14491(class_3300 manager) {
        try {
            class_3298 spruceFoliage = (class_3298)manager.method_14486(FabricSeasons.identifier("hardcoded/foliage/spruce.json")).orElseThrow();
            minecraftSpruceFoliage = new SeasonColor(JsonParser.parseReader((Reader)new InputStreamReader(spruceFoliage.method_14482(), StandardCharsets.UTF_8)));
            class_3298 birchFoliage = (class_3298)manager.method_14486(FabricSeasons.identifier("hardcoded/foliage/birch.json")).orElseThrow();
            minecraftBirchFoliage = new SeasonColor(JsonParser.parseReader((Reader)new InputStreamReader(birchFoliage.method_14482(), StandardCharsets.UTF_8)));
            class_3298 defaultFoliage = (class_3298)manager.method_14486(FabricSeasons.identifier("hardcoded/foliage/default.json")).orElseThrow();
            minecraftDefaultFoliage = new SeasonColor(JsonParser.parseReader((Reader)new InputStreamReader(defaultFoliage.method_14482(), StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            FabricSeasons.LOGGER.error("[Fabric Seasons] Failed to load hardcoded foliage colors", (Throwable)e);
        }
        foliageColorMap.clear();
        manager.method_14488("seasons/foliage", id -> id.method_12832().endsWith(".json")).forEach((id, resource) -> {
            String[] split = id.method_12832().split("/");
            class_2960 biomeIdentifier = class_2960.method_60655((String)id.method_12836(), (String)split[split.length - 1].replace(".json", ""));
            try {
                SeasonColor colors = new SeasonColor(JsonParser.parseReader((Reader)new InputStreamReader(resource.method_14482(), StandardCharsets.UTF_8)));
                foliageColorMap.put(biomeIdentifier, colors);
            }
            catch (Exception e) {
                FabricSeasons.LOGGER.error("[Fabric Seasons] Failed to load biome foliage colors for: " + String.valueOf(biomeIdentifier), (Throwable)e);
            }
        });
        if (!foliageColorMap.isEmpty()) {
            FabricSeasons.LOGGER.info("[Fabric Seasons] Successfully loaded " + foliageColorMap.size() + " custom foliage colors.");
        }
        try {
            springColorMap = class_3685.method_16049((class_3300)manager, (class_2960)SPRING_FOLIAGE_COLORMAP);
            summerColorMap = class_3685.method_16049((class_3300)manager, (class_2960)SUMMER_FOLIAGE_COLORMAP);
            fallColorMap = class_3685.method_16049((class_3300)manager, (class_2960)FALL_FOLIAGE_COLORMAP);
            winterColorMap = class_3685.method_16049((class_3300)manager, (class_2960)WINTER_FOLIAGE_COLORMAP);
        }
        catch (IOException e) {
            FabricSeasons.LOGGER.error("[Fabric Seasons] Failed to load foliage color texture", (Throwable)e);
        }
    }
}

