/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasons.resources;

import com.google.gson.JsonParser;
import io.github.lucaargolo.seasons.FabricSeasons;
import io.github.lucaargolo.seasons.utils.Season;
import io.github.lucaargolo.seasons.utils.SeasonColor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3685;

public class GrassSeasonColors
implements SimpleSynchronousResourceReloadListener {
    private static final class_2960 SPRING_GRASS_COLORMAP = FabricSeasons.identifier("textures/colormap/spring_grass.png");
    private static final class_2960 SUMMER_GRASS_COLORMAP = FabricSeasons.identifier("textures/colormap/summer_grass.png");
    private static final class_2960 FALL_GRASS_COLORMAP = FabricSeasons.identifier("textures/colormap/fall_grass.png");
    private static final class_2960 WINTER_GRASS_COLORMAP = FabricSeasons.identifier("textures/colormap/winter_grass.png");
    private static int[] springColorMap = new int[65536];
    private static int[] summerColorMap = new int[65536];
    private static int[] fallColorMap = new int[65536];
    private static int[] winterColorMap = new int[65536];
    private static SeasonColor minecraftSwampGrass1 = new SeasonColor(5011004, 5011004, 5011004, 5011004);
    private static SeasonColor minecraftSwampGrass2 = new SeasonColor(6975545, 6975545, 6975545, 6975545);
    private static final HashMap<class_2960, SeasonColor> grassColorMap = new HashMap();

    public static Optional<Integer> getSeasonGrassColor(class_1959 biome, class_2960 biomeIdentifier, Season season) {
        Optional<SeasonColor> colors = grassColorMap.containsKey(biomeIdentifier) ? Optional.of(grassColorMap.get(biomeIdentifier)) : Optional.empty();
        return colors.map(seasonColor -> seasonColor.getColor(season));
    }

    public static int getColor(Season season, double temperature, double humidity) {
        int i = (int)((1.0 - temperature) * 255.0);
        int j = (int)((1.0 - (humidity *= temperature)) * 255.0);
        int k = j << 8 | i;
        return switch (season) {
            default -> throw new IncompatibleClassChangeError();
            case Season.SPRING -> {
                if (k > springColorMap.length) {
                    yield -65281;
                }
                yield springColorMap[k];
            }
            case Season.SUMMER -> {
                if (k > summerColorMap.length) {
                    yield -65281;
                }
                yield summerColorMap[k];
            }
            case Season.FALL -> {
                if (k > fallColorMap.length) {
                    yield -65281;
                }
                yield fallColorMap[k];
            }
            case Season.WINTER -> k > winterColorMap.length ? -65281 : winterColorMap[k];
        };
    }

    public static int getSwampColor1(Season season) {
        return minecraftSwampGrass1.getColor(season);
    }

    public static int getSwampColor2(Season season) {
        return minecraftSwampGrass2.getColor(season);
    }

    public class_2960 getFabricId() {
        return FabricSeasons.identifier("grass_season_colors");
    }

    public void method_14491(class_3300 manager) {
        try {
            class_3298 swampGrass1 = (class_3298)manager.method_14486(FabricSeasons.identifier("hardcoded/grass/swamp1.json")).orElseThrow();
            minecraftSwampGrass1 = new SeasonColor(JsonParser.parseReader((Reader)new InputStreamReader(swampGrass1.method_14482(), StandardCharsets.UTF_8)));
            class_3298 swampGrass2 = (class_3298)manager.method_14486(FabricSeasons.identifier("hardcoded/grass/swamp2.json")).orElseThrow();
            minecraftSwampGrass2 = new SeasonColor(JsonParser.parseReader((Reader)new InputStreamReader(swampGrass2.method_14482(), StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            FabricSeasons.LOGGER.error("[Fabric Seasons] Failed to load hardcoded grass colors", (Throwable)e);
        }
        grassColorMap.clear();
        manager.method_14488("seasons/grass", id -> id.method_12832().endsWith(".json")).forEach((id, resource) -> {
            String[] split = id.method_12832().split("/");
            class_2960 biomeIdentifier = class_2960.method_60655((String)id.method_12836(), (String)split[split.length - 1].replace(".json", ""));
            try {
                SeasonColor colors = new SeasonColor(JsonParser.parseReader((Reader)new InputStreamReader(resource.method_14482(), StandardCharsets.UTF_8)));
                grassColorMap.put(biomeIdentifier, colors);
            }
            catch (Exception e) {
                FabricSeasons.LOGGER.error("[Fabric Seasons] Failed to load biome grass colors for: " + String.valueOf(biomeIdentifier), (Throwable)e);
            }
        });
        if (!grassColorMap.isEmpty()) {
            FabricSeasons.LOGGER.info("[Fabric Seasons] Successfully loaded " + grassColorMap.size() + " custom grass colors.");
        }
        try {
            springColorMap = class_3685.method_16049((class_3300)manager, (class_2960)SPRING_GRASS_COLORMAP);
            summerColorMap = class_3685.method_16049((class_3300)manager, (class_2960)SUMMER_GRASS_COLORMAP);
            fallColorMap = class_3685.method_16049((class_3300)manager, (class_2960)FALL_GRASS_COLORMAP);
            winterColorMap = class_3685.method_16049((class_3300)manager, (class_2960)WINTER_GRASS_COLORMAP);
        }
        catch (IOException e) {
            FabricSeasons.LOGGER.error("[Fabric Seasons] Failed to load foliage color texture", (Throwable)e);
        }
    }
}

