/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasons.utils;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lucaargolo.seasons.utils.Season;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_9139;

public class CropConfig {
    public static final Codec<CropConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("spring").forGetter(CropConfig::springModifier), (App)Codec.FLOAT.fieldOf("summer").forGetter(CropConfig::summerModifier), (App)Codec.FLOAT.fieldOf("fall").forGetter(CropConfig::fallModifier), (App)Codec.FLOAT.fieldOf("winter").forGetter(CropConfig::winterModifier)).apply((Applicative)instance, CropConfig::new));
    public static final class_9139<ByteBuf, CropConfig> PACKET_CODEC = class_9139.method_56438(CropConfig::toBuf, CropConfig::fromBuf);
    private final float springModifier;
    private final float summerModifier;
    private final float fallModifier;
    private final float winterModifier;

    public CropConfig(float springModifier, float summerModifier, float fallModifier, float winterModifier) {
        this.springModifier = springModifier;
        this.summerModifier = summerModifier;
        this.fallModifier = fallModifier;
        this.winterModifier = winterModifier;
    }

    public CropConfig(JsonElement json) {
        this.springModifier = this.getStringModifier(json.getAsJsonObject().get("spring").getAsString());
        this.summerModifier = this.getStringModifier(json.getAsJsonObject().get("summer").getAsString());
        this.fallModifier = this.getStringModifier(json.getAsJsonObject().get("fall").getAsString());
        this.winterModifier = this.getStringModifier(json.getAsJsonObject().get("winter").getAsString());
    }

    private float getStringModifier(String modifier) {
        return Float.parseFloat(modifier);
    }

    public float getModifier(Season season) {
        return switch (season) {
            default -> throw new IncompatibleClassChangeError();
            case Season.SPRING -> this.springModifier;
            case Season.SUMMER -> this.summerModifier;
            case Season.FALL -> this.fallModifier;
            case Season.WINTER -> this.winterModifier;
        };
    }

    public void toBuf(ByteBuf buf) {
        buf.writeFloat(this.springModifier);
        buf.writeFloat(this.summerModifier);
        buf.writeFloat(this.fallModifier);
        buf.writeFloat(this.winterModifier);
    }

    public static CropConfig fromBuf(ByteBuf buf) {
        return new CropConfig(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat());
    }

    public float springModifier() {
        return this.springModifier;
    }

    public float summerModifier() {
        return this.summerModifier;
    }

    public float fallModifier() {
        return this.fallModifier;
    }

    public float winterModifier() {
        return this.winterModifier;
    }
}

