/*
 * Decompiled with CFR 0.152.
 */
package net.freedinner.items_displayed.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.freedinner.items_displayed.config.ModConfigs;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_7923;

public class BlockItemMapper {
    private static BiMap<class_2248, class_1792> blockItemMap = HashBiMap.create();

    public static BiMap<class_2248, class_1792> getBlockItemMap() {
        return blockItemMap;
    }

    public static void setBlockItemMap(BiMap<class_2248, class_1792> blockItemMap) {
        BlockItemMapper.blockItemMap = blockItemMap;
    }

    public static void addEntry(class_2248 block, class_1792 item) {
        blockItemMap.put((Object)block, (Object)item);
    }

    public static class_1792 getItemOrNull(class_2248 block) {
        return BlockItemMapper.getItemOrNull(block, false);
    }

    public static class_1792 getItemOrNull(class_2248 block, boolean includeBlacklisted) {
        class_1792 foundItem = (class_1792)blockItemMap.getOrDefault((Object)block, null);
        if (BlockItemMapper.isItemBlacklisted(foundItem) && !includeBlacklisted) {
            return null;
        }
        return foundItem;
    }

    public static class_2248 getBlockOrNull(class_1792 item) {
        return BlockItemMapper.getBlockOrNull(item, false);
    }

    public static class_2248 getBlockOrNull(class_1792 item, boolean includeBlacklisted) {
        if (BlockItemMapper.isItemBlacklisted(item) && !includeBlacklisted) {
            return null;
        }
        return (class_2248)blockItemMap.inverse().getOrDefault((Object)item, null);
    }

    public static boolean isItemBlacklisted(class_1792 item) {
        String itemId = class_7923.field_41178.method_10221((Object)item).toString();
        return ModConfigs.BLACKLISTED_ITEMS.contains(itemId);
    }
}

