/*
 * Decompiled with CFR 0.152.
 */
package fuzs.sneakycurses.client.handler;

import com.google.common.collect.MapMaker;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.sneakycurses.SneakyCurses;
import fuzs.sneakycurses.client.util.ComponentHelper;
import fuzs.sneakycurses.config.ServerConfig;
import fuzs.sneakycurses.handler.CurseRevealHandler;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1706;
import net.minecraft.class_1735;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_471;
import net.minecraft.class_487;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7417;
import net.minecraft.class_7924;
import net.minecraft.class_9636;
import org.jetbrains.annotations.Nullable;

public class ItemTooltipHandler {
    private static final Map<class_1887, Integer> ENCHANTMENT_IDS = new MapMaker().weakKeys().concurrencyLevel(1).makeMap();
    private static final Random RANDOM = new Random();
    private static int currentScreenSeed;

    public static void onAfterInit(class_310 minecraft, class_437 screen, int screenWidth, int screenHeight, List<class_339> widgets, UnaryOperator<class_339> addWidget, Consumer<class_339> removeWidget) {
        ItemTooltipHandler.setFreshSeed();
    }

    private static void setFreshSeed() {
        currentScreenSeed = RANDOM.nextInt();
    }

    public static void onItemTooltip(class_1799 itemStack, List<class_2561> lines, class_1792.class_9635 tooltipContext, @Nullable class_1657 player, class_1836 tooltipFlag) {
        if (tooltipFlag.method_47370() || tooltipContext.method_59527() == null) {
            return;
        }
        if (!SneakyCurses.CONFIG.getHolder(ServerConfig.class).isAvailable() || !((ServerConfig)SneakyCurses.CONFIG.get(ServerConfig.class)).obfuscateCurses) {
            return;
        }
        if (!ItemTooltipHandler.isAffected(player, itemStack)) {
            return;
        }
        ListIterator<class_2561> iterator = lines.listIterator();
        while (iterator.hasNext()) {
            class_2588 contents;
            class_7417 class_74172 = iterator.next().method_10851();
            if (!(class_74172 instanceof class_2588) || !(contents = (class_2588)class_74172).method_11022().startsWith("enchantment.")) continue;
            String[] enchantmentKey = contents.method_11022().split("\\.");
            class_6880 enchantment = null;
            if (enchantmentKey.length >= 3) {
                class_7225.class_7226 enchantments = tooltipContext.method_59527().method_46762(class_7924.field_41265);
                class_2960 resourceLocation = ResourceLocationHelper.fromNamespaceAndPath((String)enchantmentKey[1], (String)enchantmentKey[2]);
                enchantment = enchantments.method_46746(class_5321.method_29179((class_5321)class_7924.field_41265, (class_2960)resourceLocation)).orElse(null);
            }
            if (enchantment == null || !enchantment.method_40220(class_9636.field_51551)) continue;
            if (enchantmentKey.length == 3) {
                int enchantmentId = ENCHANTMENT_IDS.computeIfAbsent((class_1887)enchantment.comp_349(), $ -> RANDOM.nextInt());
                ItemTooltipHandler.initSeed(currentScreenSeed + enchantmentId);
                class_2561 component = ItemTooltipHandler.getLoreForWidth(class_310.method_1551().field_1772);
                iterator.set((class_2561)class_2561.method_43473().method_10852(component).method_27692(class_124.field_1061));
                continue;
            }
            iterator.remove();
        }
    }

    private static boolean isAffected(@Nullable class_1657 player, class_1799 itemStack) {
        if (player != null && player.method_37908().field_9236) {
            if (itemStack.method_7960()) {
                return false;
            }
            class_310 minecraft = class_310.method_1551();
            if (minecraft.field_1761.method_2914() && class_437.method_25442() && ((ServerConfig)SneakyCurses.CONFIG.get(ServerConfig.class)).shiftShows) {
                return false;
            }
            if (itemStack.method_7909() instanceof class_1772 && !((ServerConfig)SneakyCurses.CONFIG.get(ServerConfig.class)).affectBooks) {
                return false;
            }
            class_437 class_4372 = minecraft.field_1755;
            if (class_4372 instanceof class_471) {
                class_1735 inputSlot;
                class_471 screen = (class_471)class_4372;
                class_1735 hoveredSlot = screen.field_2787;
                if (hoveredSlot != null && ((class_1706)screen.method_17577()).method_48360() == hoveredSlot.field_7874 && hoveredSlot.method_7677() == itemStack && !CurseRevealHandler.allCursesRevealed((inputSlot = ((class_1706)screen.method_17577()).method_7611(0)).method_7677())) {
                    return true;
                }
            }
            return CurseRevealHandler.isAffected(itemStack) && !CurseRevealHandler.allCursesRevealed(itemStack);
        }
        return false;
    }

    private static void initSeed(long seed) {
        RANDOM.setSeed(seed);
        class_487.method_2481().method_2480(seed);
    }

    private static class_2561 getLoreForWidth(class_327 font) {
        double maxWidth = RANDOM.nextGaussian(100.0, 20.0);
        class_5348 formattedText = class_487.method_2481().method_2479(font, (int)maxWidth);
        return ComponentHelper.toComponent(formattedText);
    }
}

