/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.api.client.renderer;

import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Collection;
import java.util.Set;
import mod.azure.azurelibarmor.common.api.client.model.GeoModel;
import mod.azure.azurelibarmor.common.api.client.renderer.GeoArmorRenderer;
import mod.azure.azurelibarmor.common.internal.common.cache.object.BakedGeoModel;
import mod.azure.azurelibarmor.common.internal.common.cache.object.GeoBone;
import mod.azure.azurelibarmor.core.object.Color;
import net.minecraft.class_1792;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DyeableGeoArmorRenderer<T extends class_1792>
extends GeoArmorRenderer<T> {
    protected final Set<GeoBone> dyeableBones = new ObjectArraySet();
    protected BakedGeoModel lastModel = null;

    protected DyeableGeoArmorRenderer(GeoModel<T> model) {
        super(model);
    }

    @Override
    public void preRender(class_4587 poseStack, T animatable, BakedGeoModel model, @Nullable class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(poseStack, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (!isReRender) {
            this.checkBoneDyeCache(model);
        }
    }

    @Override
    public void renderCubesOfBone(class_4587 poseStack, GeoBone bone, class_4588 buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.dyeableBones.contains(bone)) {
            Color color = this.getColorForBone(bone);
            red *= color.getRedFloat();
            green *= color.getGreenFloat();
            blue *= color.getBlueFloat();
            alpha *= color.getAlphaFloat();
        }
        super.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    protected abstract boolean isBoneDyeable(GeoBone var1);

    @NotNull
    protected abstract Color getColorForBone(GeoBone var1);

    protected void checkBoneDyeCache(BakedGeoModel model) {
        if (model != this.lastModel) {
            this.dyeableBones.clear();
            this.lastModel = model;
            this.collectDyeableBones(model.getTopLevelBones());
        }
    }

    protected void collectDyeableBones(Collection<GeoBone> bones) {
        for (GeoBone bone : bones) {
            if (this.isBoneDyeable(bone)) {
                this.dyeableBones.add(bone);
            }
            this.collectDyeableBones(bone.getChildBones());
        }
    }
}

