/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.internal.common.loading.json.typeadapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Type;
import java.util.Map;
import mod.azure.azurelibarmor.common.internal.common.util.JsonUtil;
import mod.azure.azurelibarmor.core.animation.Animation;
import mod.azure.azurelibarmor.core.keyframe.event.data.CustomInstructionKeyframeData;
import mod.azure.azurelibarmor.core.keyframe.event.data.ParticleKeyframeData;
import mod.azure.azurelibarmor.core.keyframe.event.data.SoundKeyframeData;
import net.minecraft.class_3518;

public class KeyFramesAdapter
implements JsonDeserializer<Animation.Keyframes> {
    private static SoundKeyframeData[] buildSoundFrameData(JsonObject rootObj) {
        JsonObject soundsObj = class_3518.method_15281((JsonObject)rootObj, (String)"sound_effects", (JsonObject)new JsonObject());
        SoundKeyframeData[] sounds = new SoundKeyframeData[soundsObj.size()];
        int index = 0;
        for (Map.Entry entry : soundsObj.entrySet()) {
            sounds[index] = new SoundKeyframeData(Double.parseDouble((String)entry.getKey()) * 20.0, class_3518.method_15265((JsonObject)((JsonElement)entry.getValue()).getAsJsonObject(), (String)"effect"));
            ++index;
        }
        return sounds;
    }

    private static ParticleKeyframeData[] buildParticleFrameData(JsonObject rootObj) {
        JsonObject particlesObj = class_3518.method_15281((JsonObject)rootObj, (String)"particle_effects", (JsonObject)new JsonObject());
        ParticleKeyframeData[] particles = new ParticleKeyframeData[particlesObj.size()];
        int index = 0;
        for (Map.Entry entry : particlesObj.entrySet()) {
            JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
            String effect = class_3518.method_15253((JsonObject)obj, (String)"effect", (String)"");
            String locator = class_3518.method_15253((JsonObject)obj, (String)"locator", (String)"");
            String script = class_3518.method_15253((JsonObject)obj, (String)"pre_effect_script", (String)"");
            particles[index] = new ParticleKeyframeData(Double.parseDouble((String)entry.getKey()) * 20.0, effect, locator, script);
            ++index;
        }
        return particles;
    }

    private static CustomInstructionKeyframeData[] buildCustomFrameData(JsonObject rootObj) {
        JsonObject customInstructionsObj = class_3518.method_15281((JsonObject)rootObj, (String)"timeline", (JsonObject)new JsonObject());
        CustomInstructionKeyframeData[] customInstructions = new CustomInstructionKeyframeData[customInstructionsObj.size()];
        int index = 0;
        for (Map.Entry entry : customInstructionsObj.entrySet()) {
            String instructions = "";
            Object v = entry.getValue();
            if (v instanceof JsonArray) {
                JsonArray array = (JsonArray)v;
                instructions = ((ObjectArrayList)JsonUtil.GEO_GSON.fromJson((JsonElement)array, ObjectArrayList.class)).toString();
            } else {
                v = entry.getValue();
                if (v instanceof JsonPrimitive) {
                    JsonPrimitive primitive = (JsonPrimitive)v;
                    instructions = primitive.getAsString();
                }
            }
            customInstructions[index] = new CustomInstructionKeyframeData(Double.parseDouble((String)entry.getKey()) * 20.0, instructions);
            ++index;
        }
        return customInstructions;
    }

    public Animation.Keyframes deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();
        SoundKeyframeData[] sounds = KeyFramesAdapter.buildSoundFrameData(obj);
        ParticleKeyframeData[] particles = KeyFramesAdapter.buildParticleFrameData(obj);
        CustomInstructionKeyframeData[] customInstructions = KeyFramesAdapter.buildCustomFrameData(obj);
        return new Animation.Keyframes(sounds, particles, customInstructions);
    }
}

