/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasonsextras.patchouli;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import io.github.lucaargolo.seasons.FabricSeasons;
import io.github.lucaargolo.seasonsextras.patchouli.PatchouliMultiblockCreator;
import io.github.lucaargolo.seasonsextras.patchouli.payload.SendBiomeMultiblocksPacket;
import io.github.lucaargolo.seasonsextras.patchouli.payload.SendMultiblocksPacket;
import io.github.lucaargolo.seasonsextras.patchouli.payload.SendValidBiomesPacket;
import io.github.lucaargolo.seasonsextras.utils.ModIdentifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2944;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class FabricSeasonsExtrasPatchouliCompat {
    private static final HashMap<class_2960, JsonObject> multiblockCache = new HashMap();

    public static void onInitialize() {
        PayloadTypeRegistry.playS2C().register(SendBiomeMultiblocksPacket.ID, SendBiomeMultiblocksPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(SendMultiblocksPacket.ID, SendMultiblocksPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(SendValidBiomesPacket.ID, SendValidBiomesPacket.CODEC);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> FabricSeasonsExtrasPatchouliCompat.sendValidBiomes(server, handler.field_14140));
    }

    public static void sendValidBiomes(MinecraftServer server, @Nullable class_3222 player) {
        boolean generateMultiblocks;
        boolean bl = generateMultiblocks = player == null;
        if (generateMultiblocks) {
            multiblockCache.clear();
        }
        server.method_3738().forEach(serverWorld -> {
            if (FabricSeasons.CONFIG.isValidInDimension(serverWorld.method_27983())) {
                HashSet<class_6880<class_1959>> validBiomes = new HashSet<class_6880<class_1959>>();
                serverWorld.method_14178().method_12129().method_12098().method_28443().forEach(entry -> entry.method_40230().ifPresent(key -> validBiomes.add((class_6880<class_1959>)entry)));
                SendValidBiomesPacket packet = new SendValidBiomesPacket((class_5321<class_1937>)serverWorld.method_27983(), validBiomes.stream().map(r -> ((class_5321)r.method_40230().get()).method_29177()).collect(Collectors.toSet()));
                if (player != null) {
                    ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
                } else {
                    server.method_3760().method_14571().forEach(p -> ServerPlayNetworking.send((class_3222)p, (class_8710)packet));
                }
                FabricSeasonsExtrasPatchouliCompat.sendBiomeMultiblocks(server, player, serverWorld, validBiomes);
            }
        });
        FabricSeasonsExtrasPatchouliCompat.sendMultiblocks(server, player);
    }

    private static void sendBiomeMultiblocks(MinecraftServer server, @Nullable class_3222 player, class_3218 serverWorld, Set<class_6880<class_1959>> validBiomes) {
        HashMap<class_2960, Set<class_2960>> biomeToMultiblocks = new HashMap<class_2960, Set<class_2960>>();
        validBiomes.forEach(entry -> {
            class_2960 biomeId = ((class_5321)entry.method_40230().get()).method_29177();
            List validFeatures = (List)((class_1959)entry.comp_349()).method_30970().method_30983().stream().flatMap(class_6885::method_40239).map(class_6880::comp_349).flatMap(class_6796::method_39643).filter(c -> c.comp_332() instanceof class_2944).collect(ImmutableList.toImmutableList());
            for (class_2975 cf : validFeatures) {
                class_2960 cfId = server.method_30611().method_30530(class_7924.field_41239).method_10221((Object)cf);
                if (cfId == null) continue;
                if (!multiblockCache.containsKey(cfId)) {
                    PatchouliMultiblockCreator creator = new PatchouliMultiblockCreator(serverWorld, class_2246.field_10219.method_9564(), class_2246.field_10479.method_9564(), new class_2338(-100, -100, -100), c -> cf.method_12862((class_5281)c.getFakeWorld(), serverWorld.method_14178().method_12129(), class_5819.method_43049((long)0L), new class_2338(100, 100, 100)));
                    Optional<JsonObject> optional = creator.getMultiblock(set -> {
                        boolean foundLeave = false;
                        boolean foundLog = false;
                        Iterator iterator = set.iterator();
                        while (!(!iterator.hasNext() || foundLeave && foundLog)) {
                            class_2680 state = (class_2680)iterator.next();
                            if (state.method_26164(class_3481.field_15503)) {
                                foundLeave = true;
                            }
                            if (!state.method_26164(class_3481.field_15475)) continue;
                            foundLog = true;
                        }
                        return foundLeave && foundLog;
                    });
                    optional.ifPresent(o -> {
                        multiblockCache.put(cfId, (JsonObject)o);
                        biomeToMultiblocks.computeIfAbsent(biomeId, b -> new HashSet()).add(cfId);
                    });
                    continue;
                }
                biomeToMultiblocks.computeIfAbsent(biomeId, b -> new HashSet()).add(cfId);
            }
            class_2960 empty = ModIdentifier.of("empty");
            if (multiblockCache.containsKey(empty)) {
                biomeToMultiblocks.computeIfAbsent(biomeId, b -> new HashSet<class_2960>(Collections.singleton(empty)));
            } else {
                PatchouliMultiblockCreator creator = new PatchouliMultiblockCreator(serverWorld, class_2246.field_10102.method_9564(), class_2246.field_10428.method_9564(), new class_2338(0, 0, 0), c -> {});
                JsonObject emptyMultiblock = creator.getMultiblock(set -> true).get();
                multiblockCache.put(empty, emptyMultiblock);
                biomeToMultiblocks.computeIfAbsent(biomeId, b -> new HashSet<class_2960>(Collections.singleton(empty)));
            }
        });
        SendBiomeMultiblocksPacket packet = new SendBiomeMultiblocksPacket((class_5321<class_1937>)serverWorld.method_27983(), biomeToMultiblocks);
        if (player != null) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
        } else {
            server.method_3760().method_14571().forEach(p -> ServerPlayNetworking.send((class_3222)p, (class_8710)packet));
        }
    }

    private static void sendMultiblocks(MinecraftServer server, @Nullable class_3222 player) {
        SendMultiblocksPacket packet = new SendMultiblocksPacket(multiblockCache);
        if (player != null) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
        } else {
            server.method_3760().method_14571().forEach(p -> ServerPlayNetworking.send((class_3222)p, (class_8710)packet));
        }
    }
}

