/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasonsextras.patchouli;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lucaargolo.seasonsextras.patchouli.utils.FakeStructureWorldAccess;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_5819;

public class PatchouliMultiblockCreator {
    private static final char[] VALID_CHARS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private final FakeStructureWorldAccess fakeWorld;
    private final HashMap<class_2338, class_2680> testingMap;
    private final class_2680 ground;
    private final class_2680 decoration;
    private final class_2338 offset;
    private final Generator generate;

    public PatchouliMultiblockCreator(class_3218 serverWorld, class_2680 ground, class_2680 decoration, class_2338 offset, Generator generate) {
        this.fakeWorld = new FakeStructureWorldAccess(serverWorld, this);
        this.testingMap = new HashMap();
        this.ground = ground;
        this.decoration = decoration;
        this.offset = offset;
        this.generate = generate;
    }

    public void setBlockState(class_2338 pos, class_2680 state) {
        this.testingMap.put(pos.method_10081((class_2382)this.offset), state);
    }

    public Optional<class_2680> getBlockState(class_2338 pos) {
        class_2338 off = pos.method_10081((class_2382)this.offset);
        if (this.testingMap.containsKey(off)) {
            return Optional.of(this.testingMap.get(off));
        }
        return Optional.empty();
    }

    public Optional<JsonObject> getMultiblock(Predicate<Set<class_2680>> valid) {
        class_3341 box;
        try {
            this.generate.generate(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        AtomicInteger index = new AtomicInteger();
        HashMap<class_2680, Character> mappings = new HashMap<class_2680, Character>();
        HashMap pattern = new HashMap();
        Optional optional = class_3341.method_35411(this.testingMap.keySet());
        if (optional.isPresent()) {
            box = (class_3341)optional.get();
            this.testingMap.forEach((pos, state) -> {
                Character mapping;
                if (!mappings.containsKey(state) && index.getAndIncrement() < VALID_CHARS.length) {
                    mappings.put((class_2680)state, Character.valueOf(VALID_CHARS[index.get() - 1]));
                }
                if ((mapping = (Character)mappings.get(state)) != null) {
                    int x = pos.method_10263() + (box.method_35415() <= 0 ? -box.method_35415() : 0);
                    int y = pos.method_10264() + (box.method_35416() <= 0 ? -box.method_35416() : 0);
                    int z = pos.method_10260() + (box.method_35417() <= 0 ? -box.method_35417() : 0);
                    pattern.computeIfAbsent(y, i -> new HashMap()).computeIfAbsent(x, i -> new HashMap()).put(z, mapping);
                }
            });
        } else {
            box = new class_3341(0, 0, 0, 4, 6, 4);
        }
        String[][] realPattern = new String[box.method_14660()][box.method_35414()];
        class_5819 random = class_5819.method_43049((long)1337L);
        class_2680 centerState = class_2246.field_10124.method_9564();
        boolean foundCenter = false;
        for (int i = 0; i < box.method_14660(); ++i) {
            int y = box.method_14660() - 1 - i;
            for (int x = 0; x < box.method_35414(); ++x) {
                realPattern[y][x] = "";
                for (int z = 0; z < box.method_14663(); ++z) {
                    char d = ' ';
                    if (x != 0 && x != box.method_35414() - 1 && z != 0 && z != box.method_14663() - 1) {
                        if (y == box.method_14660() - 1) {
                            d = '1';
                        } else if (y == box.method_14660() - 2 && random.method_43048(4) == 2) {
                            d = '2';
                        }
                    }
                    char f = pattern.getOrDefault(i, new HashMap()).getOrDefault(x, new HashMap()).getOrDefault(z, Character.valueOf(d)).charValue();
                    if (!foundCenter && box.method_35414() / 2 == x && box.method_14660() / 2 == i && box.method_14663() / 2 == z) {
                        foundCenter = true;
                        String[] stringArray = realPattern[y];
                        int n = x;
                        stringArray[n] = stringArray[n] + "0";
                        if (f == d) continue;
                        boolean foundState = false;
                        Iterator iterator = mappings.entrySet().iterator();
                        while (iterator.hasNext() && !foundState) {
                            Map.Entry entry = iterator.next();
                            if (((Character)entry.getValue()).charValue() != f) continue;
                            centerState = (class_2680)entry.getKey();
                            foundState = true;
                        }
                        continue;
                    }
                    String[] stringArray = realPattern[y];
                    int n = x;
                    stringArray[n] = stringArray[n] + f;
                }
            }
        }
        JsonObject multiblock = new JsonObject();
        JsonObject m = new JsonObject();
        mappings.forEach((s, c) -> m.addProperty(c.toString(), PatchouliMultiblockCreator.stateToString(s)));
        m.addProperty("0", PatchouliMultiblockCreator.stateToString(centerState));
        m.addProperty("1", PatchouliMultiblockCreator.stateToString(this.ground));
        m.addProperty("2", PatchouliMultiblockCreator.stateToString(this.decoration));
        multiblock.add("mapping", (JsonElement)m);
        multiblock.add("pattern", new Gson().toJsonTree((Object)realPattern));
        if (valid.test(new HashSet<class_2680>(this.testingMap.values()))) {
            return Optional.of(multiblock);
        }
        return Optional.empty();
    }

    public FakeStructureWorldAccess getFakeWorld() {
        return this.fakeWorld;
    }

    public class_2680 getGround() {
        return this.ground;
    }

    private static String stateToString(class_2680 state) {
        return state.toString().replace("Block{", "").replace("}", "");
    }

    @FunctionalInterface
    public static interface Generator {
        public void generate(PatchouliMultiblockCreator var1);
    }
}

