/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.a_good_place.pack;

import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import nl.enjarai.a_good_place.AGoodPlace;
import nl.enjarai.a_good_place.pack.StrOpt;
import nl.enjarai.a_good_place.pack.state_tests.BlockStatePredicate;

public record AnimationParameters(LazyList<?, BlockStatePredicate> predicates, int priority, int duration, float scaleStart, float scaleCurve, class_243 translation, float translationCurve, class_243 rotation, class_243 pivot, float rotationCurve, float heightStart, float heightCurve, Optional<class_6880<class_3414>> sound) {
    private static final Codec<Float> FLOAT_CODEC = AnimationParameters.floatRangeExclusive(-1.0f, 1.0f);
    private static final Codec<Float> DEG_TO_RAD_CODEC = Codec.floatRange((float)-180.0f, (float)180.0f).xmap(d -> Float.valueOf((float)Math.toRadians(d.floatValue())), r -> Float.valueOf((float)Math.toDegrees(r.floatValue())));
    public static final Codec<class_243> ANGLE_VEC_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DEG_TO_RAD_CODEC.fieldOf("x").forGetter(o -> Float.valueOf((float)o.method_10216())), (App)DEG_TO_RAD_CODEC.fieldOf("y").forGetter(o -> Float.valueOf((float)o.method_10214())), (App)DEG_TO_RAD_CODEC.fieldOf("z").forGetter(o -> Float.valueOf((float)o.method_10215()))).apply((Applicative)instance, class_243::new));
    public static final Codec<class_243> VEC_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("x").forGetter(class_243::method_10216), (App)Codec.DOUBLE.fieldOf("y").forGetter(class_243::method_10214), (App)Codec.DOUBLE.fieldOf("z").forGetter(class_243::method_10215)).apply((Applicative)instance, class_243::new));
    public static final Codec<AnimationParameters> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StrOpt.of(LazyList.codec(BlockStatePredicate.CODEC), "predicates", new LazyList(null, null)).forGetter(AnimationParameters::predicates), (App)StrOpt.of(Codec.INT, "priority", 0).forGetter(AnimationParameters::priority), (App)StrOpt.of(Codec.intRange((int)0, (int)300), "duration", 4).forGetter(AnimationParameters::duration), (App)StrOpt.of(Codec.floatRange((float)0.0f, (float)10.0f), "scale", Float.valueOf(1.0f)).forGetter(AnimationParameters::scaleStart), (App)StrOpt.of(FLOAT_CODEC, "scale_curve", Float.valueOf(0.5f)).forGetter(AnimationParameters::scaleCurve), (App)StrOpt.of(VEC_CODEC, "translation", class_243.field_1353).forGetter(AnimationParameters::translation), (App)StrOpt.of(FLOAT_CODEC, "translation_curve", Float.valueOf(0.5f)).forGetter(AnimationParameters::translationCurve), (App)StrOpt.of(ANGLE_VEC_CODEC, "rotation", class_243.field_1353).forGetter(AnimationParameters::rotation), (App)StrOpt.of(VEC_CODEC, "rotation_pivot", class_243.field_1353).forGetter(AnimationParameters::pivot), (App)StrOpt.of(FLOAT_CODEC, "rotation_curve", Float.valueOf(0.5f)).forGetter(AnimationParameters::rotationCurve), (App)StrOpt.of(Codec.floatRange((float)0.0f, (float)10.0f), "height", Float.valueOf(1.0f)).forGetter(AnimationParameters::heightStart), (App)StrOpt.of(FLOAT_CODEC, "height_curve", Float.valueOf(0.5f)).forGetter(AnimationParameters::heightCurve), (App)StrOpt.of(class_3414.field_41699, "sound").forGetter(AnimationParameters::sound)).apply((Applicative)instance, AnimationParameters::new));

    public boolean matches(class_2680 blockState, class_2338 pos, class_1937 level) {
        List<BlockStatePredicate> pred = this.predicates.get();
        if (AGoodPlace.isHardcodedBlackList(blockState)) {
            return false;
        }
        if (pred.isEmpty()) {
            return true;
        }
        return pred.stream().allMatch(p -> p.test(blockState, pos, level));
    }

    static Codec<Float> floatRangeExclusive(float minExclusive, float maxExclusive) {
        Function<Float, DataResult<Float>> checker = AnimationParameters.checkRange(Float.valueOf(minExclusive), Float.valueOf(maxExclusive));
        return Codec.FLOAT.flatXmap(checker, checker);
    }

    static <N extends Number> Function<N, DataResult<N>> checkRange(N minExclusive, N maxExclusive) {
        return value -> {
            if (((Comparable)((Object)value)).compareTo(minExclusive) > 0 && ((Comparable)((Object)value)).compareTo(maxExclusive) < 0) {
                return DataResult.success((Object)value);
            }
            return DataResult.error(() -> "Value " + String.valueOf(value) + " outside of range (" + String.valueOf(minExclusive) + ":" + String.valueOf(maxExclusive) + ")", (Object)value);
        };
    }

    protected static class LazyList<T, O> {
        private final Codec<O> codec;
        private final Dynamic<T> toDecode;
        private List<O> objects = List.of();

        public LazyList(Dynamic<T> toDecode, Codec<O> codec) {
            this.toDecode = toDecode;
            this.codec = codec;
        }

        public static <H> Codec<LazyList<?, H>> codec(Codec<H> codec) {
            return Codec.PASSTHROUGH.xmap(o -> new LazyList(o, codec), o -> o.toDecode);
        }

        public List<O> get() {
            return this.objects;
        }

        protected void lazyInit(class_5455 registryAccess) {
            this.objects = List.of();
            DataResult res = this.codec.listOf().decode((DynamicOps)class_6903.method_46632((DynamicOps)this.toDecode.getOps(), (class_7225.class_7874)registryAccess), this.toDecode.getValue());
            try {
                this.objects = (List)((Pair)res.getOrThrow(s -> new JsonParseException("Could not decode block list for placement animation - error: " + s))).getFirst();
            }
            catch (Exception e) {
                AGoodPlace.LOGGER.error("Could not decode block list for placement animation", (Throwable)e);
            }
        }
    }
}

