/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.a_good_place.pack;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import nl.enjarai.a_good_place.AGoodPlace;
import nl.enjarai.a_good_place.pack.AnimationParameters;
import org.jetbrains.annotations.Nullable;

public class AnimationsManager
extends class_4309 {
    private static final List<AnimationParameters> ANIMATIONS = new ArrayList<AnimationParameters>();

    public AnimationsManager() {
        super(new Gson(), "placement_animations");
    }

    protected void apply(Map<class_2960, JsonElement> jsons, class_3300 resourceManager, class_3695 profiler) {
        ANIMATIONS.clear();
        for (Map.Entry<class_2960, JsonElement> j : jsons.entrySet()) {
            JsonElement json = j.getValue();
            class_2960 id = j.getKey();
            AnimationParameters effect = (AnimationParameters)((Pair)AnimationParameters.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(errorMsg -> new JsonParseException("Could not decode Block Placement Animation with json id " + String.valueOf(id) + " - error: " + errorMsg + " - json: " + String.valueOf(j)))).getFirst();
            ANIMATIONS.add(effect);
        }
        ANIMATIONS.sort((a, b) -> Integer.compare(b.priority(), a.priority()));
        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            AnimationsManager.populateTags(level.method_30349());
        }
    }

    @Nullable
    public static AnimationParameters getAnimation(class_2680 blockState, class_2338 pos, class_1937 level) {
        if (AGoodPlace.IS_DEV) {
            // empty if block
        }
        for (AnimationParameters animation : ANIMATIONS) {
            if (!animation.matches(blockState, pos, level)) continue;
            return animation;
        }
        return null;
    }

    public static void populateTags(class_5455 registryAccess) {
        for (AnimationParameters v : ANIMATIONS) {
            v.predicates().lazyInit(registryAccess);
        }
    }
}

