/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.a_good_place.particles;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_703;
import nl.enjarai.a_good_place.AGoodPlace;
import nl.enjarai.a_good_place.pack.AnimationParameters;
import nl.enjarai.a_good_place.pack.AnimationsManager;
import nl.enjarai.a_good_place.particles.ConfiguredPlacingParticle;
import nl.enjarai.a_good_place.particles.PlacingBlockParticle;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

public class BlocksParticlesManager {
    protected static final Map<class_2338, PlacingBlockParticle> PARTICLES = new HashMap<class_2338, PlacingBlockParticle>();
    private static Set<class_2338> hiddenBlocks = Set.of();

    public static void addParticle(class_2680 state, class_2338 pos, class_638 level, class_2350 face, class_1657 player, class_1268 hand) {
        class_4184 camera;
        AnimationParameters param = AnimationsManager.getAnimation(state, pos, (class_1937)level);
        if (param != null && (camera = class_310.method_1551().field_1773.method_19418()).method_19326().method_1025(pos.method_46558()) <= 1024.0) {
            ConfiguredPlacingParticle p = new ConfiguredPlacingParticle(level, pos, face, player, hand, param);
            PlacingBlockParticle old = PARTICLES.put(pos, p);
            if (old != null) {
                old.method_3085();
            }
            BlocksParticlesManager.hideBlock(pos);
            if (AGoodPlace.RENDER_AS_VANILLA_PARTICLES) {
                class_310.method_1551().field_1713.method_3058((class_703)p);
            }
        }
    }

    public static void hideBlock(class_2338 pos) {
        HashSet<class_2338> list = new HashSet<class_2338>(hiddenBlocks);
        boolean success = list.add(pos);
        if (success) {
            hiddenBlocks = Set.of(list.toArray(new class_2338[0]));
        }
    }

    public static boolean isBlockHidden(class_2338 pos) {
        return hiddenBlocks.contains(pos);
    }

    public static void unHideBlock(class_2338 pos) {
        ArrayList<class_2338> list = new ArrayList<class_2338>(hiddenBlocks);
        boolean success = list.remove(pos);
        if (success) {
            hiddenBlocks = Set.of(list.toArray(new class_2338[0]));
            BlocksParticlesManager.markBlockForRender(pos);
        }
    }

    private static void markBlockForRender(class_2338 pos) {
        class_638 level = class_310.method_1551().field_1687;
        class_2680 state = level.method_8320(pos);
        level.method_8413(pos, state, state, 2);
    }

    public static void tickParticles(class_638 level) {
        if (AGoodPlace.RENDER_AS_VANILLA_PARTICLES) {
            return;
        }
        Iterator<Map.Entry<class_2338, PlacingBlockParticle>> iterator = PARTICLES.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<class_2338, PlacingBlockParticle> entry = iterator.next();
            PlacingBlockParticle p = entry.getValue();
            p.method_3070();
            if (p.method_3086()) continue;
            iterator.remove();
        }
    }

    public static void renderParticles(class_4587 poseStack, float tickDelta) {
        if (AGoodPlace.RENDER_AS_VANILLA_PARTICLES || PARTICLES.isEmpty()) {
            return;
        }
        poseStack.method_22903();
        class_310 mc = class_310.method_1551();
        class_4184 camera = mc.field_1773.method_19418();
        class_4597.class_4598 bufferSource = mc.method_22940().method_23000();
        RenderSystem.enableDepthTest();
        Matrix4fStack poseStack2 = RenderSystem.getModelViewStack();
        poseStack2.pushMatrix();
        poseStack2.mul((Matrix4fc)poseStack.method_23760().method_23761());
        RenderSystem.applyModelViewMatrix();
        for (PlacingBlockParticle p : PARTICLES.values()) {
            p.method_3074(null, camera, tickDelta);
        }
        bufferSource.method_22993();
        poseStack2.popMatrix();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        poseStack.method_22909();
    }

    public static void modifyTilePosition(class_2338 pos, class_4587 pose, float partialTicks) {
        PlacingBlockParticle particle = PARTICLES.get(pos);
        if (particle != null) {
            particle.applyAnimation(pose, partialTicks);
        }
    }

    public static void clear() {
        PARTICLES.clear();
        hiddenBlocks = Set.of();
    }
}

