/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.a_good_place.particles;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import nl.enjarai.a_good_place.pack.AnimationParameters;
import nl.enjarai.a_good_place.particles.PlacingBlockParticle;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ConfiguredPlacingParticle
extends PlacingBlockParticle {
    private final AnimationParameters params;
    private final float yAngle;
    private final class_241 slideStart;
    private final class_243 rotStart;

    public ConfiguredPlacingParticle(class_638 level, class_2338 blockPos, class_2350 face, class_1657 placer, class_1268 hand, AnimationParameters settings) {
        super(level, blockPos, face);
        int rightHandMul;
        settings.sound().ifPresent(sound -> level.method_45446(blockPos, (class_3414)sound.comp_349(), class_3419.field_15248, 1.0f, 1.0f, false));
        this.params = settings;
        this.field_3847 = this.params.duration();
        this.extraLifeTicks = 2;
        Vector3f playerHorizLook = placer.method_5720().method_46409().mul(-1.0f, 0.0f, -1.0f).normalize();
        int n = rightHandMul = placer.method_6068() == class_1306.field_6183 ? 1 : -1;
        if (hand != class_1268.field_5808) {
            rightHandMul *= -1;
        }
        Vector3f xVec = new Vector3f(playerHorizLook.z, 0.0f, -playerHorizLook.x).mul((float)rightHandMul);
        Matrix3f changeOfBasis = new Matrix3f((Vector3fc)xVec, (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), (Vector3fc)playerHorizLook);
        Vector3f tr = this.params.translation().method_46409();
        float slidePow = tr.length();
        if (placer.method_36455() > 0.0f) {
            tr.mul(1.0f, 1.0f, 1.0f);
        } else {
            tr.mul(1.0f, -1.0f, 1.0f);
        }
        Vector3f slideDir = tr.mul((Matrix3fc)changeOfBasis);
        slideDir = this.adjustDirectionBasedOnNeighbors(level, placer, slideDir);
        class_243 animationDirection = new class_243(slideDir.normalize());
        this.yAngle = (float)Math.atan2(slideDir.x(), slideDir.z());
        class_243 temp = animationDirection.method_1024(-this.yAngle);
        this.slideStart = new class_241((float)temp.field_1350, (float)temp.field_1351).method_35582(slidePow);
        this.rotStart = this.params.rotation();
    }

    @Override
    public void applyAnimation(class_4587 poseStack, float time, float partialTicks) {
        poseStack.method_22904(0.5, 0.5, 0.5);
        class_243 offset = this.blockState.method_26226((class_1922)this.field_3851, this.pos);
        poseStack.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
        poseStack.method_22907(class_7833.field_40716.rotation(this.yAngle));
        float progress = this.fancyExponent(time, this.params.translationCurve());
        class_241 translate = this.slideStart.method_35582(1.0f - progress);
        poseStack.method_46416(0.0f, translate.field_1342, translate.field_1343);
        progress = this.fancyExponent(time, this.params.rotationCurve());
        class_243 rotation = this.rotStart.method_1021((double)(1.0f - progress));
        class_243 rotationPivot = this.params.pivot();
        if (this.slideStart.field_1342 < 0.0f) {
            rotationPivot = rotationPivot.method_18805(1.0, -1.0, 1.0);
            rotation = rotation.method_18805(-1.0, 1.0, -1.0);
        }
        poseStack.method_22904(rotationPivot.field_1352, rotationPivot.field_1351, rotationPivot.field_1350);
        poseStack.method_22907(class_7833.field_40716.rotation((float)rotation.field_1351));
        poseStack.method_22907(class_7833.field_40718.rotation((float)rotation.field_1350));
        poseStack.method_22907(class_7833.field_40714.rotation((float)rotation.field_1352));
        poseStack.method_22904(-rotationPivot.field_1352, -rotationPivot.field_1351, -rotationPivot.field_1350);
        progress = this.fancyExponent(time, this.params.scaleCurve());
        float scaleStart = this.params.scaleStart();
        float scale = scaleStart + (0.999f - scaleStart) * progress;
        poseStack.method_22905(scale, scale, scale);
        progress = this.fancyExponent(time, this.params.heightCurve());
        float heightStart = this.params.heightStart();
        float height = heightStart + (1.0f - heightStart) * progress;
        poseStack.method_22904(0.0, -0.5, 0.0);
        poseStack.method_22905(1.0f, height, 1.0f);
        poseStack.method_46416(0.0f, 0.5f, 0.0f);
        poseStack.method_22907(class_7833.field_40716.rotation(-this.yAngle));
        poseStack.method_22904(-offset.field_1352, -offset.field_1351, -offset.field_1350);
        poseStack.method_22904(-0.5, -0.5, -0.5);
    }

    private float parabula(float t, float exp, float startSlope) {
        float a = 1.0f - startSlope;
        return a * (float)Math.pow(t, exp) + (1.0f - a) * t;
    }

    private float exponent(float t, float base) {
        return (float)((double)base * Math.pow(1.0f / base + 1.0f, t) - (double)base);
    }

    private float fancyExponent(float t, float curve) {
        if (curve == 0.0f) {
            return t;
        }
        float base = curve > 0.0f ? (float)(-Math.log(curve)) : (float)(Math.log(-curve) - 1.0);
        return this.exponent(t, base);
    }

    private float addSomeRandom(float t) {
        return t;
    }

    public static List<class_2350> getAffectedDirections(float x, float y, float z) {
        ArrayList<class_2350> list = new ArrayList<class_2350>();
        if (z > 0.0f) {
            list.add(class_2350.field_11035);
        }
        if (z < 0.0f) {
            list.add(class_2350.field_11043);
        }
        if (x > 0.0f) {
            list.add(class_2350.field_11034);
        }
        if (x < 0.0f) {
            list.add(class_2350.field_11039);
        }
        if (y > 0.0f) {
            list.add(class_2350.field_11036);
        }
        if (y < 0.0f) {
            list.add(class_2350.field_11033);
        }
        return list;
    }

    @NotNull
    private Vector3f adjustDirectionBasedOnNeighbors(class_638 world, class_1657 placer, Vector3f slideDir) {
        List<class_2350> affectedDir = ConfiguredPlacingParticle.getAffectedDirections(slideDir.x(), slideDir.y(), slideDir.z());
        ArrayList<class_2350> emptyDirections = new ArrayList<class_2350>();
        for (class_2350 d : class_2350.values()) {
            class_2338 neighbor = this.pos.method_10093(d);
            class_2680 state = world.method_8320(neighbor);
            class_265 collision = state.method_26220((class_1922)world, neighbor);
            if (collision.method_1110()) {
                emptyDirections.add(d);
                continue;
            }
            if (d.method_10171() == class_2350.class_2352.field_11056) {
                if (!(collision.method_1091(d.method_10166()) > 0.25)) continue;
                emptyDirections.add(d);
                continue;
            }
            if (!(collision.method_1105(d.method_10166()) < 0.75)) continue;
            emptyDirections.add(d);
        }
        for (class_2350 d : affectedDir) {
            if (emptyDirections.contains(d)) continue;
            slideDir.sub((Vector3fc)d.method_23955().mul((Vector3fc)d.method_23955()).mul((Vector3fc)slideDir));
        }
        if (slideDir.length() == 0.0f && !emptyDirections.isEmpty()) {
            List<class_2350> nearest = List.of(class_2350.method_10159((class_1297)placer));
            emptyDirections.sort(Comparator.comparingInt(nearest::indexOf));
            slideDir = ((class_2350)emptyDirections.get(0)).method_23955();
        }
        return slideDir;
    }
}

