/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen;

import com.google.gson.JsonElement;
import com.klikli_dev.modonomicon.api.datagen.BookSubProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookCommandModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookModel;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import org.jetbrains.annotations.NotNull;

public class BookProvider
implements class_2405 {
    protected final String modId;
    protected final CompletableFuture<class_7225.class_7874> registries;
    protected final class_7784 packOutput;
    protected final Map<class_2960, BookModel> bookModels;
    protected final List<BookSubProvider> subProviders;

    public BookProvider(class_7784 packOutput, CompletableFuture<class_7225.class_7874> registries, String modId, List<BookSubProvider> subProviders) {
        this.packOutput = packOutput;
        this.registries = registries;
        this.modId = modId;
        this.subProviders = subProviders;
        this.bookModels = new Object2ObjectOpenHashMap();
    }

    public String modId() {
        return this.modId;
    }

    protected Path getPath(Path dataFolder, BookModel bookModel) {
        class_2960 id = bookModel.getId();
        return dataFolder.resolve(id.method_12836()).resolve("modonomicon/books").resolve(id.method_12832() + "/book.json");
    }

    protected Path getPath(Path dataFolder, BookCategoryModel bookCategoryModel) {
        class_2960 id = bookCategoryModel.getId();
        return dataFolder.resolve(id.method_12836()).resolve("modonomicon/books").resolve(bookCategoryModel.getBook().getId().method_12832()).resolve("categories").resolve(id.method_12832() + ".json");
    }

    protected Path getPath(Path dataFolder, BookCommandModel bookCommandModel) {
        class_2960 id = bookCommandModel.getId();
        return dataFolder.resolve(id.method_12836()).resolve("modonomicon/books").resolve(bookCommandModel.getBook().getId().method_12832()).resolve("commands").resolve(id.method_12832() + ".json");
    }

    protected Path getPath(Path dataFolder, BookEntryModel bookEntryModel) {
        class_2960 id = bookEntryModel.getId();
        return dataFolder.resolve(id.method_12836()).resolve("modonomicon/books").resolve(bookEntryModel.getCategory().getBook().getId().method_12832()).resolve("entries").resolve(id.method_12832() + ".json");
    }

    @NotNull
    public CompletableFuture<?> method_10319(@NotNull class_7403 cache) {
        return this.registries.thenCompose(registries -> {
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
            Path dataFolder = this.packOutput.method_45972(class_7784.class_7490.field_39367);
            this.subProviders.forEach(subProvider -> subProvider.generate(this.bookModels::put, (class_7225.class_7874)registries));
            for (BookModel bookModel : this.bookModels.values()) {
                Path bookPath = this.getPath(dataFolder, bookModel);
                futures.add(class_2405.method_10320((class_7403)cache, (JsonElement)bookModel.toJson((class_7225.class_7874)registries), (Path)bookPath));
                for (BookCategoryModel bookCategoryModel : bookModel.getCategories()) {
                    Path bookCategoryPath = this.getPath(dataFolder, bookCategoryModel);
                    futures.add(class_2405.method_10320((class_7403)cache, (JsonElement)bookCategoryModel.toJson((class_7225.class_7874)registries), (Path)bookCategoryPath));
                    for (BookEntryModel bookEntryModel : bookCategoryModel.getEntries()) {
                        Path bookEntryPath = this.getPath(dataFolder, bookEntryModel);
                        futures.add(class_2405.method_10320((class_7403)cache, (JsonElement)bookEntryModel.toJson((class_7225.class_7874)registries), (Path)bookEntryPath));
                    }
                }
                for (BookCommandModel bookCommandModel : bookModel.getCommands()) {
                    Path bookCommandPath = this.getPath(dataFolder, bookCommandModel);
                    futures.add(class_2405.method_10320((class_7403)cache, (JsonElement)bookCommandModel.toJson((class_7225.class_7874)registries), (Path)bookCommandPath));
                }
            }
            return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        });
    }

    @NotNull
    public String method_10321() {
        return "Books: " + this.modId();
    }

    protected BookModel add(BookModel bookModel) {
        if (this.bookModels.containsKey(bookModel.getId())) {
            throw new IllegalStateException("Duplicate book " + String.valueOf(bookModel.getId()));
        }
        this.bookModels.put(bookModel.getId(), bookModel);
        return bookModel;
    }
}

