/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen;

import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconProviderBase;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookPageModel;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_241;
import net.minecraft.class_7225;

public abstract class EntryProvider
extends ModonomiconProviderBase {
    protected final CategoryProviderBase parent;
    protected BookEntryModel entry;

    public EntryProvider(CategoryProviderBase parent) {
        super(parent.modId(), parent.lang(), parent.langsAsMapOfBiConsumers(), parent.context(), parent.condition());
        this.parent = parent;
        this.entry = null;
    }

    @Override
    protected class_7225.class_7874 registries() {
        return this.parent.registries();
    }

    @Override
    protected Map<String, String> macros() {
        return Stream.concat(super.macros().entrySet().stream(), this.parent.macros().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
    }

    protected void pageTitle(String title) {
        this.add(this.context().pageTitle(), title);
    }

    protected void pageText(String text) {
        this.add(this.context().pageText(), text);
    }

    protected void pageText(String text, Object ... args) {
        this.add(this.context().pageText(), text, args);
    }

    protected <T extends BookPageModel<?>> T page(T model) {
        return this.add(model);
    }

    protected <T extends BookPageModel<?>> T page(String page, Supplier<T> modelSupplier) {
        this.context().page(page);
        BookPageModel model = (BookPageModel)modelSupplier.get();
        return (T)this.add(model);
    }

    protected <T extends BookPageModel<?>> T add(T page) {
        this.entry.withPage(page);
        return page;
    }

    protected List<BookPageModel<?>> add(List<BookPageModel<?>> pages) {
        this.entry.withPages(pages);
        return pages;
    }

    public BookEntryModel generate() {
        return this.generate(class_241.field_1340);
    }

    public BookEntryModel generate(String location) {
        if (location.length() == 1) {
            return this.generate(location.charAt(0));
        }
        return this.generate(this.parent.entryMap().get(location));
    }

    public BookEntryModel generate(char location) {
        return this.generate(this.parent.entryMap().get(Character.valueOf(location)));
    }

    public BookEntryModel generate(class_241 location) {
        this.context().entry(this.entryId());
        BookEntryModel entry = BookEntryModel.create(this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), this.context().entryName()).withDescription(this.context().entryDescription());
        this.add(this.context().entryName(), this.entryName());
        this.add(this.context().entryDescription(), this.entryDescription());
        entry.withIcon(this.entryIcon());
        entry.withLocation(location);
        entry.withEntryBackground(this.entryBackground());
        this.entry = this.additionalSetup(entry);
        this.generatePages();
        this.parent.add(this.entry);
        return this.entry;
    }

    protected abstract void generatePages();

    protected BookEntryModel additionalSetup(BookEntryModel entry) {
        return entry;
    }

    protected abstract String entryName();

    protected abstract String entryDescription();

    protected abstract Pair<Integer, Integer> entryBackground();

    protected abstract BookIconModel entryIcon();

    protected abstract String entryId();
}

