/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen;

import com.klikli_dev.modonomicon.api.datagen.CategoryEntryMap;
import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconProviderBase;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryParentModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookPageModel;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1935;
import net.minecraft.class_2960;

public abstract class LegacyCategoryProvider
extends CategoryProviderBase {
    protected final Map<String, List<BookPageModel<?>>> cachedPages = new Object2ObjectOpenHashMap();
    protected CategoryEntryMap entryMap = new CategoryEntryMap();
    protected BookCategoryModel category = null;
    protected int currentSortIndex = 0;
    protected String categoryId;

    public LegacyCategoryProvider(ModonomiconProviderBase parent, String categoryId) {
        super(parent, parent.modId(), parent.lang(), parent.langsAsMapOfBiConsumers(), parent.context(), parent.condition());
        this.categoryId = categoryId;
    }

    @Override
    public String categoryId() {
        return this.categoryId;
    }

    @Override
    public CategoryEntryMap entryMap() {
        return this.entryMap;
    }

    @Override
    protected Map<String, String> macros() {
        return Stream.concat(super.macros().entrySet().stream(), this.parent.macros().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
    }

    protected BookEntryModel entry(String location, class_2960 texture) {
        return this.entry(location).withIcon(texture);
    }

    protected BookEntryModel entry(String location, class_2960 texture, int width, int height) {
        return this.entry(location).withIcon(texture, width, height);
    }

    protected BookEntryModel entry(String location, class_1935 icon) {
        return this.entry(location).withIcon(icon);
    }

    protected BookEntryModel entry(char location, class_2960 texture) {
        return this.entry(location).withIcon(texture);
    }

    protected BookEntryModel entry(char location, class_2960 texture, int width, int height) {
        return this.entry(location).withIcon(texture, width, height);
    }

    protected BookEntryModel entry(char location, class_1935 icon) {
        return this.entry(location).withIcon(icon);
    }

    protected BookEntryModel entry(char location) {
        return this.entry().withLocation(this.entryMap().get(Character.valueOf(location)));
    }

    protected BookEntryModel entry(String location) {
        return this.entry().withLocation(this.entryMap().get(location));
    }

    protected BookEntryModel entry() {
        BookEntryModel entry = BookEntryModel.create(this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), this.context().entryName()).withDescription(this.context().entryDescription());
        if (this.cachedPages.containsKey(this.context().entry())) {
            entry.withPages(this.cachedPages.get(this.context().entry()));
            this.cachedPages.remove(this.context().entry());
        }
        return entry;
    }

    protected <T extends BookPageModel<?>> T page(T model) {
        this.cachedPages.computeIfAbsent(this.context().entry(), k -> new ArrayList()).add(model);
        return model;
    }

    protected <T extends BookPageModel<?>> T page(String page, Supplier<T> modelSupplier) {
        this.context().page(page);
        BookPageModel model = (BookPageModel)modelSupplier.get();
        this.cachedPages.computeIfAbsent(this.context().entry(), k -> new ArrayList()).add(model);
        return (T)model;
    }

    protected BookEntryParentModel parent(BookEntryModel parentEntry) {
        return BookEntryParentModel.create(parentEntry.getId());
    }

    @Override
    public BookEntryModel add(BookEntryModel entry) {
        if (entry.getSortNumber() == -1) {
            entry.withSortNumber(this.currentSortIndex++);
        }
        this.category.withEntry(entry);
        return entry;
    }

    @Override
    public List<BookEntryModel> add(List<BookEntryModel> entries) {
        for (BookEntryModel entry : entries) {
            if (entry.getSortNumber() != -1) continue;
            entry.withSortNumber(this.currentSortIndex++);
        }
        this.category.withEntries(entries);
        return entries;
    }

    public BookCategoryModel generate() {
        this.context().category(this.categoryId);
        this.entryMap().setMap(this.generateEntryMap());
        this.category = this.generateCategory();
        this.generateEntries();
        return this.category;
    }

    protected abstract String[] generateEntryMap();

    protected abstract void generateEntries();

    protected abstract BookCategoryModel generateCategory();
}

