/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;

public abstract class MultiblockProvider
implements class_2405 {
    protected final class_7784.class_7489 pathProvider;
    protected String modid;
    protected BiConsumer<class_2960, JsonObject> multiblockConsumer;

    public MultiblockProvider(class_7784 packOutput, String modid) {
        this.pathProvider = packOutput.method_45973(class_7784.class_7490.field_39367, "modonomicon/multiblocks");
        this.modid = modid;
    }

    protected class_2960 modLoc(String name) {
        return class_2960.method_60655((String)this.modid, (String)name);
    }

    public CompletableFuture<?> method_10319(class_7403 pOutput) {
        HashSet set = Sets.newHashSet();
        ArrayList futures = new ArrayList();
        this.multiblockConsumer = (id, recipe) -> {
            if (!set.add(id)) {
                throw new IllegalStateException("Duplicate multiblock " + String.valueOf(id));
            }
            futures.add(class_2405.method_10320((class_7403)pOutput, (JsonElement)recipe, (Path)this.pathProvider.method_44107(id)));
        };
        this.buildMultiblocks();
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    protected void add(class_2960 id, MultiblockBuilder multiblock) {
        this.add(id, multiblock.build());
    }

    protected void add(class_2960 id, JsonObject multiblock) {
        this.multiblockConsumer.accept(id, multiblock);
    }

    public String method_10321() {
        return "Multiblocks: " + this.modid;
    }

    public abstract void buildMultiblocks();

    protected abstract class MultiblockBuilder {
        protected JsonObject multiblock = new JsonObject();

        public MultiblockBuilder(MultiblockProvider this$0) {
        }

        public JsonObject build() {
            return this.build(true);
        }

        public JsonObject build(boolean displayGroundLayer) {
            return this.build(displayGroundLayer, 1);
        }

        public abstract JsonObject build(boolean var1, int var2);
    }

    protected class DenseMultiblockBuilder
    extends MultiblockBuilder {
        protected JsonObject multiblock = new JsonObject();

        public DenseMultiblockBuilder(MultiblockProvider this$0) {
            super(this$0);
            this.multiblock.addProperty("type", "modonomicon:dense");
            this.multiblock.add("pattern", (JsonElement)new JsonArray());
            this.multiblock.add("mapping", (JsonElement)new JsonObject());
        }

        private List<String> createPattern(String ... rows) {
            ArrayList<String> pattern = new ArrayList<String>();
            for (String row : rows) {
                pattern.add(row.replace(" ", "_"));
            }
            return pattern;
        }

        public DenseMultiblockBuilder layer(List<String> rows) {
            JsonArray pattern = this.multiblock.getAsJsonArray("pattern");
            JsonArray layer = new JsonArray();
            for (String row : rows) {
                layer.add(row);
            }
            pattern.add((JsonElement)layer);
            return this;
        }

        public DenseMultiblockBuilder layer(String ... rows) {
            return this.layer(this.createPattern(rows));
        }

        private DenseMultiblockBuilder map(String key, JsonObject stateMatcher) {
            JsonObject mapping = this.multiblock.getAsJsonObject("mapping");
            mapping.add(key, (JsonElement)stateMatcher);
            return this;
        }

        public DenseMultiblockBuilder any(char c) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "modonomicon:any");
            return this.map(String.valueOf(c), json);
        }

        public DenseMultiblockBuilder predicate(char c, class_2960 predicateId, boolean countsTowardsTotalBlocks, Supplier<? extends class_2248> display) {
            return this.predicate(c, predicateId, countsTowardsTotalBlocks, display, "");
        }

        public DenseMultiblockBuilder predicate(char c, class_2960 predicateId, boolean countsTowardsTotalBlocks, Supplier<? extends class_2248> display, String displayState) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "modonomicon:predicate");
            json.addProperty("predicate", predicateId.toString());
            json.addProperty("counts_towards_total_blocks", Boolean.valueOf(countsTowardsTotalBlocks));
            json.addProperty("display", String.valueOf(class_7923.field_41175.method_10221((Object)display.get())) + displayState);
            return this.map(String.valueOf(c), json);
        }

        public DenseMultiblockBuilder block(char c, Supplier<? extends class_2248> b) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "modonomicon:block");
            json.addProperty("block", class_7923.field_41175.method_10221((Object)b.get()).toString());
            return this.map(String.valueOf(c), json);
        }

        public DenseMultiblockBuilder block(char c, Supplier<? extends class_2248> b, Supplier<? extends class_2248> display, String displayState) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "modonomicon:block");
            json.addProperty("block", class_7923.field_41175.method_10221((Object)b.get()).toString());
            json.addProperty("display", String.valueOf(class_7923.field_41175.method_10221((Object)display.get())) + displayState);
            return this.map(String.valueOf(c), json);
        }

        public DenseMultiblockBuilder blockstate(char c, Supplier<? extends class_2248> b, String matchState) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "modonomicon:blockstate");
            json.addProperty("block", String.valueOf(class_7923.field_41175.method_10221((Object)b.get())) + matchState);
            return this.map(String.valueOf(c), json);
        }

        public DenseMultiblockBuilder blockstate(char c, Supplier<? extends class_2248> b, String matchState, Supplier<? extends class_2248> display) {
            return this.blockstate(c, b, matchState, display, "");
        }

        public DenseMultiblockBuilder blockstate(char c, Supplier<? extends class_2248> b, String matchState, Supplier<? extends class_2248> display, String displayState) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "modonomicon:blockstate");
            json.addProperty("block", String.valueOf(class_7923.field_41175.method_10221((Object)b.get())) + matchState);
            json.addProperty("display", String.valueOf(class_7923.field_41175.method_10221((Object)display.get())) + displayState);
            return this.map(String.valueOf(c), json);
        }

        public DenseMultiblockBuilder blockstateproperty(char c, Supplier<? extends class_2248> b, String matchState) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "modonomicon:blockstateproperty");
            json.addProperty("block", String.valueOf(class_7923.field_41175.method_10221((Object)b.get())) + matchState);
            return this.map(String.valueOf(c), json);
        }

        public DenseMultiblockBuilder blockstateproperty(char c, Supplier<? extends class_2248> b, String matchState, Supplier<? extends class_2248> display) {
            return this.blockstateproperty(c, b, matchState, display, "");
        }

        public DenseMultiblockBuilder blockstateproperty(char c, Supplier<? extends class_2248> b, String matchState, Supplier<? extends class_2248> display, String displayState) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "modonomicon:blockstblockstatepropertyate");
            json.addProperty("block", String.valueOf(class_7923.field_41175.method_10221((Object)b.get())) + matchState);
            json.addProperty("display", String.valueOf(class_7923.field_41175.method_10221((Object)display.get())) + displayState);
            return this.map(String.valueOf(c), json);
        }

        public DenseMultiblockBuilder display(char c, Supplier<? extends class_2248> display) {
            return this.display(c, display, "");
        }

        public DenseMultiblockBuilder display(char c, Supplier<? extends class_2248> display, String displayState) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "modonomicon:display");
            json.addProperty("display", String.valueOf(class_7923.field_41175.method_10221((Object)display.get())) + displayState);
            return this.map(String.valueOf(c), json);
        }

        public DenseMultiblockBuilder tag(char c, class_6862<class_2248> tag, Supplier<? extends class_2248> display) {
            return this.tag(c, tag, "", display, "");
        }

        public DenseMultiblockBuilder tag(char c, class_6862<class_2248> tag, String matchState, Supplier<? extends class_2248> display, String displayState) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "modonomicon:tag");
            json.addProperty("tag", "#" + String.valueOf(tag.comp_327()) + matchState);
            json.addProperty("display", String.valueOf(class_7923.field_41175.method_10221((Object)display.get())) + displayState);
            return this.map(String.valueOf(c), json);
        }

        @Override
        public JsonObject build() {
            return this.build(true);
        }

        @Override
        public JsonObject build(boolean displayGroundLayer) {
            return this.build(displayGroundLayer, 1);
        }

        @Override
        public JsonObject build(boolean displayGroundLayer, int groundLayerPadding) {
            if (displayGroundLayer) {
                int i;
                this.display('*', () -> class_2246.field_22091).display('+', () -> class_2246.field_10340);
                JsonArray pattern = this.multiblock.getAsJsonArray("pattern");
                int width = pattern.get(0).getAsJsonArray().get(0).getAsString().length();
                int length = pattern.get(0).getAsJsonArray().size();
                JsonArray groundLayer = new JsonArray();
                for (i = 0; i < length + groundLayerPadding * 2; ++i) {
                    StringBuilder row = new StringBuilder();
                    for (int j = 0; j < width + groundLayerPadding * 2; ++j) {
                        if ((i + j) % 2 == 0) {
                            row.append("*");
                            continue;
                        }
                        row.append("+");
                    }
                    groundLayer.add(row.toString());
                }
                for (i = 0; i < pattern.size(); ++i) {
                    int j;
                    JsonArray layer = pattern.get(i).getAsJsonArray();
                    for (int j2 = 0; j2 < layer.size(); ++j2) {
                        int k;
                        String row = layer.get(j2).getAsString();
                        StringBuilder newRow = new StringBuilder();
                        for (k = 0; k < groundLayerPadding; ++k) {
                            newRow.append("_");
                        }
                        newRow.append(row);
                        for (k = 0; k < groundLayerPadding; ++k) {
                            newRow.append("_");
                        }
                        layer.set(j2, (JsonElement)new JsonPrimitive(newRow.toString()));
                    }
                    String emptyRow = "_".repeat(width + groundLayerPadding * 2);
                    JsonArray updatedLayer = new JsonArray();
                    for (j = 0; j < groundLayerPadding; ++j) {
                        updatedLayer.add((JsonElement)new JsonPrimitive(emptyRow));
                    }
                    updatedLayer.addAll(layer);
                    for (j = 0; j < groundLayerPadding; ++j) {
                        updatedLayer.add((JsonElement)new JsonPrimitive(emptyRow));
                    }
                    pattern.set(i, (JsonElement)updatedLayer);
                }
                pattern.add((JsonElement)groundLayer);
            }
            return this.multiblock;
        }
    }
}

