/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen.book;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookTextHolderModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookConditionModel;
import com.klikli_dev.modonomicon.book.BookCategoryBackgroundParallaxLayer;
import com.klikli_dev.modonomicon.book.BookDisplayMode;
import com.klikli_dev.modonomicon.registry.ItemRegistry;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class BookCategoryModel {
    protected BookModel book;
    protected class_2960 id;
    protected String name;
    protected BookTextHolderModel description = new BookTextHolderModel("");
    protected BookIconModel icon = BookIconModel.create((class_1935)ItemRegistry.MODONOMICON_PURPLE.get());
    protected BookDisplayMode displayMode = BookDisplayMode.NODE;
    protected int sortNumber = -1;
    protected class_2960 background = class_2960.method_60654((String)ModonomiconConstants.Data.Category.DEFAULT_BACKGROUND);
    protected int backgroundWidth = 512;
    protected int backgroundHeight = 512;
    protected int maxScrollX = 512;
    protected int maxScrollY = 512;
    protected float backgroundTextureZoomMultiplier = 1.0f;
    protected List<BookCategoryBackgroundParallaxLayer> backgroundParallaxLayers = new ArrayList<BookCategoryBackgroundParallaxLayer>();
    protected class_2960 entryTextures = class_2960.method_60654((String)ModonomiconConstants.Data.Category.DEFAULT_ENTRY_TEXTURES);
    protected List<BookEntryModel> entries = new ArrayList<BookEntryModel>();
    @Nullable
    protected BookConditionModel<?> condition = null;
    protected boolean showCategoryButton = true;
    @Nullable
    protected class_2960 entryToOpen = null;
    protected boolean openEntryToOpenOnlyOnce = true;

    protected BookCategoryModel(class_2960 id, String name) {
        this.id = id;
        this.name = name;
    }

    public static BookCategoryModel create(class_2960 id, String name) {
        return new BookCategoryModel(id, name);
    }

    @Nullable
    public BookConditionModel<?> getCondition() {
        return this.condition;
    }

    public boolean showCategoryButton() {
        return this.showCategoryButton;
    }

    public List<BookEntryModel> getEntries() {
        return this.entries;
    }

    public BookModel getBook() {
        return this.book;
    }

    public JsonObject toJson(class_7225.class_7874 provider) {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.name);
        json.add("description", this.description.toJson(provider));
        json.add("icon", (JsonElement)this.icon.toJson(provider));
        json.addProperty("display_mode", this.displayMode.method_15434());
        json.addProperty("sort_number", (Number)this.sortNumber);
        json.addProperty("background", this.background.toString());
        json.addProperty("background_width", (Number)this.backgroundWidth);
        json.addProperty("background_height", (Number)this.backgroundHeight);
        json.addProperty("max_scroll_x", (Number)this.maxScrollX);
        json.addProperty("max_scroll_y", (Number)this.maxScrollY);
        json.addProperty("background_texture_zoom_multiplier", (Number)Float.valueOf(this.backgroundTextureZoomMultiplier));
        json.add("background_parallax_layers", (JsonElement)this.backgroundParallaxLayers.stream().map(layer -> (JsonElement)BookCategoryBackgroundParallaxLayer.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, layer).getOrThrow()).collect(JsonArray::new, JsonArray::add, JsonArray::addAll));
        json.addProperty("entry_textures", this.entryTextures.toString());
        if (this.condition != null) {
            json.add("condition", (JsonElement)this.condition.toJson(this.getId(), provider));
        }
        json.addProperty("show_category_button", Boolean.valueOf(this.showCategoryButton));
        if (this.entryToOpen != null) {
            if (this.entryToOpen.method_12836().equals(this.getId().method_12836())) {
                json.addProperty("entry_to_open", this.entryToOpen.method_12832());
            } else {
                json.addProperty("entry_to_open", this.entryToOpen.toString());
            }
            json.addProperty("open_entry_to_open_only_once", Boolean.valueOf(this.openEntryToOpenOnlyOnce));
        }
        return json;
    }

    public class_2960 getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public BookTextHolderModel getDescription() {
        return this.description;
    }

    public BookIconModel getIcon() {
        return this.icon;
    }

    public BookDisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public int getSortNumber() {
        return this.sortNumber;
    }

    public class_2960 getBackground() {
        return this.background;
    }

    public int getBackgroundWidth() {
        return this.backgroundWidth;
    }

    public int getBackgroundHeight() {
        return this.backgroundHeight;
    }

    public int getMaxScrollX() {
        return this.maxScrollX;
    }

    public int getMaxScrollY() {
        return this.maxScrollY;
    }

    public List<BookCategoryBackgroundParallaxLayer> getBackgroundParallaxLayers() {
        return this.backgroundParallaxLayers;
    }

    public class_2960 getEntryTextures() {
        return this.entryTextures;
    }

    public BookCategoryModel withDescription(String title) {
        this.description = new BookTextHolderModel(title);
        return this;
    }

    public BookCategoryModel withDescription(class_2561 title) {
        this.description = new BookTextHolderModel(title);
        return this;
    }

    public BookCategoryModel withIcon(BookIconModel icon) {
        this.icon = icon;
        return this;
    }

    public BookCategoryModel withIcon(class_2960 texture) {
        this.icon = BookIconModel.create(texture);
        return this;
    }

    public BookCategoryModel withIcon(class_2960 texture, int width, int height) {
        this.icon = BookIconModel.create(texture, width, height);
        return this;
    }

    public BookCategoryModel withIcon(class_1935 item) {
        this.icon = BookIconModel.create(item);
        return this;
    }

    public BookCategoryModel withDisplayMode(BookDisplayMode displayMode) {
        this.displayMode = displayMode;
        return this;
    }

    public BookCategoryModel withSortNumber(int sortNumber) {
        this.sortNumber = sortNumber;
        return this;
    }

    public BookCategoryModel withBackground(class_2960 background) {
        this.background = background;
        return this;
    }

    public BookCategoryModel withBackgroundSize(int width, int height) {
        this.backgroundWidth = width;
        this.backgroundHeight = height;
        return this;
    }

    public BookCategoryModel withMaxScrollX(int maxScrollX) {
        this.maxScrollX = maxScrollX;
        return this;
    }

    public BookCategoryModel withMaxScrollY(int maxScrollY) {
        this.maxScrollY = maxScrollY;
        return this;
    }

    public BookCategoryModel withMaxScroll(int maxScrollX, int maxScrollY) {
        this.maxScrollX = maxScrollX;
        this.maxScrollY = maxScrollY;
        return this;
    }

    public BookCategoryModel withMaxScroll(int maxScroll) {
        this.maxScrollX = maxScroll;
        this.maxScrollY = maxScroll;
        return this;
    }

    public BookCategoryModel withBackgroundTextureZoomMultiplier(float backgroundTextureZoomMultiplier) {
        this.backgroundTextureZoomMultiplier = backgroundTextureZoomMultiplier;
        return this;
    }

    public BookCategoryModel withBackgroundParallaxLayers(BookCategoryBackgroundParallaxLayer ... layers) {
        this.backgroundParallaxLayers.addAll(List.of(layers));
        return this;
    }

    public BookCategoryModel withBackgroundParallaxLayer(BookCategoryBackgroundParallaxLayer layer) {
        this.backgroundParallaxLayers.add(layer);
        return this;
    }

    public BookCategoryModel withBackgroundParallaxLayer(class_2960 layerTexture) {
        this.backgroundParallaxLayers.add(new BookCategoryBackgroundParallaxLayer(layerTexture));
        return this;
    }

    public BookCategoryModel withEntryTextures(class_2960 entryTextures) {
        this.entryTextures = entryTextures;
        return this;
    }

    public BookCategoryModel withEntries(List<BookEntryModel> entries) {
        entries.forEach(this::linkEntry);
        this.entries.addAll(entries);
        return this;
    }

    protected BookEntryModel linkEntry(BookEntryModel entry) {
        entry.withCategory(this);
        if (!entry.id.method_12832().startsWith(this.id.method_12832())) {
            entry.id = class_2960.method_60655((String)entry.id.method_12836(), (String)(this.id.method_12832() + "/" + entry.id.method_12832()));
        }
        return entry;
    }

    public BookCategoryModel withEntries(BookEntryModel ... entries) {
        return this.withEntries(List.of(entries));
    }

    public BookCategoryModel withEntry(BookEntryModel entry) {
        this.entries.add(this.linkEntry(entry));
        return this;
    }

    public BookCategoryModel withCondition(BookConditionModel<?> condition) {
        this.condition = condition;
        return this;
    }

    public BookCategoryModel withShowCategoryButton(boolean showCategoryButton) {
        this.showCategoryButton = showCategoryButton;
        return this;
    }

    public BookCategoryModel withEntryToOpen(class_2960 entryToOpen) {
        return this.withEntryToOpen(entryToOpen, true);
    }

    public BookCategoryModel withEntryToOpen(class_2960 entryToOpen, boolean openEntryToOpenOnlyOnce) {
        this.entryToOpen = entryToOpen;
        this.openEntryToOpenOnlyOnce = openEntryToOpenOnlyOnce;
        return this;
    }
}

