/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen.book;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.datagen.book.BookModel;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class BookCommandModel {
    protected BookModel book;
    protected class_2960 id;
    protected String command;
    protected int permissionLevel = 0;
    protected int maxUses = 1;
    @Nullable
    protected String failureMessage;
    @Nullable
    protected String successMessage;

    protected BookCommandModel(class_2960 id, String command) {
        this.id = id;
        this.command = command;
    }

    public static BookCommandModel create(class_2960 id, String command) {
        return new BookCommandModel(id, command);
    }

    public BookModel getBook() {
        return this.book;
    }

    public JsonObject toJson(class_7225.class_7874 provider) {
        JsonObject json = new JsonObject();
        json.addProperty("command", this.command);
        json.addProperty("permission_level", (Number)this.permissionLevel);
        json.addProperty("max_uses", (Number)this.maxUses);
        if (this.failureMessage != null) {
            json.addProperty("failure_message", this.failureMessage);
        }
        if (this.successMessage != null) {
            json.addProperty("success_message", this.successMessage);
        }
        return json;
    }

    public class_2960 getId() {
        return this.id;
    }

    public String getCommand() {
        return this.command;
    }

    public int getPermissionLevel() {
        return this.permissionLevel;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    @Nullable
    public String getFailureMessage() {
        return this.failureMessage;
    }

    @Nullable
    public String getSuccessMessage() {
        return this.successMessage;
    }

    public BookCommandModel withPermissionLevel(int permissionLevel) {
        this.permissionLevel = permissionLevel;
        return this;
    }

    public BookCommandModel withMaxUses(int maxUses) {
        this.maxUses = maxUses;
        return this;
    }

    public BookCommandModel withFailureMessage(@Nullable String failureMessage) {
        this.failureMessage = failureMessage;
        return this;
    }

    public BookCommandModel withSuccessMessage(@Nullable String successMessage) {
        this.successMessage = successMessage;
        return this;
    }
}

