/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.book.BookDisplayMode;
import com.klikli_dev.modonomicon.book.BookFrameOverlay;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.PageDisplayMode;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import org.jetbrains.annotations.Nullable;

public class Book {
    protected class_2960 id;
    protected String name;
    protected BookTextHolder description;
    protected String tooltip;
    protected String creativeTab;
    protected class_2960 model;
    protected class_2960 bookOverviewTexture;
    protected class_2960 frameTexture;
    protected BookFrameOverlay topFrameOverlay;
    protected BookFrameOverlay bottomFrameOverlay;
    protected BookFrameOverlay leftFrameOverlay;
    protected BookFrameOverlay rightFrameOverlay;
    protected class_2960 bookContentTexture;
    protected class_2960 craftingTexture;
    protected class_2960 turnPageSound;
    protected Map<class_2960, BookCategory> categories;
    protected Map<class_2960, BookEntry> entries;
    protected Map<class_2960, BookCommand> commands;
    protected int defaultTitleColor;
    protected float categoryButtonIconScale;
    protected boolean autoAddReadConditions;
    protected boolean generateBookItem;
    @Nullable
    protected class_2960 customBookItem;
    protected class_2960 font;
    protected BookDisplayMode displayMode;
    protected int bookTextOffsetX;
    protected int bookTextOffsetY;
    protected int bookTextOffsetWidth;
    protected int bookTextOffsetHeight;
    protected int categoryButtonXOffset;
    protected int categoryButtonYOffset;
    protected int searchButtonXOffset;
    protected int searchButtonYOffset;
    protected int readAllButtonYOffset;
    protected class_2960 leafletEntry;
    protected PageDisplayMode pageDisplayMode = PageDisplayMode.DOUBLE_PAGE;
    protected class_2960 singlePageTexture = class_2960.method_60654((String)ModonomiconConstants.Data.Book.DEFAULT_SINGLE_PAGE_TEXTURE);
    protected boolean allowOpenBooksWithInvalidLinks;

    public Book(class_2960 id, String name, BookTextHolder description, String tooltip, class_2960 model, BookDisplayMode displayMode, boolean generateBookItem, @Nullable class_2960 customBookItem, String creativeTab, class_2960 font, class_2960 bookOverviewTexture, class_2960 frameTexture, BookFrameOverlay topFrameOverlay, BookFrameOverlay bottomFrameOverlay, BookFrameOverlay leftFrameOverlay, BookFrameOverlay rightFrameOverlay, class_2960 bookContentTexture, class_2960 craftingTexture, class_2960 turnPageSound, int defaultTitleColor, float categoryButtonIconScale, boolean autoAddReadConditions, int bookTextOffsetX, int bookTextOffsetY, int bookTextOffsetWidth, int bookTextOffsetHeight, int categoryButtonXOffset, int categoryButtonYOffset, int searchButtonXOffset, int searchButtonYOffset, int readAllButtonYOffset, class_2960 leafletEntry, PageDisplayMode pageDisplayMode, class_2960 singlePageTexture, boolean allowOpenBooksWithInvalidLinks) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.tooltip = tooltip;
        this.model = model;
        this.displayMode = displayMode;
        this.generateBookItem = generateBookItem;
        this.customBookItem = customBookItem;
        this.creativeTab = creativeTab;
        this.bookOverviewTexture = bookOverviewTexture;
        this.font = font;
        this.frameTexture = frameTexture;
        this.topFrameOverlay = topFrameOverlay;
        this.bottomFrameOverlay = bottomFrameOverlay;
        this.leftFrameOverlay = leftFrameOverlay;
        this.rightFrameOverlay = rightFrameOverlay;
        this.bookContentTexture = bookContentTexture;
        this.craftingTexture = craftingTexture;
        this.turnPageSound = turnPageSound;
        this.defaultTitleColor = defaultTitleColor;
        this.categoryButtonIconScale = categoryButtonIconScale;
        this.autoAddReadConditions = autoAddReadConditions;
        this.categories = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
        this.entries = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
        this.commands = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
        this.bookTextOffsetX = bookTextOffsetX;
        this.bookTextOffsetY = bookTextOffsetY;
        this.bookTextOffsetWidth = bookTextOffsetWidth;
        this.bookTextOffsetHeight = bookTextOffsetHeight;
        this.categoryButtonXOffset = categoryButtonXOffset;
        this.categoryButtonYOffset = categoryButtonYOffset;
        this.searchButtonXOffset = searchButtonXOffset;
        this.searchButtonYOffset = searchButtonYOffset;
        this.readAllButtonYOffset = readAllButtonYOffset;
        this.leafletEntry = leafletEntry;
        this.pageDisplayMode = pageDisplayMode;
        this.singlePageTexture = singlePageTexture;
        this.allowOpenBooksWithInvalidLinks = allowOpenBooksWithInvalidLinks;
    }

    public static Book fromJson(class_2960 id, JsonObject json, class_7225.class_7874 provider) {
        String name = class_3518.method_15265((JsonObject)json, (String)"name");
        BookTextHolder description = BookGsonHelper.getAsBookTextHolder(json, "description", BookTextHolder.EMPTY, provider);
        String tooltip = class_3518.method_15253((JsonObject)json, (String)"tooltip", (String)"");
        class_2960 model = class_2960.method_60654((String)class_3518.method_15253((JsonObject)json, (String)"model", (String)ModonomiconConstants.Data.Book.DEFAULT_MODEL));
        boolean generateBookItem = class_3518.method_15258((JsonObject)json, (String)"generate_book_item", (boolean)true);
        BookDisplayMode displayMode = BookDisplayMode.byName(class_3518.method_15253((JsonObject)json, (String)"display_mode", (String)BookDisplayMode.NODE.method_15434()));
        class_2960 customBookItem = json.has("custom_book_item") ? class_2960.method_60654((String)class_3518.method_15265((JsonObject)json, (String)"custom_book_item")) : null;
        String creativeTab = class_3518.method_15253((JsonObject)json, (String)"creative_tab", (String)"misc");
        class_2960 bookOverviewTexture = class_2960.method_60654((String)class_3518.method_15253((JsonObject)json, (String)"book_overview_texture", (String)ModonomiconConstants.Data.Book.DEFAULT_OVERVIEW_TEXTURE));
        class_2960 frameTexture = class_2960.method_60654((String)class_3518.method_15253((JsonObject)json, (String)"frame_texture", (String)ModonomiconConstants.Data.Book.DEFAULT_FRAME_TEXTURE));
        BookFrameOverlay topFrameOverlay = json.has("top_frame_overlay") ? BookFrameOverlay.fromJson(json.get("top_frame_overlay").getAsJsonObject()) : ModonomiconConstants.Data.Book.DEFAULT_TOP_FRAME_OVERLAY;
        BookFrameOverlay bottomFrameOverlay = json.has("bottom_frame_overlay") ? BookFrameOverlay.fromJson(json.get("bottom_frame_overlay").getAsJsonObject()) : ModonomiconConstants.Data.Book.DEFAULT_BOTTOM_FRAME_OVERLAY;
        BookFrameOverlay leftFrameOverlay = json.has("left_frame_overlay") ? BookFrameOverlay.fromJson(json.get("left_frame_overlay").getAsJsonObject()) : ModonomiconConstants.Data.Book.DEFAULT_LEFT_FRAME_OVERLAY;
        BookFrameOverlay rightFrameOverlay = json.has("right_frame_overlay") ? BookFrameOverlay.fromJson(json.get("right_frame_overlay").getAsJsonObject()) : ModonomiconConstants.Data.Book.DEFAULT_RIGHT_FRAME_OVERLAY;
        class_2960 font = class_2960.method_60654((String)class_3518.method_15253((JsonObject)json, (String)"font", (String)ModonomiconConstants.Data.Book.DEFAULT_FONT));
        class_2960 bookContentTexture = class_2960.method_60654((String)class_3518.method_15253((JsonObject)json, (String)"book_content_texture", (String)ModonomiconConstants.Data.Book.DEFAULT_CONTENT_TEXTURE));
        class_2960 craftingTexture = class_2960.method_60654((String)class_3518.method_15253((JsonObject)json, (String)"crafting_texture", (String)ModonomiconConstants.Data.Book.DEFAULT_CRAFTING_TEXTURE));
        class_2960 turnPageSound = class_2960.method_60654((String)class_3518.method_15253((JsonObject)json, (String)"turn_page_sound", (String)ModonomiconConstants.Data.Book.DEFAULT_PAGE_TURN_SOUND));
        int defaultTitleColor = class_3518.method_15282((JsonObject)json, (String)"default_title_color", (int)0);
        float categoryButtonIconScale = class_3518.method_15277((JsonObject)json, (String)"category_button_icon_scale", (float)1.0f);
        boolean autoAddReadConditions = class_3518.method_15258((JsonObject)json, (String)"auto_add_read_conditions", (boolean)false);
        int bookTextOffsetX = class_3518.method_15282((JsonObject)json, (String)"book_text_offset_x", (int)0);
        int bookTextOffsetY = class_3518.method_15282((JsonObject)json, (String)"book_text_offset_y", (int)0);
        int bookTextOffsetWidth = class_3518.method_15282((JsonObject)json, (String)"book_text_offset_width", (int)0);
        int bookTextOffsetHeight = class_3518.method_15282((JsonObject)json, (String)"book_text_offset_height", (int)0);
        int categoryButtonXOffset = class_3518.method_15282((JsonObject)json, (String)"category_button_x_offset", (int)0);
        int categoryButtonYOffset = class_3518.method_15282((JsonObject)json, (String)"category_button_y_offset", (int)0);
        int searchButtonXOffset = class_3518.method_15282((JsonObject)json, (String)"search_button_x_offset", (int)0);
        int searchButtonYOffset = class_3518.method_15282((JsonObject)json, (String)"search_button_y_offset", (int)0);
        int readAllButtonYOffset = class_3518.method_15282((JsonObject)json, (String)"read_all_button_y_offset", (int)0);
        class_2960 leafletEntry = null;
        if (json.has("leaflet_entry")) {
            String leafletEntryPath = class_3518.method_15265((JsonObject)json, (String)"leaflet_entry");
            leafletEntry = leafletEntryPath.contains(":") ? class_2960.method_60654((String)leafletEntryPath) : class_2960.method_60655((String)id.method_12836(), (String)leafletEntryPath);
        }
        PageDisplayMode pageDisplayMode = PageDisplayMode.byName(class_3518.method_15253((JsonObject)json, (String)"page_display_mode", (String)PageDisplayMode.DOUBLE_PAGE.method_15434()));
        class_2960 singlePageTexture = class_2960.method_60654((String)class_3518.method_15253((JsonObject)json, (String)"single_page_texture", (String)ModonomiconConstants.Data.Book.DEFAULT_SINGLE_PAGE_TEXTURE));
        boolean allowOpenBooksWithInvalidLinks = class_3518.method_15258((JsonObject)json, (String)"allow_open_book_with_invalid_links", (boolean)false);
        return new Book(id, name, description, tooltip, model, displayMode, generateBookItem, customBookItem, creativeTab, font, bookOverviewTexture, frameTexture, topFrameOverlay, bottomFrameOverlay, leftFrameOverlay, rightFrameOverlay, bookContentTexture, craftingTexture, turnPageSound, defaultTitleColor, categoryButtonIconScale, autoAddReadConditions, bookTextOffsetX, bookTextOffsetY, bookTextOffsetWidth, bookTextOffsetHeight, categoryButtonXOffset, categoryButtonYOffset, searchButtonXOffset, searchButtonYOffset, readAllButtonYOffset, leafletEntry, pageDisplayMode, singlePageTexture, allowOpenBooksWithInvalidLinks);
    }

    public static Book fromNetwork(class_2960 id, class_9129 buffer) {
        String name = buffer.method_19772();
        BookTextHolder description = BookTextHolder.fromNetwork(buffer);
        String tooltip = buffer.method_19772();
        class_2960 model = buffer.method_10810();
        BookDisplayMode displayMode = BookDisplayMode.byId(buffer.readByte());
        boolean generateBookItem = buffer.readBoolean();
        class_2960 customBookItem = (class_2960)buffer.method_43827(class_2540::method_10810);
        String creativeTab = buffer.method_19772();
        class_2960 font = buffer.method_10810();
        class_2960 bookOverviewTexture = buffer.method_10810();
        class_2960 frameTexture = buffer.method_10810();
        BookFrameOverlay topFrameOverlay = BookFrameOverlay.fromNetwork((class_2540)buffer);
        BookFrameOverlay bottomFrameOverlay = BookFrameOverlay.fromNetwork((class_2540)buffer);
        BookFrameOverlay leftFrameOverlay = BookFrameOverlay.fromNetwork((class_2540)buffer);
        BookFrameOverlay rightFrameOverlay = BookFrameOverlay.fromNetwork((class_2540)buffer);
        class_2960 bookContentTexture = buffer.method_10810();
        class_2960 craftingTexture = buffer.method_10810();
        class_2960 turnPageSound = buffer.method_10810();
        int defaultTitleColor = buffer.readInt();
        float categoryButtonIconScale = buffer.readFloat();
        boolean autoAddReadConditions = buffer.readBoolean();
        short bookTextOffsetX = buffer.readShort();
        short bookTextOffsetY = buffer.readShort();
        short bookTextOffsetWidth = buffer.readShort();
        short bookTextOffsetHeight = buffer.readShort();
        short categoryButtonXOffset = buffer.readShort();
        short categoryButtonYOffset = buffer.readShort();
        short searchButtonXOffset = buffer.readShort();
        short searchButtonYOffset = buffer.readShort();
        short readAllButtonYOffset = buffer.readShort();
        class_2960 leafletEntry = (class_2960)buffer.method_43827(class_2540::method_10810);
        PageDisplayMode pageDisplayMode = PageDisplayMode.byId(buffer.readByte());
        class_2960 singlePageTexture = buffer.method_10810();
        boolean allowOpenBooksWithInvalidLinks = buffer.readBoolean();
        return new Book(id, name, description, tooltip, model, displayMode, generateBookItem, customBookItem, creativeTab, font, bookOverviewTexture, frameTexture, topFrameOverlay, bottomFrameOverlay, leftFrameOverlay, rightFrameOverlay, bookContentTexture, craftingTexture, turnPageSound, defaultTitleColor, categoryButtonIconScale, autoAddReadConditions, bookTextOffsetX, bookTextOffsetY, bookTextOffsetWidth, bookTextOffsetHeight, categoryButtonXOffset, categoryButtonYOffset, searchButtonXOffset, searchButtonYOffset, readAllButtonYOffset, leafletEntry, pageDisplayMode, singlePageTexture, allowOpenBooksWithInvalidLinks);
    }

    public void build(class_1937 level) {
        for (BookCategory category : this.categories.values()) {
            for (BookEntry entry : category.getEntries().values()) {
                this.addEntry(entry);
            }
        }
        for (BookCategory category : this.categories.values()) {
            BookErrorManager.get().getContextHelper().categoryId = category.getId();
            category.build(level, this);
            BookErrorManager.get().getContextHelper().categoryId = null;
        }
        for (BookCommand command : this.commands.values()) {
            command.build(this);
        }
    }

    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        if (!this.description.hasComponent()) {
            this.description = new RenderedBookTextHolder(this.description, textRenderer.render(this.description.getString()));
        }
        for (BookCategory category : this.categories.values()) {
            BookErrorManager.get().getContextHelper().categoryId = category.getId();
            category.prerenderMarkdown(textRenderer);
            BookErrorManager.get().getContextHelper().categoryId = null;
        }
    }

    public void toNetwork(class_9129 buffer) {
        buffer.method_10814(this.name);
        this.description.toNetwork(buffer);
        buffer.method_10814(this.tooltip);
        buffer.method_10812(this.model);
        buffer.method_52997(this.displayMode.ordinal());
        buffer.method_52964(this.generateBookItem);
        buffer.method_43826((Object)this.customBookItem, class_2540::method_10812);
        buffer.method_10814(this.creativeTab);
        buffer.method_10812(this.font);
        buffer.method_10812(this.bookOverviewTexture);
        buffer.method_10812(this.frameTexture);
        this.topFrameOverlay.toNetwork((class_2540)buffer);
        this.bottomFrameOverlay.toNetwork((class_2540)buffer);
        this.leftFrameOverlay.toNetwork((class_2540)buffer);
        this.rightFrameOverlay.toNetwork((class_2540)buffer);
        buffer.method_10812(this.bookContentTexture);
        buffer.method_10812(this.craftingTexture);
        buffer.method_10812(this.turnPageSound);
        buffer.method_53002(this.defaultTitleColor);
        buffer.method_52941(this.categoryButtonIconScale);
        buffer.method_52964(this.autoAddReadConditions);
        buffer.method_52998(this.bookTextOffsetX);
        buffer.method_52998(this.bookTextOffsetY);
        buffer.method_52998(this.bookTextOffsetWidth);
        buffer.method_52998(this.bookTextOffsetHeight);
        buffer.method_52998(this.categoryButtonXOffset);
        buffer.method_52998(this.categoryButtonYOffset);
        buffer.method_52998(this.searchButtonXOffset);
        buffer.method_52998(this.searchButtonYOffset);
        buffer.method_52998(this.readAllButtonYOffset);
        buffer.method_43826((Object)this.leafletEntry, class_2540::method_10812);
        buffer.method_52997(this.pageDisplayMode.ordinal());
        buffer.method_10812(this.singlePageTexture);
        buffer.method_52964(this.allowOpenBooksWithInvalidLinks);
    }

    public boolean autoAddReadConditions() {
        return this.autoAddReadConditions;
    }

    public class_2960 getTurnPageSound() {
        return this.turnPageSound;
    }

    public int getDefaultTitleColor() {
        return this.defaultTitleColor;
    }

    public float getCategoryButtonIconScale() {
        return this.categoryButtonIconScale;
    }

    public class_2960 getId() {
        return this.id;
    }

    public void addCategory(BookCategory category) {
        this.categories.putIfAbsent(category.id, category);
    }

    public BookCategory getCategory(class_2960 id) {
        return this.categories.get(id);
    }

    public Map<class_2960, BookCategory> getCategories() {
        return this.categories;
    }

    public List<BookCategory> getCategoriesSorted() {
        return this.categories.values().stream().sorted(Comparator.comparingInt(BookCategory::getSortNumber)).toList();
    }

    public void addEntry(BookEntry entry) {
        this.entries.putIfAbsent(entry.getId(), entry);
    }

    public BookEntry getEntry(class_2960 id) {
        return this.entries.get(id);
    }

    public Map<class_2960, BookEntry> getEntries() {
        return this.entries;
    }

    public void addCommand(BookCommand command) {
        this.commands.putIfAbsent(command.id, command);
    }

    public Map<class_2960, BookCommand> getCommands() {
        return this.commands;
    }

    public BookCommand getCommand(class_2960 id) {
        return this.commands.get(id);
    }

    public String getName() {
        return this.name;
    }

    public BookTextHolder getDescription() {
        return this.description;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public String getCreativeTab() {
        return this.creativeTab;
    }

    public class_2960 getBookOverviewTexture() {
        return this.bookOverviewTexture;
    }

    public class_2960 getFont() {
        return this.font;
    }

    public class_2960 getFrameTexture() {
        return this.frameTexture;
    }

    public BookFrameOverlay getTopFrameOverlay() {
        return this.topFrameOverlay;
    }

    public BookFrameOverlay getBottomFrameOverlay() {
        return this.bottomFrameOverlay;
    }

    public BookFrameOverlay getLeftFrameOverlay() {
        return this.leftFrameOverlay;
    }

    public BookFrameOverlay getRightFrameOverlay() {
        return this.rightFrameOverlay;
    }

    @Nullable
    public class_2960 getCustomBookItem() {
        return this.customBookItem;
    }

    public class_2960 getCraftingTexture() {
        return this.craftingTexture;
    }

    public class_2960 getBookContentTexture() {
        return this.bookContentTexture;
    }

    public class_2960 getModel() {
        return this.model;
    }

    public BookDisplayMode getDisplayMode() {
        if (this.isLeaflet()) {
            return BookDisplayMode.INDEX;
        }
        return this.displayMode;
    }

    public boolean generateBookItem() {
        return this.generateBookItem;
    }

    public int getBookTextOffsetX() {
        return this.bookTextOffsetX;
    }

    public int getBookTextOffsetY() {
        return this.bookTextOffsetY;
    }

    public int getBookTextOffsetWidth() {
        return this.bookTextOffsetWidth;
    }

    public int getBookTextOffsetHeight() {
        return this.bookTextOffsetHeight;
    }

    public int getCategoryButtonXOffset() {
        return this.categoryButtonXOffset;
    }

    public int getCategoryButtonYOffset() {
        return this.categoryButtonYOffset;
    }

    public int getSearchButtonXOffset() {
        return this.searchButtonXOffset;
    }

    public int getSearchButtonYOffset() {
        return this.searchButtonYOffset;
    }

    public int getReadAllButtonYOffset() {
        return this.readAllButtonYOffset;
    }

    public class_2960 getLeafletEntry() {
        return this.leafletEntry;
    }

    public boolean isLeaflet() {
        return this.leafletEntry != null;
    }

    public BookAddress getLeafletAddress() {
        BookEntry leafletEntry = this.getEntry(this.leafletEntry);
        return BookAddress.ignoreSaved(leafletEntry);
    }

    public PageDisplayMode getPageDisplayMode() {
        return this.pageDisplayMode;
    }

    public class_2960 getSinglePageTexture() {
        return this.singlePageTexture;
    }

    public boolean allowOpenBooksWithInvalidLinks() {
        return this.allowOpenBooksWithInvalidLinks;
    }
}

