/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3518;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9326;

public class BookIcon {
    public static final Codec<class_1799> CUSTOM_ITEM_STACK_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)class_1799.field_47312.fieldOf("item").forGetter(class_1799::method_41409), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(class_1799::method_7947), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(class_1799::method_57380)).apply((Applicative)builder, class_1799::new));
    public static final Codec<class_1799> ITEM_STACK_CODEC = Codec.withAlternative(CUSTOM_ITEM_STACK_CODEC, (Codec)class_1799.field_24671);
    private final class_1799 itemStack;
    private final class_2960 texture;
    private final int width;
    private final int height;

    public BookIcon(class_1799 stack) {
        this.itemStack = stack;
        this.texture = null;
        this.width = 16;
        this.height = 16;
    }

    public BookIcon(class_2960 texture, int width, int height) {
        this.texture = texture;
        this.itemStack = class_1799.field_8037;
        this.width = width;
        this.height = height;
    }

    public static BookIcon fromJson(JsonElement jsonElement, class_7225.class_7874 provider) {
        if (jsonElement.isJsonPrimitive()) {
            return BookIcon.fromString(class_2960.method_60654((String)jsonElement.getAsString()));
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (jsonObject.has("texture")) {
            int width = class_3518.method_15282((JsonObject)jsonObject, (String)"width", (int)16);
            int height = class_3518.method_15282((JsonObject)jsonObject, (String)"height", (int)16);
            class_2960 texture = class_2960.method_60654((String)class_3518.method_15265((JsonObject)jsonObject, (String)"texture"));
            return new BookIcon(texture, width, height);
        }
        class_1799 stack = (class_1799)((Pair)ITEM_STACK_CODEC.decode((DynamicOps)provider.method_57093((DynamicOps)JsonOps.INSTANCE), (Object)jsonObject).getOrThrow(e -> {
            throw new JsonParseException("BookIcon must have either item or texture defined." + String.valueOf(jsonElement), new Throwable((String)e));
        })).getFirst();
        return new BookIcon(stack);
    }

    private static BookIcon fromString(class_2960 value) {
        if (value.method_12832().endsWith(".png")) {
            return new BookIcon(value, 16, 16);
        }
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(value);
        return new BookIcon(new class_1799((class_1935)item));
    }

    public static BookIcon fromNetwork(class_9129 buffer) {
        if (buffer.readBoolean()) {
            class_2960 texture = buffer.method_10810();
            int width = buffer.method_10816();
            int height = buffer.method_10816();
            return new BookIcon(texture, width, height);
        }
        class_1799 stack = (class_1799)class_1799.field_48349.decode((Object)buffer);
        return new BookIcon(stack);
    }

    public void render(class_332 guiGraphics, int x, int y) {
        if (this.texture != null) {
            guiGraphics.method_25293(this.texture, x, y, 16, 16, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        } else {
            guiGraphics.method_51427(this.itemStack, x, y);
        }
    }

    public void toNetwork(class_9129 buffer) {
        buffer.method_52964(this.texture != null);
        if (this.texture != null) {
            buffer.method_10812(this.texture);
            buffer.method_10804(this.width);
            buffer.method_10804(this.height);
        } else {
            class_1799.field_48349.encode((Object)buffer, (Object)this.itemStack);
        }
    }
}

