/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.data.BookDataManager;
import net.minecraft.class_2960;

public class CommandLink {
    public static final String PROTOCOL_COMMAND = "command://";
    public class_2960 bookId;
    public class_2960 commandId;

    private CommandLink() {
    }

    private static CommandLink fromCommand(Book fromBook, String linkText) {
        linkText = linkText.substring(PROTOCOL_COMMAND.length());
        CommandLink commandLink = new CommandLink();
        if (linkText.contains(":")) {
            String[] parts = linkText.split("/", 2);
            commandLink.bookId = class_2960.method_12829((String)parts[0]);
            Book book = BookDataManager.get().getBook(commandLink.bookId);
            if (book == null) {
                throw new IllegalArgumentException("Invalid command link, book not found: " + linkText);
            }
            if (parts.length == 1) {
                throw new IllegalArgumentException("Invalid command link, does not contain any command id: " + linkText);
            }
            commandLink.commandId = class_2960.method_60655((String)commandLink.bookId.method_12836(), (String)parts[1]);
            BookCommand command = book.getCommand(commandLink.commandId);
            if (command == null) {
                throw new IllegalArgumentException("Invalid command link, command not found in book: " + linkText);
            }
            return commandLink;
        }
        commandLink.bookId = fromBook.getId();
        if (linkText.isEmpty()) {
            throw new IllegalArgumentException("Invalid command link, does not contain any command id, because it is empty: " + linkText);
        }
        commandLink.commandId = class_2960.method_60655((String)commandLink.bookId.method_12836(), (String)linkText);
        BookCommand command = fromBook.getCommand(commandLink.commandId);
        if (command == null) {
            throw new IllegalArgumentException("Invalid command link, command not found in book: " + linkText);
        }
        return commandLink;
    }

    public static CommandLink from(Book fromBook, String linkText) {
        if (linkText.toLowerCase().startsWith(PROTOCOL_COMMAND)) {
            return CommandLink.fromCommand(fromBook, linkText);
        }
        throw new IllegalArgumentException("Invalid command link, does not start with \"command://\": " + linkText);
    }

    public static boolean isCommandLink(String linkText) {
        return linkText.toLowerCase().startsWith(PROTOCOL_COMMAND);
    }
}

