/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.conditions;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionEntryContext;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_8824;
import net.minecraft.class_9129;

public class BookEntryUnlockedCondition
extends BookCondition {
    protected class_2960 entryId;

    public BookEntryUnlockedCondition(class_2561 tooltip, class_2960 entryId) {
        super(tooltip);
        this.entryId = entryId;
    }

    public static BookEntryUnlockedCondition fromJson(class_2960 conditionParentId, JsonObject json, class_7225.class_7874 provider) {
        String entryPath = class_3518.method_15265((JsonObject)json, (String)"entry_id");
        class_2960 entryId = entryPath.contains(":") ? class_2960.method_60654((String)entryPath) : class_2960.method_60655((String)conditionParentId.method_12836(), (String)entryPath);
        class_5250 tooltip = BookEntryUnlockedCondition.tooltipFromJson(json, provider);
        return new BookEntryUnlockedCondition((class_2561)tooltip, entryId);
    }

    public static BookEntryUnlockedCondition fromNetwork(class_9129 buffer) {
        class_2561 tooltip = buffer.readBoolean() ? (class_2561)class_8824.field_48540.decode((Object)buffer) : null;
        class_2960 entryId = buffer.method_10810();
        return new BookEntryUnlockedCondition(tooltip, entryId);
    }

    @Override
    public class_2960 getType() {
        return ModonomiconConstants.Data.Condition.ENTRY_UNLOCKED;
    }

    @Override
    public boolean requiresMultiPassUnlockTest() {
        return true;
    }

    @Override
    public void toNetwork(class_9129 buffer) {
        buffer.method_52964(this.tooltip != null);
        if (this.tooltip != null) {
            class_8824.field_48540.encode((Object)buffer, (Object)this.tooltip);
        }
        buffer.method_10812(this.entryId);
    }

    @Override
    public boolean test(BookConditionContext context, class_1657 player) {
        BookEntry entry = context.getBook().getEntry(this.entryId);
        if (entry == null) {
            throw new IllegalArgumentException("Entry with id " + String.valueOf(this.entryId) + " not found in book " + String.valueOf(context.getBook().getId()) + "for BookEntryReadCondition. This happened while trying to unlock " + String.valueOf(context));
        }
        return BookUnlockStateManager.get().isUnlockedFor(player, entry);
    }

    @Override
    public List<class_2561> getTooltip(class_1657 player, BookConditionContext context) {
        if (this.tooltip == null && context instanceof BookConditionEntryContext) {
            BookConditionEntryContext entryContext = (BookConditionEntryContext)context;
            this.tooltip = class_2561.method_43469((String)"tooltip.modonomicon.condition.entry_unlocked", (Object[])new Object[]{class_2561.method_43471((String)entryContext.getBook().getEntry(this.entryId).getName())});
        }
        return super.getTooltip(player, context);
    }
}

