/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.conditions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_8824;
import net.minecraft.class_9129;

public class BookOrCondition
extends BookCondition {
    protected BookCondition[] children;
    protected List<class_2561> tooltips;

    public BookOrCondition(class_2561 component, BookCondition[] children) {
        super(component);
        if (children == null || children.length == 0) {
            throw new IllegalArgumentException("OrCondition must have at least one child.");
        }
        this.children = children;
    }

    public static BookOrCondition fromJson(class_2960 conditionParentId, JsonObject json, class_7225.class_7874 provider) {
        ArrayList<BookCondition> children = new ArrayList<BookCondition>();
        for (JsonElement j : class_3518.method_15261((JsonObject)json, (String)"children")) {
            if (!j.isJsonObject()) {
                throw new JsonSyntaxException("Condition children must be an array of JsonObjects.");
            }
            children.add(BookCondition.fromJson(conditionParentId, j.getAsJsonObject(), provider));
        }
        class_5250 tooltip = BookOrCondition.tooltipFromJson(json, provider);
        return new BookOrCondition((class_2561)tooltip, children.toArray(new BookCondition[children.size()]));
    }

    public static BookOrCondition fromNetwork(class_9129 buffer) {
        class_2561 tooltip = buffer.readBoolean() ? (class_2561)class_8824.field_48540.decode((Object)buffer) : null;
        int childCount = buffer.method_10816();
        BookCondition[] children = new BookCondition[childCount];
        for (int i = 0; i < childCount; ++i) {
            children[i] = BookCondition.fromNetwork(buffer);
        }
        return new BookOrCondition(tooltip, children);
    }

    @Override
    public class_2960 getType() {
        return ModonomiconConstants.Data.Condition.OR;
    }

    @Override
    public boolean requiresMultiPassUnlockTest() {
        return Arrays.stream(this.children).anyMatch(BookCondition::requiresMultiPassUnlockTest);
    }

    public BookCondition[] children() {
        return this.children;
    }

    @Override
    public void toNetwork(class_9129 buffer) {
        buffer.method_52964(this.tooltip != null);
        if (this.tooltip != null) {
            class_8824.field_48540.encode((Object)buffer, (Object)this.tooltip);
        }
        buffer.method_10804(this.children.length);
        for (BookCondition child : this.children) {
            BookCondition.toNetwork(child, buffer);
        }
    }

    @Override
    public boolean test(BookConditionContext context, class_1657 player) {
        for (BookCondition child : this.children) {
            if (!child.test(context, player)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean testOnLoad() {
        for (BookCondition child : this.children) {
            if (!child.testOnLoad()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<class_2561> getTooltip(class_1657 player, BookConditionContext context) {
        if (this.tooltips == null) {
            this.tooltips = new ArrayList<class_2561>();
        }
        this.tooltips.clear();
        if (this.tooltip != null) {
            this.tooltips.add(this.tooltip);
        }
        for (BookCondition child : this.children) {
            this.tooltips.addAll(child.getTooltip(player, context));
        }
        return this.tooltips;
    }
}

