/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.entries;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7225;
import net.minecraft.class_9129;

public class CategoryLinkBookEntry
extends BookEntry {
    protected class_2960 categoryToOpenId;
    protected BookCategory categoryToOpen;

    public CategoryLinkBookEntry(class_2960 id, BookEntry.BookEntryData data, class_2960 commandToRunOnFirstReadId, class_2960 categoryToOpenId) {
        super(id, data, commandToRunOnFirstReadId);
        this.categoryToOpenId = categoryToOpenId;
    }

    public static CategoryLinkBookEntry fromJson(class_2960 id, JsonObject json, boolean autoAddReadConditions, class_7225.class_7874 provider) {
        String categoryToOpenIdPath;
        BookEntry.BookEntryData data = BookEntry.BookEntryData.fromJson(id, json, autoAddReadConditions, provider);
        class_2960 commandToRunOnFirstReadId = null;
        if (json.has("command_to_run_on_first_read")) {
            commandToRunOnFirstReadId = class_2960.method_60654((String)class_3518.method_15265((JsonObject)json, (String)"command_to_run_on_first_read"));
        }
        class_2960 categoryToOpenId = (categoryToOpenIdPath = class_3518.method_15265((JsonObject)json, (String)"category_to_open")).contains(":") ? class_2960.method_60654((String)categoryToOpenIdPath) : class_2960.method_60655((String)id.method_12836(), (String)categoryToOpenIdPath);
        return new CategoryLinkBookEntry(id, data, commandToRunOnFirstReadId, categoryToOpenId);
    }

    public static CategoryLinkBookEntry fromNetwork(class_9129 buffer) {
        class_2960 id = buffer.method_10810();
        BookEntry.BookEntryData data = BookEntry.BookEntryData.fromNetwork(buffer);
        class_2960 commandToRunOnFirstReadId = (class_2960)buffer.method_43827(class_2540::method_10810);
        class_2960 categoryToOpen = buffer.method_10810();
        return new CategoryLinkBookEntry(id, data, commandToRunOnFirstReadId, categoryToOpen);
    }

    @Override
    public class_2960 getType() {
        return ModonomiconConstants.Data.EntryType.CATEGORY_LINK;
    }

    @Override
    public void toNetwork(class_9129 buffer) {
        buffer.method_10812(this.id);
        this.data.toNetwork(buffer);
        buffer.method_43826((Object)this.commandToRunOnFirstReadId, class_2540::method_10812);
        buffer.method_10812(this.categoryToOpenId);
    }

    @Override
    public void build(class_1937 level, BookCategory category) {
        super.build(level, category);
        if (this.categoryToOpenId != null) {
            this.categoryToOpen = this.getBook().getCategory(this.categoryToOpenId);
            if (this.categoryToOpen == null) {
                BookErrorManager.get().error("Category to open \"" + String.valueOf(this.categoryToOpenId) + "\" does not exist in this book. Set to null.");
                this.categoryToOpenId = null;
            }
        }
    }

    public BookCategory getCategoryToOpen() {
        return this.categoryToOpen;
    }

    @Override
    public void openEntry(BookAddress address) {
        BookGuiManager.get().pushHistory(BookAddress.defaultFor(this.getCategory()));
        BookGuiManager.get().openCategoryLinkEntry(this);
    }
}

