/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.page;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7225;
import net.minecraft.class_9129;

public class BookImagePage
extends BookPage {
    protected BookTextHolder title;
    protected BookTextHolder text;
    protected class_2960[] images;
    protected boolean border;
    protected boolean useLegacyRendering;

    public BookImagePage(BookTextHolder title, BookTextHolder text, class_2960[] images, boolean border, boolean useLegacyRendering, String anchor, BookCondition condition) {
        super(anchor, condition);
        this.title = title;
        this.text = text;
        this.images = images;
        this.border = border;
        this.useLegacyRendering = useLegacyRendering;
    }

    public static BookImagePage fromJson(class_2960 entryId, JsonObject json, class_7225.class_7874 provider) {
        BookTextHolder title = BookGsonHelper.getAsBookTextHolder(json, "title", BookTextHolder.EMPTY, provider);
        BookTextHolder text = BookGsonHelper.getAsBookTextHolder(json, "text", BookTextHolder.EMPTY, provider);
        JsonArray imagesArray = class_3518.method_15261((JsonObject)json, (String)"images");
        class_2960[] images = new class_2960[imagesArray.size()];
        for (int i = 0; i < imagesArray.size(); ++i) {
            images[i] = class_2960.method_60654((String)class_3518.method_15287((JsonElement)imagesArray.get(i), (String)("images[" + i + "]")));
        }
        boolean border = class_3518.method_15258((JsonObject)json, (String)"border", (boolean)true);
        boolean useLegacyRendering = class_3518.method_15258((JsonObject)json, (String)"use_legacy_rendering", (boolean)false);
        String anchor = class_3518.method_15253((JsonObject)json, (String)"anchor", (String)"");
        BookNoneCondition condition = json.has("condition") ? BookCondition.fromJson(entryId, json.getAsJsonObject("condition"), provider) : new BookNoneCondition();
        return new BookImagePage(title, text, images, border, useLegacyRendering, anchor, condition);
    }

    public static BookImagePage fromNetwork(class_9129 buffer) {
        BookTextHolder title = BookTextHolder.fromNetwork(buffer);
        BookTextHolder text = BookTextHolder.fromNetwork(buffer);
        int count = buffer.method_10816();
        class_2960[] images = new class_2960[count];
        for (int i = 0; i < count; ++i) {
            images[i] = class_2960.method_60654((String)buffer.method_19772());
        }
        boolean border = buffer.readBoolean();
        boolean useLegacyRendering = buffer.readBoolean();
        String anchor = buffer.method_19772();
        BookCondition condition = BookCondition.fromNetwork(buffer);
        return new BookImagePage(title, text, images, border, useLegacyRendering, anchor, condition);
    }

    public class_2960[] getImages() {
        return this.images;
    }

    public boolean hasBorder() {
        return this.border;
    }

    public boolean useLegacyRendering() {
        return this.useLegacyRendering;
    }

    public BookTextHolder getTitle() {
        return this.title;
    }

    public BookTextHolder getText() {
        return this.text;
    }

    public boolean hasTitle() {
        return !this.title.isEmpty();
    }

    @Override
    public class_2960 getType() {
        return ModonomiconConstants.Data.Page.IMAGE;
    }

    @Override
    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        super.prerenderMarkdown(textRenderer);
        if (!this.title.hasComponent()) {
            this.title = new BookTextHolder((class_2561)class_2561.method_43471((String)this.title.getKey()).method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_36139(this.getParentEntry().getBook().getDefaultTitleColor())));
        }
        if (!this.text.hasComponent()) {
            this.text = new RenderedBookTextHolder(this.text, textRenderer.render(this.text.getString()));
        }
    }

    @Override
    public void toNetwork(class_9129 buffer) {
        this.title.toNetwork(buffer);
        this.text.toNetwork(buffer);
        buffer.method_10804(this.images.length);
        for (class_2960 image : this.images) {
            buffer.method_10814(image.toString());
        }
        buffer.method_52964(this.border);
        buffer.method_52964(this.useLegacyRendering);
        super.toNetwork(buffer);
    }

    @Override
    public boolean matchesQuery(String query) {
        return this.title.getString().toLowerCase().contains(query) || this.text.getString().toLowerCase().contains(query);
    }
}

