/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.page;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.entries.BookContentEntry;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9129;

public abstract class BookRecipePage<T extends class_1860<?>>
extends BookPage {
    protected final class_3956<? extends T> recipeType;
    protected BookTextHolder title1;
    protected class_2960 recipeId1;
    protected class_8786<T> recipe1;
    protected BookTextHolder title2;
    protected class_2960 recipeId2;
    protected class_8786<T> recipe2;
    protected BookTextHolder text;

    public BookRecipePage(class_3956<? extends T> recipeType, BookTextHolder title1, class_2960 recipeId1, BookTextHolder title2, class_2960 recipeId2, BookTextHolder text, String anchor, BookCondition condition) {
        super(anchor, condition);
        this.recipeType = recipeType;
        this.title1 = title1;
        this.recipeId1 = recipeId1;
        this.title2 = title2;
        this.recipeId2 = recipeId2;
        this.text = text;
    }

    public static DataHolder commonFromJson(JsonObject json, class_7225.class_7874 provider) {
        BookTextHolder title1 = BookGsonHelper.getAsBookTextHolder(json, "title1", BookTextHolder.EMPTY, provider);
        class_2960 recipeId1 = json.has("recipe_id_1") ? class_2960.method_12829((String)class_3518.method_15265((JsonObject)json, (String)"recipe_id_1")) : null;
        BookTextHolder title2 = BookGsonHelper.getAsBookTextHolder(json, "title2", BookTextHolder.EMPTY, provider);
        class_2960 recipeId2 = json.has("recipe_id_2") ? class_2960.method_12829((String)class_3518.method_15265((JsonObject)json, (String)"recipe_id_2")) : null;
        BookTextHolder text = BookGsonHelper.getAsBookTextHolder(json, "text", BookTextHolder.EMPTY, provider);
        return new DataHolder(title1, recipeId1, title2, recipeId2, text);
    }

    public static DataHolder commonFromNetwork(class_9129 buffer) {
        BookTextHolder title1 = BookTextHolder.fromNetwork(buffer);
        class_2960 recipeId1 = buffer.readBoolean() ? buffer.method_10810() : null;
        BookTextHolder title2 = BookTextHolder.fromNetwork(buffer);
        class_2960 recipeId2 = buffer.readBoolean() ? buffer.method_10810() : null;
        BookTextHolder text = BookTextHolder.fromNetwork(buffer);
        return new DataHolder(title1, recipeId1, title2, recipeId2, text);
    }

    public class_3956<? extends T> getRecipeType() {
        return this.recipeType;
    }

    public BookTextHolder getTitle1() {
        return this.title1;
    }

    public class_2960 getRecipeId1() {
        return this.recipeId1;
    }

    public class_8786<T> getRecipe1() {
        return this.recipe1;
    }

    public BookTextHolder getTitle2() {
        return this.title2;
    }

    public class_2960 getRecipeId2() {
        return this.recipeId2;
    }

    public class_8786<T> getRecipe2() {
        return this.recipe2;
    }

    public BookTextHolder getText() {
        return this.text;
    }

    protected class_8786<T> loadRecipe(class_1937 level, BookContentEntry entry, class_2960 recipeId) {
        if (recipeId == null) {
            return null;
        }
        class_8786<T> tempRecipe = this.getRecipe(level, recipeId);
        if (tempRecipe == null) {
            Modonomicon.LOG.warn("Recipe {} (of type {}) not found.", (Object)recipeId, (Object)class_7923.field_41188.method_10221(this.recipeType));
        }
        return tempRecipe;
    }

    protected abstract class_1799 getRecipeOutput(class_1937 var1, class_8786<T> var2);

    private class_8786<T> getRecipe(class_1937 level, class_2960 id) {
        return level.method_8433().method_8130(id).filter(recipe -> recipe.comp_1933().method_17716() == this.recipeType).orElse(null);
    }

    @Override
    public void build(class_1937 level, BookContentEntry parentEntry, int pageNum) {
        super.build(level, parentEntry, pageNum);
        this.recipe1 = this.loadRecipe(level, parentEntry, this.recipeId1);
        this.recipe2 = this.loadRecipe(level, parentEntry, this.recipeId2);
        if (this.recipe1 == null && this.recipe2 != null) {
            this.recipe1 = this.recipe2;
            this.recipe2 = null;
        }
        if (this.title1.isEmpty()) {
            this.title1 = new BookTextHolder((class_2561)((class_5250)this.getRecipeOutput(level, this.recipe1).method_7964()).method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_36139(this.getParentEntry().getBook().getDefaultTitleColor())));
        }
        if (this.recipe2 != null && this.title2.isEmpty()) {
            this.title2 = new BookTextHolder((class_2561)((class_5250)this.getRecipeOutput(level, this.recipe2).method_7964()).method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_36139(this.getParentEntry().getBook().getDefaultTitleColor())));
        }
        if (this.title1.equals(this.title2)) {
            this.title2 = BookTextHolder.EMPTY;
        }
    }

    @Override
    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        super.prerenderMarkdown(textRenderer);
        if (!this.title1.hasComponent()) {
            this.title1 = new BookTextHolder((class_2561)class_2561.method_43471((String)this.title1.getKey()).method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_36139(this.getParentEntry().getCategory().getBook().getDefaultTitleColor())));
        }
        if (!this.title2.hasComponent()) {
            this.title2 = new BookTextHolder((class_2561)class_2561.method_43471((String)this.title2.getKey()).method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_36139(this.getParentEntry().getCategory().getBook().getDefaultTitleColor())));
        }
        if (!this.text.hasComponent()) {
            this.text = new RenderedBookTextHolder(this.text, textRenderer.render(this.text.getString()));
        }
    }

    @Override
    public void toNetwork(class_9129 buffer) {
        this.title1.toNetwork(buffer);
        buffer.method_52964(this.recipeId1 != null);
        if (this.recipeId1 != null) {
            buffer.method_10812(this.recipeId1);
        }
        this.title2.toNetwork(buffer);
        buffer.method_52964(this.recipeId2 != null);
        if (this.recipeId2 != null) {
            buffer.method_10812(this.recipeId2);
        }
        this.text.toNetwork(buffer);
        super.toNetwork(buffer);
    }

    @Override
    public boolean matchesQuery(String query) {
        return this.title1.getString().toLowerCase().contains(query) || this.title2.getString().toLowerCase().contains(query) || this.text.getString().toLowerCase().contains(query);
    }

    public record DataHolder(BookTextHolder title1, class_2960 recipeId1, BookTextHolder title2, class_2960 recipeId2, BookTextHolder text) {
    }
}

