/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.bookstate;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookStatesSaveData;
import com.klikli_dev.modonomicon.bookstate.BookVisualStates;
import com.klikli_dev.modonomicon.bookstate.visual.BookVisualState;
import com.klikli_dev.modonomicon.bookstate.visual.CategoryVisualState;
import com.klikli_dev.modonomicon.bookstate.visual.EntryVisualState;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.klikli_dev.modonomicon.networking.RequestSyncBookStatesMessage;
import com.klikli_dev.modonomicon.networking.SyncBookVisualStatesMessage;
import com.klikli_dev.modonomicon.platform.Services;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_3222;
import net.minecraft.class_4284;

public class BookVisualStateManager {
    private static final BookVisualStateManager instance = new BookVisualStateManager();
    public BookStatesSaveData saveData;

    public static BookVisualStateManager get() {
        return instance;
    }

    private BookVisualStates getStateFor(class_1657 player) {
        this.getSaveDataIfNecessary(player);
        return this.saveData.getVisualStates(player.method_5667());
    }

    public BookVisualState getBookStateFor(class_1657 player, Book book) {
        return this.getStateFor(player).getBookState(book);
    }

    public CategoryVisualState getCategoryStateFor(class_1657 player, BookCategory category) {
        return this.getStateFor(player).getCategoryState(category);
    }

    public EntryVisualState getEntryStateFor(class_1657 player, BookEntry entry) {
        return this.getStateFor(player).getEntryState(entry);
    }

    public List<BookAddress> getBookmarksFor(class_1657 player, Book book) {
        return this.getStateFor(player).getBookmarks(book);
    }

    public void setEntryStateFor(class_3222 player, BookEntry entry, EntryVisualState state) {
        this.getStateFor((class_1657)player).setEntryState(entry, state);
        this.saveData.method_80();
    }

    public void setCategoryStateFor(class_3222 player, BookCategory category, CategoryVisualState state) {
        this.getStateFor((class_1657)player).setCategoryState(category, state);
        this.saveData.method_80();
    }

    public void setBookStateFor(class_3222 player, Book book, BookVisualState state) {
        this.getStateFor((class_1657)player).setBookState(book, state);
        this.saveData.method_80();
    }

    public void setBookmarksFor(class_3222 player, Book book, List<BookAddress> bookmarks) {
        this.getStateFor((class_1657)player).setBookmarks(book, bookmarks);
        this.saveData.method_80();
    }

    public void addBookmarkFor(class_1657 player, Book book, BookAddress bookmark) {
        this.getStateFor(player).addBookmark(book, bookmark);
        this.saveData.method_80();
    }

    public boolean removeBookmarkFor(class_1657 player, Book book, BookAddress bookmark) {
        boolean result = this.getStateFor(player).removeBookmark(book, bookmark);
        this.saveData.method_80();
        return result;
    }

    public void syncFor(class_3222 player) {
        Services.NETWORK.sendTo(player, new SyncBookVisualStatesMessage(this.getStateFor((class_1657)player)));
    }

    private void getSaveDataIfNecessary(class_1657 player) {
        if (this.saveData == null) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                this.saveData = (BookStatesSaveData)serverPlayer.method_5682().method_30002().method_17983().method_17924(new class_18.class_8645(BookStatesSaveData::new, BookStatesSaveData::load, class_4284.field_19213), "modonomicon_book_states");
            } else {
                this.saveData = new BookStatesSaveData();
                Services.NETWORK.sendToServer(RequestSyncBookStatesMessage.INSTANCE);
                Modonomicon.LOG.error("Tried to get Modonomicon save data for player on client side, but was not set. This should not happen. Requesting a sync from the server. Please re-open the book in a few seconds to see your progress.");
            }
        }
    }
}

