/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.markdown;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ComponentNodeRendererContext;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ComponentNodeRendererFactory;
import com.klikli_dev.modonomicon.client.gui.book.markdown.CoreComponentNodeRenderer;
import com.klikli_dev.modonomicon.client.gui.book.markdown.LinkRenderer;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ListItemContents;
import com.klikli_dev.modonomicon.client.gui.book.markdown.internal.renderer.ListHolder;
import com.klikli_dev.modonomicon.client.gui.book.markdown.internal.renderer.NodeRendererMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_7225;
import net.minecraft.class_7417;
import org.commonmark.Extension;
import org.commonmark.node.Node;
import org.commonmark.renderer.NodeRenderer;

public class ComponentRenderer {
    private final List<ComponentNodeRendererFactory> nodeRendererFactories;
    private final List<LinkRenderer> linkRenderers;
    private final List<class_5250> components;
    private final boolean renderSoftLineBreaks;
    private final boolean replaceSoftLineBreaksWithSpace;
    private final class_5251 linkColor;
    private class_5250 currentComponent;
    private class_2583 currentStyle;
    private ListHolder listHolder;

    private ComponentRenderer(Builder builder) {
        this.renderSoftLineBreaks = builder.renderSoftLineBreaks;
        this.replaceSoftLineBreaksWithSpace = builder.replaceSoftLineBreaksWithSpace;
        this.linkColor = builder.linkColor;
        this.currentStyle = builder.style;
        this.linkRenderers = builder.linkRenderers;
        this.components = new ArrayList<class_5250>();
        this.currentComponent = class_2561.method_43471((String)"");
        this.nodeRendererFactories = new ArrayList<ComponentNodeRendererFactory>(builder.nodeRendererFactories.size() + 1);
        this.nodeRendererFactories.addAll(builder.nodeRendererFactories);
        this.nodeRendererFactories.add(CoreComponentNodeRenderer::new);
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<class_5250> render(Node node, Book book, class_7225.class_7874 provider) {
        RendererContext context = new RendererContext(book, provider);
        context.render(node);
        context.cleanupPostRender();
        return context.getComponents();
    }

    public static class Builder {
        private final List<LinkRenderer> linkRenderers = new ArrayList<LinkRenderer>();
        private final List<ComponentNodeRendererFactory> nodeRendererFactories = new ArrayList<ComponentNodeRendererFactory>();
        private boolean renderSoftLineBreaks = false;
        private boolean replaceSoftLineBreaksWithSpace = true;
        private class_5251 linkColor = class_5251.method_27717((int)0x5555FF);
        private class_2583 style = class_2583.field_24360;

        public ComponentRenderer build() {
            return new ComponentRenderer(this);
        }

        public Builder renderSoftLineBreaks(boolean renderSoftLineBreaks) {
            this.renderSoftLineBreaks = renderSoftLineBreaks;
            return this;
        }

        public Builder replaceSoftLineBreaksWithSpace(boolean replaceSoftLineBreaksWithSpace) {
            this.replaceSoftLineBreaksWithSpace = replaceSoftLineBreaksWithSpace;
            return this;
        }

        public Builder linkColor(class_5251 linkColor) {
            this.linkColor = linkColor;
            return this;
        }

        public Builder style(class_2583 style) {
            this.style = style;
            return this;
        }

        public Builder nodeRendererFactory(ComponentNodeRendererFactory nodeRendererFactory) {
            this.nodeRendererFactories.add(nodeRendererFactory);
            return this;
        }

        public Builder extensions(Iterable<? extends Extension> extensions) {
            for (Extension extension : extensions) {
                if (!(extension instanceof ComponentRendererExtension)) continue;
                ComponentRendererExtension componentRendererExtension = (ComponentRendererExtension)extension;
                componentRendererExtension.extend(this);
            }
            return this;
        }

        public Builder linkRenderers(Collection<? extends LinkRenderer> linkRenderers) {
            this.linkRenderers.addAll(linkRenderers);
            return this;
        }
    }

    private class RendererContext
    implements ComponentNodeRendererContext {
        private final NodeRendererMap nodeRendererMap = new NodeRendererMap();
        private final Book book;
        private final class_7225.class_7874 provider;

        private RendererContext(Book book, class_7225.class_7874 provider) {
            this.book = book;
            this.provider = provider;
            for (int i = ComponentRenderer.this.nodeRendererFactories.size() - 1; i >= 0; --i) {
                ComponentNodeRendererFactory nodeRendererFactory = ComponentRenderer.this.nodeRendererFactories.get(i);
                NodeRenderer nodeRenderer = nodeRendererFactory.create(this);
                this.nodeRendererMap.add(nodeRenderer);
            }
        }

        @Override
        public class_5250 getCurrentComponent() {
            return ComponentRenderer.this.currentComponent;
        }

        @Override
        public void setCurrentComponent(class_5250 component) {
            ComponentRenderer.this.currentComponent = component;
        }

        @Override
        public List<class_5250> getComponents() {
            return ComponentRenderer.this.components;
        }

        @Override
        public ListHolder getListHolder() {
            return ComponentRenderer.this.listHolder;
        }

        @Override
        public void setListHolder(ListHolder listHolder) {
            ComponentRenderer.this.listHolder = listHolder;
        }

        @Override
        public class_2583 getCurrentStyle() {
            return ComponentRenderer.this.currentStyle;
        }

        @Override
        public void setCurrentStyle(class_2583 style) {
            ComponentRenderer.this.currentStyle = style;
        }

        @Override
        public void render(Node node) {
            this.nodeRendererMap.render(node);
        }

        @Override
        public void cleanupPostRender() {
            if (!this.isEmptyComponent()) {
                this.finalizeCurrentComponent();
            }
        }

        @Override
        public boolean isEmptyComponent() {
            return ((class_2588)this.getCurrentComponent().method_10851()).method_11022().isEmpty() && this.getCurrentComponent().method_10855().isEmpty();
        }

        @Override
        public void finalizeCurrentComponent() {
            this.getComponents().add(this.getCurrentComponent());
            this.setCurrentComponent(this.getListHolder() == null ? class_2561.method_43471((String)"") : class_5250.method_43477((class_7417)new ListItemContents(this.getListHolder(), "")));
        }

        @Override
        public boolean getRenderSoftLineBreaks() {
            return ComponentRenderer.this.renderSoftLineBreaks;
        }

        @Override
        public boolean getReplaceSoftLineBreaksWithSpace() {
            return ComponentRenderer.this.replaceSoftLineBreaksWithSpace;
        }

        @Override
        public class_5251 getLinkColor() {
            return ComponentRenderer.this.linkColor;
        }

        @Override
        public List<LinkRenderer> getLinkRenderers() {
            return ComponentRenderer.this.linkRenderers;
        }

        @Override
        public Book getBook() {
            return this.book;
        }

        @Override
        public class_7225.class_7874 getProvider() {
            return this.provider;
        }
    }

    public static interface ComponentRendererExtension
    extends Extension {
        public void extend(Builder var1);
    }
}

