/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.render.page;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.client.gui.book.BookContentRenderer;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryScreen;
import com.klikli_dev.modonomicon.client.gui.book.markdown.MarkdownComponentRenderUtils;
import com.klikli_dev.modonomicon.client.render.page.PageWithTextRenderer;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.util.GuiGraphicsExt;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public abstract class BookPageRenderer<T extends BookPage> {
    public int left;
    public int top;
    protected T page;
    protected BookEntryScreen parentScreen;
    protected class_310 mc;
    protected class_327 font;
    private List<class_4185> buttons = new ArrayList<class_4185>();

    public BookPageRenderer(T page) {
        this.page = page;
    }

    public static float getBookTextHolderScaleForRenderSize(BookTextHolder text, class_327 font, int width, int height) {
        if (width <= 0 || height <= 0) {
            return 1.0f;
        }
        if (!(text instanceof RenderedBookTextHolder)) {
            return 1.0f;
        }
        RenderedBookTextHolder renderedText = (RenderedBookTextHolder)text;
        float cachedScale = BookDataManager.Client.get().getScale(text, width, height);
        if (cachedScale > -1.0f) {
            return cachedScale;
        }
        List<class_5250> components = renderedText.getRenderedText();
        float granularity = 0.01f;
        float scale = 1.0f;
        float totalHeight = 0.0f;
        do {
            int totalLines = 0;
            for (class_5250 component : components) {
                List<class_5481> wrapped = MarkdownComponentRenderUtils.wrapComponents(component, (int)((float)width / scale), (int)((float)(width - 10) / scale), font);
                totalLines += wrapped.size();
            }
            Objects.requireNonNull(font);
            totalHeight = (float)(totalLines * 9) * scale;
            scale -= granularity;
        } while (totalHeight > (float)height);
        BookDataManager.Client.get().putScale(text, width, height, scale);
        return scale;
    }

    public static void renderBookTextHolder(class_332 guiGraphics, BookTextHolder text, class_327 font, int x, int y, int width, int height) {
        if (text.hasComponent()) {
            for (class_5481 formattedcharsequence : font.method_1728((class_5348)text.getComponent(), width)) {
                guiGraphics.method_51430(font, formattedcharsequence, x, y, 0, false);
                Objects.requireNonNull(font);
                y += 9;
            }
        } else if (text instanceof RenderedBookTextHolder) {
            RenderedBookTextHolder renderedText = (RenderedBookTextHolder)text;
            List<class_5250> components = renderedText.getRenderedText();
            float scale = BookPageRenderer.getBookTextHolderScaleForRenderSize(text, font, width, height);
            guiGraphics.method_51448().method_22903();
            if (scale < 1.0f) {
                guiGraphics.method_51448().method_46416((float)x - (float)x * scale, (float)y - (float)y * scale, 0.0f);
                guiGraphics.method_51448().method_22905(scale, scale, scale);
            }
            float renderY = y;
            for (class_5250 component : components) {
                List<class_5481> wrapped = MarkdownComponentRenderUtils.wrapComponents(component, (int)((float)width / scale), (int)((float)(width - 10) / scale), font);
                for (class_5481 formattedcharsequence : wrapped) {
                    GuiGraphicsExt.drawString(guiGraphics, font, formattedcharsequence, (float)x, renderY, 0, false);
                    Objects.requireNonNull(font);
                    renderY += 9.0f;
                }
            }
            guiGraphics.method_51448().method_22909();
        } else {
            Modonomicon.LOG.warn("BookTextHolder with String {} has no component, but is not rendered to markdown either.", (Object)text.getString());
        }
    }

    public void onBeginDisplayPage(BookEntryScreen parentScreen, int left, int top) {
        this.parentScreen = parentScreen;
        this.mc = class_310.method_1551();
        this.font = this.mc.field_1772;
        this.left = left;
        this.top = top;
        this.buttons = new ArrayList<class_4185>();
    }

    public T getPage() {
        return this.page;
    }

    public void onEndDisplayPage(BookEntryScreen parentScreen) {
        parentScreen.removeRenderableWidgets(this.buttons);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        return false;
    }

    @Deprecated
    public void renderBookTextHolder(class_332 guiGraphics, BookTextHolder text, int x, int y, int width) {
        int textY = 0;
        BookPageRenderer bookPageRenderer = this;
        if (bookPageRenderer instanceof PageWithTextRenderer) {
            PageWithTextRenderer pageWithTextRenderer = (PageWithTextRenderer)((Object)bookPageRenderer);
            textY = pageWithTextRenderer.getTextY();
        }
        BookPageRenderer.renderBookTextHolder(guiGraphics, text, this.font, x, y, width, 155 - textY);
    }

    public void renderBookTextHolder(class_332 guiGraphics, BookTextHolder text, int x, int y, int width, int height) {
        height += this.parentScreen.getBook().getBookTextOffsetHeight();
        width += this.parentScreen.getBook().getBookTextOffsetWidth();
        BookPageRenderer.renderBookTextHolder(guiGraphics, text, this.font, x += this.parentScreen.getBook().getBookTextOffsetX(), y += this.parentScreen.getBook().getBookTextOffsetY(), width -= this.parentScreen.getBook().getBookTextOffsetX(), height -= this.parentScreen.getBook().getBookTextOffsetY());
    }

    public void renderTitle(class_332 guiGraphics, BookTextHolder title, boolean showTitleSeparator, int x, int y) {
        guiGraphics.method_51448().method_22903();
        if (title instanceof RenderedBookTextHolder) {
            RenderedBookTextHolder renderedTitle = (RenderedBookTextHolder)title;
            class_5481 formattedCharSequence = class_5481.method_30755(renderedTitle.getRenderedText().stream().map(class_2561::method_30937).toList());
            float scale = Math.min(1.0f, 120.0f / (float)this.font.method_30880(formattedCharSequence));
            if (scale < 1.0f) {
                guiGraphics.method_51448().method_46416(0.0f, (float)y - (float)y * scale, 0.0f);
                guiGraphics.method_51448().method_22905(scale, scale, scale);
            }
            this.drawCenteredStringNoShadow(guiGraphics, formattedCharSequence, x, y, 0, scale);
        } else if (title.hasComponent()) {
            class_2960 font = BookDataManager.Client.get().safeFont(((BookPage)this.page).getBook().getFont());
            class_5250 titleComponent = class_2561.method_43473().method_10852(title.getComponent()).method_27694(s -> s.method_27704(font));
            float scale = Math.min(1.0f, 120.0f / (float)this.font.method_30880(titleComponent.method_30937()));
            if (scale < 1.0f) {
                guiGraphics.method_51448().method_46416(0.0f, (float)y - (float)y * scale, 0.0f);
                guiGraphics.method_51448().method_22905(scale, scale, scale);
            }
            this.drawCenteredStringNoShadow(guiGraphics, titleComponent.method_30937(), x, y, 0, scale);
        } else {
            BookErrorManager.get().setTo((BookPage)this.page);
            BookErrorManager.get().error("Non-markdown title has no component.");
            BookErrorManager.get().getContextHelper().reset();
            BookErrorManager.get().setCurrentBookId(null);
        }
        guiGraphics.method_51448().method_22909();
        if (showTitleSeparator) {
            BookContentRenderer.drawTitleSeparator(guiGraphics, ((BookPage)this.page).getBook(), x, y + 12);
        }
    }

    public abstract void render(class_332 var1, int var2, int var3, float var4);

    public void drawCenteredStringNoShadow(class_332 guiGraphics, class_5481 s, int x, int y, int color, float scale) {
        float f = (float)x - (float)this.font.method_30880(s) * scale / 2.0f;
        float f2 = y;
        Objects.requireNonNull(this.font);
        GuiGraphicsExt.drawString(guiGraphics, this.font, s, f, f2 + 9.0f * (1.0f - scale), color, false);
    }

    public void drawCenteredStringNoShadow(class_332 guiGraphics, String s, int x, int y, int color, float scale) {
        float f = (float)x - (float)this.font.method_1727(s) * scale / 2.0f;
        float f2 = y;
        Objects.requireNonNull(this.font);
        GuiGraphicsExt.drawString(guiGraphics, this.font, s, f, f2 + 9.0f * (1.0f - scale), color, false);
    }

    public void drawWrappedStringNoShadow(class_332 guiGraphics, class_2561 s, int x, int y, int color, int width) {
        for (class_5481 formattedcharsequence : this.font.method_1728((class_5348)s, width)) {
            Objects.requireNonNull(this.font);
            guiGraphics.method_51430(this.font, formattedcharsequence, x, y + 9, color, false);
            Objects.requireNonNull(this.font);
            y += 9;
        }
    }

    @Nullable
    public class_2583 getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        return null;
    }

    protected void addButton(class_4185 button) {
        button.method_46421(button.method_46426() + this.parentScreen.getBookLeft() + this.left);
        button.method_46419(button.method_46427() + this.parentScreen.getBookTop() + this.top);
        this.buttons.add(button);
        this.parentScreen.method_37063(button);
    }

    @Nullable
    protected class_2583 getClickedComponentStyleAtForTitle(BookTextHolder title, int x, int y, double pMouseX, double pMouseY) {
        block8: {
            block7: {
                if (!(pMouseY > (double)y)) break block7;
                Objects.requireNonNull(this.font);
                if (pMouseY < (double)(y + 9)) break block8;
            }
            return null;
        }
        if (title instanceof RenderedBookTextHolder) {
            RenderedBookTextHolder renderedTitle = (RenderedBookTextHolder)title;
            class_5481 formattedCharSequence = class_5481.method_30755(renderedTitle.getRenderedText().stream().map(class_2561::method_30937).toList());
            if (pMouseX < (double)(x -= this.font.method_30880(formattedCharSequence) / 2)) {
                return null;
            }
            return this.font.method_27527().method_30876(formattedCharSequence, (int)pMouseX - x);
        }
        if (title.getComponent() == null) {
            Modonomicon.LOG.warn("Title has no component: {}", (Object)title);
            return null;
        }
        class_5481 formattedCharSequence = title.getComponent().method_30937();
        if (pMouseX < (double)(x -= this.font.method_30880(formattedCharSequence) / 2)) {
            return null;
        }
        return this.font.method_27527().method_30876(formattedCharSequence, (int)pMouseX - x);
    }

    @Deprecated
    @Nullable
    protected class_2583 getClickedComponentStyleAtForTextHolder(BookTextHolder text, int x, int y, int width, double pMouseX, double pMouseY) {
        int textY = 0;
        BookPageRenderer bookPageRenderer = this;
        if (bookPageRenderer instanceof PageWithTextRenderer) {
            PageWithTextRenderer pageWithTextRenderer = (PageWithTextRenderer)((Object)bookPageRenderer);
            textY = pageWithTextRenderer.getTextY();
        }
        return this.getClickedComponentStyleAtForTextHolder(text, x, y, width, 155 - textY, pMouseX, pMouseY);
    }

    @Nullable
    protected class_2583 getClickedComponentStyleAtForTextHolder(BookTextHolder text, int x, int y, int width, int height, double pMouseX, double pMouseY) {
        block7: {
            block6: {
                if (!text.hasComponent()) break block6;
                for (class_5481 formattedcharsequence : this.font.method_1728((class_5348)text.getComponent(), width)) {
                    if (pMouseY > (double)y) {
                        Objects.requireNonNull(this.font);
                        if (pMouseY < (double)(y + 9)) {
                            return this.font.method_27527().method_30876(formattedcharsequence, (int)pMouseX - x);
                        }
                    }
                    Objects.requireNonNull(this.font);
                    y += 9;
                }
                break block7;
            }
            if (!(text instanceof RenderedBookTextHolder)) break block7;
            RenderedBookTextHolder renderedText = (RenderedBookTextHolder)text;
            float scale = BookPageRenderer.getBookTextHolderScaleForRenderSize(text, this.font, width, height);
            float currentY = y;
            List<class_5250> components = renderedText.getRenderedText();
            for (class_5250 component : components) {
                List<class_5481> wrapped = MarkdownComponentRenderUtils.wrapComponents(component, (int)((float)width / scale), (int)((float)(width - 10) / scale), this.font);
                for (class_5481 formattedcharsequence : wrapped) {
                    float minY = currentY;
                    Objects.requireNonNull(this.font);
                    float maxY = currentY + 9.0f * scale;
                    if (pMouseY > (double)minY && pMouseY < (double)maxY) {
                        return this.font.method_27527().method_30876(formattedcharsequence, (int)((pMouseX - (double)x) / (double)scale));
                    }
                    Objects.requireNonNull(this.font);
                    currentY += 9.0f * scale;
                }
            }
        }
        return null;
    }
}

