/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.klikli_dev.modonomicon.networking.Message;
import com.klikli_dev.modonomicon.networking.SyncMultiblockDataMessage;
import com.klikli_dev.modonomicon.platform.Services;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7225;

public class MultiblockDataManager
extends class_4309 {
    public static final String FOLDER = "modonomicon/multiblocks";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final MultiblockDataManager instance = new MultiblockDataManager();
    private Map<class_2960, Multiblock> multiblocks = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
    private boolean loaded;
    private class_7225.class_7874 registries;

    private MultiblockDataManager() {
        super(GSON, FOLDER);
    }

    public static MultiblockDataManager get() {
        return instance;
    }

    public void registries(class_7225.class_7874 registries) {
        this.registries = registries;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public Multiblock getMultiblock(class_2960 id) {
        return this.multiblocks.get(id);
    }

    public Map<class_2960, Multiblock> getMultiblocks() {
        return this.multiblocks;
    }

    public Message getSyncMessage() {
        return new SyncMultiblockDataMessage(this.multiblocks);
    }

    public void onDatapackSyncPacket(SyncMultiblockDataMessage message) {
        this.preLoad();
        this.multiblocks = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap(message.multiblocks));
        this.onLoadingComplete();
    }

    public void onDatapackSync(class_3222 player) {
        Message syncMessage = this.getSyncMessage();
        Services.NETWORK.sendToSplit(player, syncMessage);
    }

    public void preLoad() {
        this.loaded = false;
        this.multiblocks.clear();
    }

    protected void onLoadingComplete() {
        this.loaded = true;
    }

    protected void apply(Map<class_2960, JsonElement> content, class_3300 pResourceManager, class_3695 pProfiler) {
        this.preLoad();
        for (Map.Entry<class_2960, JsonElement> entry : content.entrySet()) {
            JsonObject json = class_3518.method_15295((JsonElement)entry.getValue(), (String)"multiblock json file");
            class_2960 type = class_2960.method_12829((String)class_3518.method_15265((JsonObject)json, (String)"type"));
            Multiblock multiblock = LoaderRegistry.getMultiblockJsonLoader(type).fromJson(json, this.registries);
            multiblock.setId(entry.getKey());
            this.multiblocks.put(multiblock.getId(), multiblock);
        }
        this.onLoadingComplete();
    }
}

