/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.integration.jei;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.integration.jei.ModonomiconJeiIntegration;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.klikli_dev.modonomicon.platform.Services;
import com.klikli_dev.modonomicon.registry.DataComponentRegistry;
import com.klikli_dev.modonomicon.registry.ItemRegistry;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class ModonomiconJeiIntegrationImpl
implements ModonomiconJeiIntegration {
    @Override
    public boolean isLoaded() {
        return Services.PLATFORM.isModLoaded("jei");
    }

    @Override
    public boolean isRecipesGuiOpen() {
        if (this.isLoaded()) {
            return ModonomiconJeiHelper.isJEIRecipesGuiOpen();
        }
        Modonomicon.LOG.warn("Attempted check if JEI recipes GUI is open without JEI installed!");
        return false;
    }

    @Override
    public void showRecipe(class_1799 stack) {
        if (this.isLoaded()) {
            ModonomiconJeiHelper.showRecipe(stack);
        } else {
            Modonomicon.LOG.warn("Attempted to show JEI recipe for {} without JEI installed!", (Object)class_7923.field_41178.method_10221((Object)stack.method_7909()));
        }
    }

    @Override
    public void showUses(class_1799 stack) {
        if (this.isLoaded()) {
            ModonomiconJeiHelper.showUses(stack);
        } else {
            Modonomicon.LOG.warn("Attempted to show JEI usages for {} without JEI installed!", (Object)class_7923.field_41178.method_10221((Object)stack.method_7909()));
        }
    }

    public static class ModonomiconJeiHelper {
        public static void showRecipe(class_1799 stack) {
            IFocus focus = ModonomiconJeiPlugin.jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
            ModonomiconJeiPlugin.jeiRuntime.getRecipesGui().show(focus);
        }

        public static void showUses(class_1799 stack) {
            IFocus focus = ModonomiconJeiPlugin.jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.INPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
            ModonomiconJeiPlugin.jeiRuntime.getRecipesGui().show(focus);
        }

        public static boolean isJEIRecipesGuiOpen() {
            return ClientServices.GUI.getCurrentScreen() instanceof IRecipesGui;
        }
    }

    @JeiPlugin
    public static class ModonomiconJeiPlugin
    implements IModPlugin {
        private static final class_2960 UID = class_2960.method_60655((String)"modonomicon", (String)"modonomicon");
        private static IJeiRuntime jeiRuntime;

        @NotNull
        public class_2960 getPluginUid() {
            return UID;
        }

        public void onRuntimeAvailable(@NotNull IJeiRuntime jeiRuntime) {
            ModonomiconJeiPlugin.jeiRuntime = jeiRuntime;
        }

        public void registerItemSubtypes(@NotNull ISubtypeRegistration registration) {
            registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ItemRegistry.MODONOMICON.get(), (stack, context) -> {
                if (!stack.method_57826(DataComponentRegistry.BOOK_ID.get())) {
                    return "";
                }
                return ((class_2960)stack.method_57824(DataComponentRegistry.BOOK_ID.get())).toString();
            });
        }
    }
}

