/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import com.klikli_dev.modonomicon.bookstate.visual.BookVisualState;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.networking.Message;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public class SaveBookStateMessage
implements Message {
    public static final class_8710.class_9154<SaveBookStateMessage> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"modonomicon", (String)"save_book_state"));
    public static final class_9139<class_9129, SaveBookStateMessage> STREAM_CODEC = class_8710.method_56484(SaveBookStateMessage::encode, SaveBookStateMessage::new);
    public Book book;
    class_2960 openCategory = null;

    public SaveBookStateMessage(Book book, BookVisualState state) {
        this(book, state.openCategory);
    }

    public SaveBookStateMessage(Book book, class_2960 openCategory) {
        this.book = book;
        this.openCategory = openCategory;
    }

    public SaveBookStateMessage(class_9129 buf) {
        this.decode(buf);
    }

    private void encode(class_9129 buf) {
        buf.method_10812(this.book.getId());
        buf.method_52964(this.openCategory != null);
        if (this.openCategory != null) {
            buf.method_10812(this.openCategory);
        }
    }

    private void decode(class_9129 buf) {
        this.book = BookDataManager.get().getBook(buf.method_10810());
        if (buf.readBoolean()) {
            this.openCategory = buf.method_10810();
        }
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, class_3222 player) {
        BookVisualState currentState = BookVisualStateManager.get().getBookStateFor((class_1657)player, this.book);
        currentState.openCategory = this.openCategory;
        BookVisualStateManager.get().setBookStateFor(player, this.book, currentState);
        BookVisualStateManager.get().syncFor(player);
    }
}

