/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.advancement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_174;
import net.minecraft.class_175;
import net.minecraft.class_179;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_185;
import net.minecraft.class_1860;
import net.minecraft.class_189;
import net.minecraft.class_1935;
import net.minecraft.class_1959;
import net.minecraft.class_2062;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2090;
import net.minecraft.class_2119;
import net.minecraft.class_2135;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3195;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8779;
import net.minecraft.class_8782;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.betterx.bclib.api.v2.advancement.Display;
import org.betterx.bclib.complexmaterials.WoodenComplexMaterial;
import org.betterx.bclib.complexmaterials.set.wood.WoodSlots;
import org.betterx.wover.complex.api.equipment.ArmorSlot;
import org.betterx.wover.complex.api.equipment.EquipmentSet;
import org.betterx.wover.complex.api.equipment.ToolSlot;

public class AdvancementManager {
    private static final Map<class_2960, class_161.class_162> ADVANCEMENTS = new LinkedHashMap<class_2960, class_161.class_162>();

    public static void register(class_2960 id, class_161.class_162 builder) {
        ADVANCEMENTS.put(id, builder);
    }

    public static void registerAllDataGen(List<String> namespaces, Consumer<class_8779> consumer) {
        class_8779 ROOT_RECIPE = class_161.class_162.method_707().method_705("impossible", class_174.field_1184.method_53699((class_184)new class_2062.class_2063())).method_695(class_5797.field_39377);
        HashMap<class_2960, class_8779> BUILT = new HashMap<class_2960, class_8779>();
        for (Map.Entry<class_2960, class_161.class_162> entry : ADVANCEMENTS.entrySet()) {
            class_2960 loc = entry.getKey();
            if (namespaces != null && !namespaces.contains(loc.method_12836())) continue;
            class_161.class_162 builder = entry.getValue();
            class_8779 adv = builder.method_695(loc);
            BUILT.put(loc, adv);
            consumer.accept(adv);
        }
    }

    public static class DisplayBuilder {
        Builder base;
        final Display display = new Display();

        DisplayBuilder reset(Builder base) {
            this.base = base;
            this.display.reset();
            return this;
        }

        public DisplayBuilder background(class_2960 value) {
            this.display.background = value;
            return this;
        }

        public DisplayBuilder icon(class_1935 value) {
            this.display.icon = new class_1799(value);
            return this;
        }

        public DisplayBuilder icon(class_1799 value) {
            this.display.icon = value;
            return this;
        }

        public DisplayBuilder title(class_2561 value) {
            this.display.title = value;
            return this;
        }

        public DisplayBuilder description(class_2561 value) {
            this.display.description = value;
            return this;
        }

        public DisplayBuilder showToast() {
            this.display.showToast = true;
            return this;
        }

        public DisplayBuilder hideToast() {
            this.display.showToast = false;
            return this;
        }

        public DisplayBuilder hidden() {
            this.display.hidden = true;
            return this;
        }

        public DisplayBuilder visible() {
            this.display.hidden = false;
            return this;
        }

        public DisplayBuilder announceToChat() {
            this.display.announceChat = true;
            return this;
        }

        public DisplayBuilder hideFromChat() {
            this.display.announceChat = false;
            return this;
        }

        public DisplayBuilder frame(class_189 type) {
            this.display.frame = type;
            return this;
        }

        public DisplayBuilder challenge() {
            return this.frame(class_189.field_1250);
        }

        public DisplayBuilder task() {
            return this.frame(class_189.field_1254);
        }

        public DisplayBuilder goal() {
            return this.frame(class_189.field_1249);
        }

        public Builder endDisplay() {
            this.base.display(this.display.build());
            return this.base;
        }
    }

    public static class Builder {
        private static final ThreadLocal<DisplayBuilder> DISPLAY_BUILDER = ThreadLocal.withInitial(DisplayBuilder::new);
        private static final class_2960 RECIPES_ROOT = class_5797.field_39377;
        private final class_161.class_162 builder = new OrderedBuilder();
        private final class_2960 id;
        private final AdvancementType type;
        private boolean canBuild = true;

        private Builder(class_2960 id, AdvancementType type) {
            class_2960 ID;
            if (type == AdvancementType.RECIPE_DECORATIONS) {
                ID = class_2960.method_60655((String)id.method_12836(), (String)("recipes/decorations/" + id.method_12832()));
                this.builder.method_708(RECIPES_ROOT);
            } else if (type == AdvancementType.RECIPE_TOOL) {
                ID = class_2960.method_60655((String)id.method_12836(), (String)("recipes/tools/" + id.method_12832()));
                this.builder.method_708(RECIPES_ROOT);
            } else {
                ID = id;
            }
            this.id = ID;
            this.type = type;
        }

        public static Builder createEmptyCopy(Builder builder) {
            return new Builder(builder.id, builder.type);
        }

        public static Builder create(class_2960 id) {
            return new Builder(id, AdvancementType.REGULAR);
        }

        public static Builder create(class_2960 id, AdvancementType type) {
            return new Builder(id, type);
        }

        public static Builder create(class_1792 icon) {
            return Builder.create((class_1935)icon, AdvancementType.REGULAR);
        }

        public static Builder create(class_1799 icon) {
            return Builder.create(icon, AdvancementType.REGULAR);
        }

        public static Builder create(class_1935 icon, AdvancementType type) {
            return Builder.create(new class_1799(icon), type);
        }

        public static Builder create(class_1799 icon, AdvancementType type) {
            return Builder.create(icon, type, (DisplayBuilder displayBuilder) -> {});
        }

        public static Builder create(class_1792 icon, AdvancementType type, Consumer<DisplayBuilder> displayAdapter) {
            return Builder.create(new class_1799((class_1935)icon), type, displayAdapter);
        }

        public static Builder create(class_1799 icon, AdvancementType type, Consumer<DisplayBuilder> displayAdapter) {
            class_2960 id = class_7923.field_41178.method_10221((Object)icon.method_7909());
            boolean canBuild = true;
            if (id == null || icon.method_31574(class_1802.field_8162)) {
                canBuild = false;
                id = class_7923.field_41178.method_10137();
            }
            String baseName = "advancements." + id.method_12836() + "." + id.method_12832() + ".";
            Builder b = new Builder(id, type);
            DisplayBuilder displayBuilder = b.startDisplay(icon, (class_2561)class_2561.method_43471((String)(baseName + "title")), (class_2561)class_2561.method_43471((String)(baseName + "description")));
            if (displayAdapter != null) {
                displayAdapter.accept(displayBuilder);
            }
            b = displayBuilder.endDisplay();
            b.canBuild = canBuild;
            return b;
        }

        public static <C extends class_9695, T extends class_8786<class_1860<C>>> Builder createRecipe(T recipe, AdvancementType type) {
            class_1792 item = recipe.comp_1933().method_8110((class_7225.class_7874)class_310.method_1551().field_1687.method_30349()).method_7909();
            return Builder.create(item, type, (DisplayBuilder displayBuilder) -> displayBuilder.hideToast().hideFromChat()).addRecipeUnlockCriterion("has_the_recipe", recipe).startReward().addRecipe(recipe.comp_1932()).endReward().requirements(class_8782.class_8797.field_1257);
        }

        public Builder parent(class_8779 advancement) {
            this.builder.method_701(advancement);
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder parent(class_2960 resourceLocation) {
            this.builder.method_708(resourceLocation);
            return this;
        }

        public DisplayBuilder startDisplay(class_1935 icon) {
            String baseName = "advancements." + this.id.method_12836() + "." + this.id.method_12832() + ".";
            return this.startDisplay(icon, (class_2561)class_2561.method_43471((String)(baseName + "title")), (class_2561)class_2561.method_43471((String)(baseName + "description")));
        }

        public DisplayBuilder startDisplay(class_1935 icon, class_2561 title, class_2561 description) {
            return this.startDisplay(new class_1799(icon), title, description);
        }

        public DisplayBuilder startDisplay(class_1799 icon, class_2561 title, class_2561 description) {
            if (icon == null) {
                this.canBuild = false;
            } else {
                class_2960 id = class_7923.field_41178.method_10221((Object)icon.method_7909());
                if (id == null) {
                    this.canBuild = false;
                }
            }
            DisplayBuilder dp = DISPLAY_BUILDER.get().reset(this);
            return dp.icon(icon).title(title).description(description);
        }

        Builder display(class_185 displayInfo) {
            this.builder.method_693(displayInfo);
            return this;
        }

        public Builder awardRecipe(class_1935 ... items) {
            RewardsBuilder rewardBuilder = this.startReward();
            for (class_1935 item : items) {
                class_2960 id = class_7923.field_41178.method_10221((Object)item.method_8389());
                if (id == null) continue;
                rewardBuilder.addRecipe(id);
            }
            return rewardBuilder.endReward();
        }

        public RewardsBuilder startReward() {
            return new RewardsBuilder(this);
        }

        public Builder rewards(class_170 advancementRewards) {
            this.builder.method_706(advancementRewards);
            return this;
        }

        public Builder rewardXP(int xp) {
            return this.rewards(class_170.class_171.method_750((int)500).method_751());
        }

        public <T extends class_184> Builder addCriterion(String string, class_179<T> criterionTrigger, T criterionTriggerInstance) {
            this.builder.method_705(string, new class_175(criterionTrigger, criterionTriggerInstance));
            return this;
        }

        public Builder addCriterion(String string, class_175 criterion) {
            this.builder.method_705(string, criterion);
            return this;
        }

        public Builder addAtStructureCriterion(String name, class_6880<class_3195> structure) {
            return this.addCriterion(name, class_2135.class_2137.method_43137((class_2090.class_2091)class_2090.class_2091.method_53183(structure)));
        }

        public <C extends class_9695, T extends class_1860<C>> Builder addRecipeUnlockCriterion(String name, class_8786<T> recipe) {
            return this.addCriterion(name, class_2119.method_27847((class_2960)recipe.comp_1932()));
        }

        public Builder addInventoryChangedCriterion(String name, class_1935 ... items) {
            return this.addCriterion(name, class_2066.class_2068.method_8959((class_1935[])items));
        }

        public Builder addInventoryChangedAnyCriterion(String name, class_1935 ... items) {
            class_175 t = class_2066.class_2068.method_53160((class_2073.class_2074[])new class_2073.class_2074[]{class_2073.class_2074.method_8973().method_8977(items)});
            return this.addCriterion(name, t);
        }

        public Builder addInventoryChangedCriterion(String name, class_6862<class_1792> tag) {
            class_175 t = class_2066.class_2068.method_53160((class_2073.class_2074[])new class_2073.class_2074[]{class_2073.class_2074.method_8973().method_8975(tag)});
            return this.addCriterion(name, t);
        }

        public Builder addEquipmentSetSlotCriterion(EquipmentSet set, ArmorSlot slot) {
            return this.addInventoryChangedCriterion(set.baseName + "_" + String.valueOf(slot), new class_1935[]{set.get(slot)});
        }

        public Builder addEquipmentSetSlotCriterion(EquipmentSet set, ToolSlot slot) {
            return this.addInventoryChangedCriterion(set.baseName + "_" + String.valueOf(slot), new class_1935[]{set.get(slot)});
        }

        public Builder addArmorSetCriterion(EquipmentSet set) {
            return this.addEquipmentSetSlotCriterion(set, ArmorSlot.HELMET_SLOT).addEquipmentSetSlotCriterion(set, ArmorSlot.CHESTPLATE_SLOT).addEquipmentSetSlotCriterion(set, ArmorSlot.LEGGINGS_SLOT).addEquipmentSetSlotCriterion(set, ArmorSlot.BOOTS_SLOT);
        }

        public Builder addToolSetCriterion(EquipmentSet set) {
            return this.addEquipmentSetSlotCriterion(set, ToolSlot.PICKAXE_SLOT).addEquipmentSetSlotCriterion(set, ToolSlot.AXE_SLOT).addEquipmentSetSlotCriterion(set, ToolSlot.SHOVEL_SLOT).addEquipmentSetSlotCriterion(set, ToolSlot.SWORD_SLOT).addEquipmentSetSlotCriterion(set, ToolSlot.HOE_SLOT);
        }

        public Builder addWoodCriterion(WoodenComplexMaterial mat) {
            return this.addInventoryChangedAnyCriterion("got_" + mat.getBaseName(), new class_1935[]{mat.getBlock(WoodSlots.LOG), mat.getBlock(WoodSlots.BARK), mat.getBlock(WoodSlots.PLANKS)});
        }

        public Builder addVisitBiomesCriterion(List<class_6880<class_1959>> list) {
            for (class_6880<class_1959> holder : list) {
                this.addCriterion(((class_5321)holder.method_40230().orElseThrow()).method_29177().toString(), class_2135.class_2137.method_43137((class_2090.class_2091)class_2090.class_2091.method_53180(holder)));
            }
            return this;
        }

        public Builder requireAll() {
            this.builder.method_704(class_8782.class_8797.field_16882);
            return this;
        }

        public Builder requireOne() {
            this.builder.method_704(class_8782.class_8797.field_1257);
            return this;
        }

        public Builder requirements(class_8782.class_8797 requirementsStrategy) {
            this.builder.method_704(requirementsStrategy);
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder requirements(String[][] strings) {
            return this.requirements(Arrays.stream(strings).map(Arrays::asList).map(ArrayList::new).collect(Collectors.toList()));
        }

        public Builder requirements(List<List<String>> strings) {
            this.builder.method_34884(new class_8782(strings));
            return this;
        }

        public class_2960 build() {
            AdvancementManager.register(this.id, this.builder);
            return this.id;
        }
    }

    public static enum AdvancementType {
        REGULAR,
        RECIPE_DECORATIONS,
        RECIPE_TOOL;

    }

    public static class RewardsBuilder {
        private final Builder calle;
        private final class_170.class_171 builder = new class_170.class_171();

        private RewardsBuilder(Builder calle) {
            this.calle = calle;
        }

        public RewardsBuilder addExperience(int i) {
            this.builder.method_749(i);
            return this;
        }

        public RewardsBuilder addLootTable(class_5321<class_52> resourceLocation) {
            this.builder.method_34900(resourceLocation);
            return this;
        }

        public RewardsBuilder addRecipe(class_2960 resourceLocation) {
            this.builder.method_752(resourceLocation);
            return this;
        }

        public RewardsBuilder runs(class_2960 resourceLocation) {
            this.builder.method_34902(resourceLocation);
            return this;
        }

        public Builder endReward() {
            this.calle.rewards(this.builder.method_751());
            return this.calle;
        }
    }

    static class OrderedBuilder
    extends class_161.class_162 {
        OrderedBuilder() {
        }
    }
}

