/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block.entity.fabric;

import com.chefmooon.ubesdelight.common.block.entity.BakingMatBlockEntity;
import com.chefmooon.ubesdelight.common.block.fabric.BakingMatBlockImpl;
import com.chefmooon.ubesdelight.common.crafting.fabric.BakingMatRecipeImpl;
import com.chefmooon.ubesdelight.common.registry.UbesDelightSounds;
import com.chefmooon.ubesdelight.common.registry.fabric.UbesDelightAdvancementsImpl;
import com.chefmooon.ubesdelight.common.registry.fabric.UbesDelightBlockEntityTypesImpl;
import com.chefmooon.ubesdelight.common.registry.fabric.UbesDelightRecipeTypesImpl;
import com.chefmooon.ubesdelight.common.tag.CommonTags;
import com.chefmooon.ubesdelight.common.utility.TextUtils;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.crafting.RecipeWrapper;

public class BakingMatBlockEntityImpl
extends SyncedBlockEntity {
    public static final int MAX_INGREDIENTS = 9;
    public static final int MAX_PROCESSING_STAGES = 5;
    public static final int MAX_RESULTS = 4;
    private final ItemStackHandlerContainer inventory;
    private final ItemStackHandlerContainer inputHandler;
    private final class_1863.class_7266<RecipeWrapper, BakingMatRecipeImpl> quickCheck;

    public BakingMatBlockEntityImpl(class_2338 pos, class_2680 state) {
        super(UbesDelightBlockEntityTypesImpl.BAKING_MAT_BAMBOO.get(), pos, state);
        this.inputHandler = this.inventory = this.createHandler();
        this.quickCheck = class_1863.method_42302(UbesDelightRecipeTypesImpl.BAKING_MAT.get());
    }

    public static void init() {
        ItemStorage.SIDED.registerForBlockEntity(BakingMatBlockEntityImpl::getStorage, UbesDelightBlockEntityTypesImpl.BAKING_MAT_BAMBOO.get());
    }

    public void method_11014(class_2487 compound, class_7225.class_7874 registries) {
        super.method_11014(compound, registries);
        this.inventory.deserializeNBT(registries, compound.method_10562("Inventory"));
    }

    public void method_11007(class_2487 compound, class_7225.class_7874 registries) {
        super.method_11007(compound, registries);
        compound.method_10566("Inventory", (class_2520)this.inventory.serializeNBT(registries));
    }

    public boolean processItemUsingTool(class_1799 tool, @Nullable class_1657 player) {
        if (this.field_11863 == null) {
            return false;
        }
        Optional<class_8786<BakingMatRecipeImpl>> matchingRecipe = this.getMatchingRecipe(new RecipeWrapper((ItemStackHandler)this.inventory), tool, player);
        matchingRecipe.ifPresent(recipe -> {
            class_2371<class_1856> processStages = ((BakingMatRecipeImpl)recipe.comp_1933()).getProcessStages();
            List<class_1799> ingredientContainers = this.getInventoryContainers(this.inventory);
            class_2338 blockPos = this.method_11016();
            if (!((BakingMatRecipeImpl)recipe.comp_1933()).getProcessStages().isEmpty()) {
                if (!((Boolean)this.method_11010().method_11654((class_2769)BakingMatBlockImpl.PROCESSING)).booleanValue()) {
                    if (!ingredientContainers.isEmpty()) {
                        this.spawnResults(ingredientContainers);
                    }
                    this.field_11863.method_8501(blockPos, (class_2680)this.method_11010().method_11657((class_2769)BakingMatBlockImpl.PROCESSING, (Comparable)Boolean.valueOf(true)));
                    this.clearInventory();
                    class_1799 itemStack = Arrays.stream(((class_1856)processStages.get(0)).method_8105()).findFirst().orElse(class_1799.field_8037);
                    this.inventory.method_5447(0, itemStack);
                    BakingMatBlockEntityImpl.spawnParticles(this.field_11863, blockPos, itemStack, 5);
                    this.inventoryChanged();
                } else if (((Boolean)this.method_11010().method_11654((class_2769)BakingMatBlockImpl.PROCESSING)).booleanValue()) {
                    int currentStage = this.getProcessStage(this.inventory.method_5438(0), (List<class_1856>)processStages);
                    if (currentStage < ((BakingMatRecipeImpl)recipe.comp_1933()).getProcessStages().size() - 1) {
                        class_1799 currentStageItem = this.inventory.method_5438(0);
                        int nextStage = this.getNextProcessStage(currentStageItem, (List<class_1856>)processStages);
                        if (!((class_1856)processStages.get(nextStage)).method_8103()) {
                            this.clearInventory();
                            class_1799 nextStageItem = Arrays.stream(((class_1856)processStages.get(nextStage)).method_8105()).findFirst().orElse(class_1799.field_8037);
                            BakingMatBlockEntityImpl.spawnParticles(this.field_11863, blockPos, nextStageItem, 5);
                            this.inventory.method_5447(0, nextStageItem);
                            this.inventoryChanged();
                        }
                    } else if (currentStage == ((BakingMatRecipeImpl)recipe.comp_1933()).getProcessStages().size() - 1) {
                        this.spawnRolledResults((BakingMatRecipeImpl)recipe.comp_1933(), blockPos, this.field_11863, tool, null);
                        this.field_11863.method_8501(blockPos, (class_2680)this.method_11010().method_11657((class_2769)BakingMatBlockImpl.PROCESSING, (Comparable)Boolean.valueOf(false)));
                    }
                }
            } else {
                this.spawnRolledResults((BakingMatRecipeImpl)recipe.comp_1933(), blockPos, this.field_11863, tool, ingredientContainers);
            }
            this.triggerAdvancement(player);
            if (!this.field_11863.field_9236) {
                tool.method_7956(1, (class_3218)this.field_11863, (class_3222)player, item -> {});
            }
            this.playProcessingSound(((BakingMatRecipeImpl)recipe.comp_1933()).getSoundEvent().orElse(null), tool);
        });
        return matchingRecipe.isPresent();
    }

    private Optional<class_8786<BakingMatRecipeImpl>> getMatchingRecipe(RecipeWrapper inventoryWrapper, class_1799 toolStack, @Nullable class_1657 player) {
        if (this.field_11863 == null) {
            return Optional.empty();
        }
        Optional recipe = this.quickCheck.method_42303((class_9695)inventoryWrapper, this.field_11863);
        if (recipe.isPresent()) {
            if (((BakingMatRecipeImpl)((class_8786)recipe.get()).comp_1933()).getTool().method_8093(toolStack)) {
                return recipe;
            }
            if (player != null) {
                player.method_7353((class_2561)TextUtils.getTranslatable("tooltip.baking_mat.invalid_tool", new Object[0]), true);
            }
        } else if (player != null) {
            player.method_7353((class_2561)TextUtils.getTranslatable("tooltip.baking_mat.invalid_item", new Object[0]), true);
        }
        return Optional.empty();
    }

    private void spawnRolledResults(BakingMatRecipeImpl recipe, class_2338 blockPos, class_1937 level, class_1799 tool, @Nullable List<class_1799> containers) {
        List<class_1799> results = recipe.getRollResults(level.field_9229, class_1890.method_8225((class_6880)((class_2378)level.method_30349().method_33310(class_7924.field_41265).get()).method_40290(class_1893.field_9130), (class_1799)tool));
        if (containers != null && !containers.isEmpty()) {
            results.addAll(containers);
        }
        if (!results.isEmpty()) {
            BakingMatBlockEntityImpl.spawnParticles(level, blockPos, results.get(0).method_7972(), 5);
            this.spawnResults(results);
            this.clearInventory();
        }
    }

    private void spawnResults(List<class_1799> results) {
        for (class_1799 result : results) {
            class_2350 direction = ((class_2350)this.method_11010().method_11654((class_2769)BakingMatBlockImpl.FACING)).method_10160();
            class_1542 entity = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5 + (double)direction.method_10148() * 0.2, (double)this.field_11867.method_10264() + 0.2, (double)this.field_11867.method_10260() + 0.5 + (double)direction.method_10165() * 0.2, result.method_7972());
            entity.method_18800((double)((float)direction.method_10148() * 0.2f), 0.0, (double)((float)direction.method_10165() * 0.2f));
            this.field_11863.method_8649((class_1297)entity);
        }
    }

    private void playProcessingSound(class_3414 soundEvent, class_1799 tool) {
        this.playProcessingSound(soundEvent, tool, null);
    }

    private void playProcessingSound(@Nullable class_3414 soundEvent, class_1799 tool, @Nullable class_1799 item) {
        if (soundEvent != null) {
            this.playSound(soundEvent, 1.0f, 1.0f);
        } else if (tool.method_31573(CommonTags.C_TOOLS_ROLLING_PIN)) {
            this.playSound(UbesDelightSounds.BLOCK_BAKING_MAT_ROLLING_PIN.get(), 1.0f, 0.8f);
        }
    }

    private void playSound(class_3414 sound, float volume, float pitch) {
        if (this.field_11863 != null) {
            this.field_11863.method_43128(null, (double)((float)this.field_11867.method_10263() + 0.5f), (double)((float)this.field_11867.method_10264() + 0.5f), (double)((float)this.field_11867.method_10260() + 0.5f), sound, class_3419.field_15245, volume, pitch);
        }
    }

    private void triggerAdvancement(class_1657 player) {
        if (player instanceof class_3222) {
            UbesDelightAdvancementsImpl.USE_BAKING_MAT.get().trigger((class_3222)player);
        }
    }

    public static void spawnParticles(class_1937 level, class_2338 pos, class_1799 stack, int count) {
        for (int i = 0; i < count; ++i) {
            class_243 vec3d = new class_243(((double)level.field_9229.method_43057() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)level.field_9229.method_43057() - 0.5) * 0.1);
            if (level instanceof class_3218) {
                ((class_3218)level).method_14199((class_2394)new class_2392(class_2398.field_11218, stack), (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.1f), (double)((float)pos.method_10260() + 0.5f), 1, vec3d.field_1352, vec3d.field_1351 + 0.05, vec3d.field_1350, 0.0);
                continue;
            }
            level.method_8406((class_2394)new class_2392(class_2398.field_11218, stack), (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.1f), (double)((float)pos.method_10260() + 0.5f), vec3d.field_1352, vec3d.field_1351 + 0.05, vec3d.field_1350);
        }
    }

    private Integer getProcessStage(class_1799 itemStack, List<class_1856> processStages) {
        Integer stage = 0;
        for (int i = 0; i < processStages.size(); ++i) {
            if (processStages.get(i).method_8103()) continue;
            if (itemStack.method_31574(Arrays.stream(processStages.get(i).method_8105()).findFirst().get().method_7909())) {
                return stage;
            }
            Integer n = stage;
            stage = stage + 1;
        }
        return stage;
    }

    private Integer getNextProcessStage(class_1799 itemStack, List<class_1856> processStages) {
        Integer stage = 0;
        for (int i = 0; i < processStages.size(); ++i) {
            if (processStages.get(i).method_8103()) continue;
            if (itemStack.method_31574(Arrays.stream(processStages.get(i).method_8105()).findFirst().get().method_7909())) {
                if (i == processStages.size() - 1) {
                    return stage;
                }
                return stage + 1;
            }
            Integer n = stage;
            stage = stage + 1;
        }
        return stage;
    }

    private List<class_1799> getInventoryContainers(ItemStackHandlerContainer inventory) {
        ArrayList<class_1799> ingredientContainers = new ArrayList<class_1799>();
        for (int i = 0; i < inventory.getSlotCount(); ++i) {
            class_1799 itemStack = inventory.method_5438(i);
            if (itemStack.method_7960() || itemStack.getRecipeRemainder().method_31574(class_1802.field_8162)) continue;
            ingredientContainers.add(itemStack.getRecipeRemainder());
        }
        return ingredientContainers;
    }

    public void clearInventory() {
        this.inventory.method_5448();
    }

    public void setInventory(class_2371<class_1799> list) {
        for (int i = 0; i < 8; ++i) {
            this.inventory.method_5447(i, (class_1799)list.get(i));
        }
    }

    public int getContainerSize() {
        return 9;
    }

    public class_2371<class_1799> getItems() {
        class_2371 items = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
        for (int i = 0; i < 9; ++i) {
            items.set(i, (Object)this.inventory.method_5438(i));
        }
        return items;
    }

    public boolean isEmpty() {
        return this.inventory.method_5438(0).method_7960();
    }

    public boolean isFull() {
        return !this.inventory.method_5438(9).method_7960();
    }

    public boolean addItem(class_1799 itemStack) {
        for (int i = 0; i < this.inventory.getSlotCount(); ++i) {
            class_1799 inventoryStack = this.inventory.method_5438(i);
            if (!inventoryStack.method_7960()) continue;
            this.inventory.method_5447(i, itemStack.method_7971(1));
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public class_1799 removeItem() {
        for (int i = 8; i >= 0; --i) {
            class_1799 itemStack = this.inventory.method_5438(i);
            if (itemStack.method_7960()) continue;
            this.inventory.method_5447(i, class_1799.field_8037);
            this.inventoryChanged();
            return itemStack;
        }
        return class_1799.field_8037;
    }

    public int getItemsQuantity() {
        int items = 0;
        for (int i = 0; i <= 8; ++i) {
            class_1799 itemstack = this.inventory.method_5438(i);
            if (itemstack.method_7960()) continue;
            ++items;
        }
        return items;
    }

    public ItemStackHandlerContainer getInventory() {
        return this.inventory;
    }

    public class_241 getItemOffset(int index) {
        return BakingMatBlockEntity.getItemOffset(index);
    }

    @NotNull
    public Storage<ItemVariant> getStorage(@Nullable class_2350 side) {
        return this.inputHandler;
    }

    public void method_11012() {
        super.method_11012();
    }

    private ItemStackHandlerContainer createHandler() {
        return new ItemStackHandlerContainer(9){

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                BakingMatBlockEntityImpl.this.inventoryChanged();
            }
        };
    }
}

