/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.crafting.fabric;

import com.chefmooon.ubesdelight.common.crafting.BakingMatRecipe;
import com.chefmooon.ubesdelight.common.crafting.ingredient.ChanceResult;
import com.chefmooon.ubesdelight.common.registry.fabric.UbesDelightRecipeSerializersImpl;
import com.chefmooon.ubesdelight.common.registry.fabric.UbesDelightRecipeTypesImpl;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1662;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3414;
import net.minecraft.class_3956;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import vectorwing.farmersdelight.common.crafting.RecipeWrapper;

public class BakingMatRecipeImpl
extends BakingMatRecipe
implements class_1860<RecipeWrapper> {
    public BakingMatRecipeImpl(String group, class_2371<class_1856> ingredientList, class_2371<class_1856> processStages, class_1856 tool, class_2371<ChanceResult> resultList, Optional<class_3414> soundEvent) {
        super(group, ingredientList, processStages, tool, resultList, soundEvent);
    }

    public boolean method_8118() {
        return true;
    }

    public String method_8112() {
        return this.group;
    }

    public class_2371<class_1856> method_8117() {
        return this.ingredientList;
    }

    public class_2371<class_1856> getProcessStages() {
        return this.processStages;
    }

    public class_2371<class_1856> getIngredientsAndTool() {
        class_2371 ingredientTool = class_2371.method_10211();
        ingredientTool.addAll((Collection)this.ingredientList);
        ingredientTool.add((Object)this.tool);
        return this.ingredientList;
    }

    public class_1856 getTool() {
        return this.tool;
    }

    public class_1799 method_8110(class_7225.class_7874 provider) {
        return ((ChanceResult)this.resultList.get(0)).stack();
    }

    public List<class_1799> getResultList() {
        return this.getRollableResults().stream().map(ChanceResult::stack).collect(Collectors.toList());
    }

    public class_1799 getMandatoryResult() {
        return this.getRollableResults().stream().filter(chanceResult -> chanceResult.chance() == 1.0f).map(ChanceResult::stack).findFirst().get();
    }

    public List<class_1799> getMandatoryResults() {
        return this.getRollableResults().stream().filter(chanceResult -> chanceResult.chance() == 1.0f).map(ChanceResult::stack).toList();
    }

    public List<ChanceResult> getVariableResult() {
        return this.getRollableResults().stream().filter(chanceResult -> chanceResult.chance() != 1.0f).toList();
    }

    public class_2371<ChanceResult> getRollableResults() {
        return this.resultList;
    }

    public boolean matches(RecipeWrapper inv, class_1937 level) {
        boolean inputMatch;
        boolean processMatch = false;
        class_1662 inputList = new class_1662();
        int i = 0;
        for (int j = 0; j < 9; ++j) {
            class_1799 itemStack = inv.method_59984(j);
            if (itemStack.method_7960()) continue;
            ++i;
            inputList.method_7400(itemStack);
        }
        boolean bl = inputMatch = i == this.ingredientList.size() && inputList.method_7402((class_1860)this, null);
        if (!inputMatch && this.processStages.size() > 0 && !inputList.field_7550.isEmpty()) {
            for (class_1856 ingredient : this.processStages) {
                if (!Arrays.stream(ingredient.method_8105()).findFirst().get().method_31574(inv.method_59984(0).method_7909())) continue;
                processMatch = true;
            }
        }
        return inputMatch || processMatch;
    }

    public class_1799 assemble(RecipeWrapper inv, class_7225.class_7874 provider) {
        return ((ChanceResult)this.resultList.get(0)).stack().method_7972();
    }

    public List<class_1799> getRollResults(class_5819 rand, int fortuneLevel) {
        ArrayList<class_1799> results = new ArrayList<class_1799>();
        class_2371<ChanceResult> rollableResults = this.getRollableResults();
        for (ChanceResult output : rollableResults) {
            class_1799 stack = output.chance() == 1.0f ? output.rollOutput(rand, fortuneLevel) : output.rollStackOutput(rand, fortuneLevel);
            if (stack.method_7960()) continue;
            results.add(stack);
        }
        return results;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= this.ingredientList.size();
    }

    public class_1865<?> method_8119() {
        return UbesDelightRecipeSerializersImpl.BAKING_MAT.get();
    }

    public class_3956<?> method_17716() {
        return UbesDelightRecipeTypesImpl.BAKING_MAT.get();
    }

    public Optional<class_3414> getSoundEvent() {
        return this.soundEvent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BakingMatRecipeImpl that = (BakingMatRecipeImpl)o;
        if (!this.method_8112().equals(that.method_8112())) {
            return false;
        }
        if (!this.ingredientList.equals((Object)that.ingredientList)) {
            return false;
        }
        if (!this.processStages.equals((Object)that.processStages)) {
            return false;
        }
        if (!this.getTool().equals((Object)that.getTool())) {
            return false;
        }
        if (!this.getResultList().equals(that.getResultList())) {
            return false;
        }
        return Objects.equals(this.soundEvent, that.soundEvent);
    }

    public int hashCode() {
        int result = this.method_8112().hashCode();
        result = 31 * result + this.ingredientList.hashCode();
        result = 31 * result + this.processStages.hashCode();
        result = 31 * result + this.getTool().hashCode();
        result = 31 * result + this.getResultList().hashCode();
        result = 31 * result + (this.soundEvent != null ? this.soundEvent.hashCode() : 0);
        return result;
    }

    public static class Serializer
    implements class_1865<BakingMatRecipeImpl> {
        private static final MapCodec<BakingMatRecipeImpl> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(BakingMatRecipeImpl::method_8112), (App)class_1856.field_46096.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
            if (ingredients.isEmpty()) {
                return DataResult.error(() -> "No ingredients for baking recipe");
            }
            if (ingredients.size() > 9) {
                return DataResult.error(() -> "Too many ingredients for baking recipe! Max ingredients is 9");
            }
            class_2371 nonNullList = class_2371.method_10211();
            nonNullList.addAll((Collection)ingredients);
            return DataResult.success((Object)nonNullList);
        }, DataResult::success).forGetter(BakingMatRecipeImpl::method_8117), (App)class_1856.field_46095.listOf().fieldOf("processing_stages").flatXmap(processStages -> {
            if (processStages.size() > 5) {
                return DataResult.error(() -> "Too many processing stages for baking recipe! Max processing stages is 5");
            }
            class_2371 nonNullList = class_2371.method_10211();
            nonNullList.addAll((Collection)processStages);
            return DataResult.success((Object)nonNullList);
        }, DataResult::success).forGetter(BakingMatRecipeImpl::getProcessStages), (App)class_1856.field_46095.fieldOf("tool").forGetter(BakingMatRecipeImpl::getTool), (App)Codec.list(ChanceResult.CODEC).fieldOf("result").flatXmap(chanceResults -> {
            if (chanceResults.size() > 4) {
                return DataResult.error(() -> "Too many results for baking recipe! The maximum quantity of unique results is 4");
            }
            class_2371 nonNullList = class_2371.method_10211();
            nonNullList.addAll((Collection)chanceResults);
            return DataResult.success((Object)nonNullList);
        }, DataResult::success).forGetter(BakingMatRecipeImpl::getRollableResults), (App)class_3414.field_41698.optionalFieldOf("sound").forGetter(BakingMatRecipeImpl::getSoundEvent)).apply((Applicative)inst, BakingMatRecipeImpl::new));
        public static final class_9139<class_9129, BakingMatRecipeImpl> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<BakingMatRecipeImpl> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, BakingMatRecipeImpl> method_56104() {
            return STREAM_CODEC;
        }

        public static BakingMatRecipeImpl fromNetwork(class_9129 buf) {
            Optional holder;
            String groupIn = buf.method_10800(Short.MAX_VALUE);
            int i = buf.method_10816();
            class_2371 ingredientList = class_2371.method_10213((int)i, (Object)class_1856.field_9017);
            for (int j = 0; j < ingredientList.size(); ++j) {
                ingredientList.set(j, (Object)((class_1856)class_1856.field_48355.decode((Object)buf)));
            }
            int k = buf.method_10816();
            class_2371 processingStagesList = class_2371.method_10213((int)k, (Object)class_1856.field_9017);
            for (int l = 0; l < processingStagesList.size(); ++l) {
                processingStagesList.set(l, (Object)((class_1856)class_1856.field_48355.decode((Object)buf)));
            }
            class_1856 tool = (class_1856)class_1856.field_48355.decode((Object)buf);
            int m = buf.method_10816();
            class_2371 resultsList = class_2371.method_10213((int)m, (Object)ChanceResult.EMPTY);
            for (int n = 0; n < resultsList.size(); ++n) {
                resultsList.set(n, (Object)ChanceResult.read(buf));
            }
            Optional<class_3414> soundID = Optional.empty();
            if (buf.readBoolean() && (holder = class_7923.field_41172.method_40264(buf.method_44112(class_7924.field_41225))).isPresent() && ((class_6880.class_6883)holder.get()).method_40227()) {
                soundID = Optional.of((class_3414)((class_6880.class_6883)holder.get()).comp_349());
            }
            return new BakingMatRecipeImpl(groupIn, (class_2371<class_1856>)ingredientList, (class_2371<class_1856>)processingStagesList, tool, (class_2371<ChanceResult>)resultsList, soundID);
        }

        public static void toNetwork(class_9129 buf, BakingMatRecipeImpl recipe) {
            buf.method_10814(recipe.group);
            buf.method_10804(recipe.ingredientList.size());
            for (class_1856 ingredient : recipe.ingredientList) {
                class_1856.field_48355.encode((Object)buf, (Object)ingredient);
            }
            buf.method_10804(recipe.processStages.size());
            for (class_1856 processingStages : recipe.processStages) {
                class_1856.field_48355.encode((Object)buf, (Object)processingStages);
            }
            class_1856.field_48355.encode((Object)buf, (Object)recipe.tool);
            buf.method_10804(recipe.resultList.size());
            for (ChanceResult result : recipe.resultList) {
                result.write(buf);
            }
            if (recipe.getSoundEvent().isPresent()) {
                Optional resourceKey = class_7923.field_41172.method_29113((Object)recipe.getSoundEvent().get());
                resourceKey.ifPresentOrElse(rk -> {
                    buf.method_52964(true);
                    buf.method_44116(rk);
                }, () -> buf.method_52964(false));
            } else {
                buf.method_52964(false);
            }
        }
    }
}

