/*
 * Decompiled with CFR 0.152.
 */
package neoforge.ru.pinkgoosik.winterly.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GarlandLightsBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape EAST_SHAPE = GarlandLightsBlock.box((double)0.0, (double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)16.0);
    private static final VoxelShape WEST_SHAPE = GarlandLightsBlock.box((double)15.0, (double)3.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    private static final VoxelShape SOUTH_SHAPE = GarlandLightsBlock.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)13.0, (double)1.0);
    private static final VoxelShape NORTH_SHAPE = GarlandLightsBlock.box((double)0.0, (double)3.0, (double)15.0, (double)16.0, (double)13.0, (double)16.0);

    public GarlandLightsBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> EAST_SHAPE;
        };
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return this.canPlaceOn((BlockGetter)world, pos.relative(direction.getOpposite()));
    }

    private boolean canPlaceOn(BlockGetter world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        return !state.isAir();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state;
        if (!ctx.replacingClickedOnBlock() && (state = ctx.getLevel().getBlockState(ctx.getClickedPos().relative(ctx.getClickedFace().getOpposite()))).is((Block)this) && state.getValue((Property)FACING) == ctx.getClickedFace()) {
            return null;
        }
        state = this.defaultBlockState();
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        for (Direction direction : ctx.getNearestLookingDirections()) {
            if (!direction.getAxis().isHorizontal() || !(state = (BlockState)state.setValue((Property)FACING, (Comparable)direction.getOpposite())).canSurvive((LevelReader)world, pos)) continue;
            return state;
        }
        return null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }
}

